//HTML5 Upload by http://techslides.com
//File, Directory, Archive, or External Image Uploader using Imgur API, HTML5 FormData, ZIPjs, and Cross-Domain XHR

/* Traverse through files and directories */
function traverseFileTree(item, path) {
  path = path || "";
  if (item.isFile) {
	// Get file
	item.file(function(file) {
		if(file.type.match(/image.*/)){
			upload(file);
		}
	});
  } else if (item.isDirectory) {
	// Get folder contents
	var dirReader = item.createReader();
	dirReader.readEntries(function(entries) {
	  for (var i=0; i<entries.length; i++) {
		traverseFileTree(entries[i], path + item.name + "/");
	  }
	});
  }
}

/* Main unzip function */
function unzip(zip){
	model.getEntries(zip, function(entries) {
		entries.forEach(function(entry) {
			model.getEntryFile(entry, "Blob");
		});
	});
}

/* Dragn drop stuff */
var drag = document.getElementById("drag");

drag.ondragover = function(e) {e.preventDefault()}
drag.ondrop = function(e) {
	e.preventDefault();
	  var length = e.dataTransfer.items.length;
	  for (var i = 0; i < length; i++) {
		var entry = e.dataTransfer.items[i].webkitGetAsEntry();
		var file = e.dataTransfer.files[i];
		var zip = file.name.match(/\.zip/);
		if (entry.isFile) {
			if(zip){
				unzip(file);
			} else {
			  var file = e.dataTransfer.files[i];

			  if(file.type.match(/image.*/)){
				upload(file);
			  } else {
				document.getElementById("error").innerHTML = file.name+" is not an image.";
			  }                       
			}


		} else if (entry.isDirectory) {
		 traverseFileTree(entry);
		}
	  }
}

var files = document.getElementById("filesinput");
var directory = document.getElementById("directoryinput");
var zipinput = document.getElementById("zipinput");
var external = document.getElementById("external");
var fbutton = document.getElementById("fbutton");
var dbutton = document.getElementById("dbutton");
var zbutton = document.getElementById("zbutton");

//process files
files.addEventListener("change", function (e) {
	var files = e.target.files;
	for(i=0; i<files.length; i++) {
		var file = files[i];
		if(file.type.match(/image.*/)){
			upload(file);
		}
	}
}, false);

//process directory
directory.addEventListener("change", function (e) {
	var files = e.target.files;
	for (var i=0; i<files.length; i++) {
		var file = files[i];
		if(file.type.match(/image.*/)){
			upload(file);
		}
	}            
}, false);

//process zip archive
zipinput.addEventListener('change', function() {
	unzip(zipinput.files[0]);
}, false);


external.addEventListener("click", function (e) {
	var einput = document.getElementById("einput");
	var file = einput.value;
	//matching for ending here is not ideal since lots of image are auto generated via some other url
	//if (file.match(/\.jpg|\.gif|\.jpeg|\.png/)){
		upload(file);
	//}
}, false);

fbutton.addEventListener("click", function() {
	document.getElementById('filesinput').click();
}, false);

dbutton.addEventListener("click", function() {
	document.getElementById('directoryinput').click()
}, false);

zbutton.addEventListener("click", function() {
	document.getElementById('zipinput').click()
}, false);

/* imgur.com  ̹ εϴ  Լ */
function upload(file) {

	document.body.className = "uploading";

	/* Lets build a FormData object*/
	var fd = new FormData();
	fd.append("image", file);
	var xhr = new XMLHttpRequest();
	var output = document.getElementById("output");
	xhr.open("POST", "./addons/datauri/datauri.php");
	xhr.onload = function() {
		if(this.status==400){
			//400
		   document.getElementById("error").innerHTML = JSON.parse(xhr.responseText).data.error;
		} else {
		console.log(xhr.responseText);
			var data = JSON.parse(xhr.responseText).data;
			//id
			var id = data.id;
			//image full url
			var link = data.link;

			//̹ ǥҶ ӵ Thumbnail ҷ  url ۾
			var pathMiddle = link.lastIndexOf(".");
			var pathEnd = link.length;
			var fileName = link.substring(0, pathMiddle);
			var extName = link.substring(pathMiddle+1, pathEnd);
			
			//Attribute ߰
			var a = document.createElement("a");
			a.href = '#';
			a.setAttribute('onclick', 'insertUploadedFile(\''+link+'\',\''+data.width+'\',\''+data.height+'\');');
			
			var img = document.createElement("img");
			img.src = link; //Thumbnail - s:90*90

			a.appendChild(img);
			output.appendChild(a);

			document.body.className = "uploaded";
		}
	}
	xhr.send(fd);
}

//model for zip.js
var model = (function() {

	return {
		getEntries : function(file, onend) {
			zip.createReader(new zip.BlobReader(file), function(zipReader) {
				zipReader.getEntries(onend);
			}, onerror);
		},
		getEntryFile : function(entry, creationMethod, onend, onprogress) {
			var writer, zipFileEntry;

			function getData() {
				entry.getData(writer, function(blob) {

				//read the blob, grab the base64 data, send to upload function
				oFReader = new FileReader()
				oFReader.onloadend = function(e) {
				  upload(this.result.split(',')[1]);    
				};
				oFReader.readAsDataURL(blob);
			 
				}, onprogress);
			}
				writer = new zip.BlobWriter();
				getData();
		}
	};
})();

function insertUploadedFile(imgurl,width,height) {
	var text = [];
	editorFocus(editorSequence);

	temp_code = '';
	temp_code += "<img src=\""+imgurl+"\"";
	temp_code += " width=\""+width+"\" height=\""+height+"\"";
	temp_code += " />\r\n";
	text.push(temp_code);

	// html 
	if(editorMode[editorSequence]=='html'){
		if(text.length>0 && get_by_id('editor_textarea_'+editorSequence))
		{
			get_by_id('editor_textarea_'+editorSequence).value += text.join('');
		}

	//  
	}else{
		var iframe_obj = editorGetIFrame(editorSequence);
		if(!iframe_obj) return;
		if(text.length>0) editorReplaceHTML(iframe_obj, text.join(''));
	}
}