/*! Copyright (C) 2014 AJAXBOARD. All rights reserved. */

(function (global, $) {
	"use strict";
	global.ajaxboardStorage.connect = true;
	global.allowNotification = function () {
		Notification.requestPermission(function (permission) {
			$("#permission-description").fadeOut();
		});
	}
	global.denyNotification = function () {
		var date = new Date();
			date.setTime(date.getTime() + (30 * 24 * 60 * 60 * 1000));
		setCookie("notification_denied", "Y", date);
		$("#permission-description").fadeOut();
	};
	$(function () {
		function Plugin() {
			this.oApp = global.ajaxboard;
			var self = this;
			var triggers = [
				[ "events.broadcastMessage",      "before", "triggerBroadcastMessage" ],
				[ "events.insertDocument.detail", "before", "triggerInsertDocument"   ],
				[ "events.insertComment.detail",  "before", "triggerInsertComment"    ]
			];
			$.each(triggers, function (key, trigger) {
				self.oApp.insertTrigger(self, trigger[0], trigger[1], self[trigger[2]]);
			});
			if (Notification.permission == "default" && getCookie("notification_denied") != "Y") {
				$("#permission-description").fadeIn();
			}
		}
		Plugin.prototype = {
			triggerBroadcastMessage: function (message) {
				var onshow = function (e) {
					setTimeout(function () {
						e.currentTarget.close();
					}, 6000);
				}
				var opts = {};
				opts.body   = this.strip(message);
				opts.tag    = NOTIFICATION_ID + ":broadcastMessage:" + NOTIFICATION.length;
				opts.icon   = NOTIFICATION_ICON;
				opts.onshow = onshow;
				NOTIFICATION.push(new Notification(NOTIFICATION_BRO_TITLE, opts));
			},
			triggerInsertDocument: function (module_srl, document_srl, member_srl, title, content, nickname) {
				var redirect = this.oApp.current_url
					.setQuery("document_srl", document_srl);

				var onclick = function (e) {
					global.focus();
					location.href = redirect;
				}
				var onshow = function (e) {
					setTimeout(function () {
						e.currentTarget.close();
					}, 2000);
				}
				if ($.inArray(Number(module_srl), NOTIFICATION_USER_INFO) > -1) {
					var opts = {};
					opts.body    = this.strip(title);
					opts.tag     = NOTIFICATION_ID + "insertDocument:" + document_srl;
					opts.icon    = NOTIFICATION_ICON;
					opts.onclick = onclick;
					opts.onshow  = onshow;
					NOTIFICATION.push(new Notification(NOTIFICATION_DOC_TITLE, opts));
				}
			},
			triggerInsertComment: function (module_srl, parent_srl, comment_srl, member_srl, content, nickname) {
				var redirect = this.oApp.current_url
					.setQuery("module", "ajaxboard")
					.setQuery("act", "procAjaxboardRedirect")
					.setQuery("type", "comment")
					.setQuery("comment_srl", comment_srl);

				var onclick = function (e) {
					global.focus();
					location.href = redirect;
				}
				var onshow = function (e) {
					setTimeout(function () {
						e.currentTarget.close();
					}, 6000);
				}
				if (this.oApp.member_srl && this.oApp.member_srl != member_srl) {
					var opts = {};
					opts.body    = this.strip(content);
					opts.tag     = NOTIFICATION_ID + ":insertComment:" + comment_srl;
					opts.icon    = NOTIFICATION_ICON;
					opts.onclick = onclick;
					opts.onshow  = onshow;
					NOTIFICATION.push(new Notification(NOTIFICATION_COM_TITLE, opts));
				}
			},
			strip: function (input, allowed) {
				allowed = (
					((allowed || "") + "")
					.toLowerCase()
					.match(/<[a-z][a-z0-9]*>/g) || []
				).join("");

				var tags = /<\/?([a-z][a-z0-9]*)\b[^>]*>/gi;
				var cmts_n_php_tags = /<!--[\s\S]*?-->|<\?(?:php)?[\s\S]*?\?>/gi;

				return input
					.replace(cmts_n_php_tags, "")
					.replace(tags, function (primary, secondary) {
						return (allowed.indexOf("<" + secondary.toLowerCase() + ">") > -1 ? primary : "");
					});
			}
		};
		if (typeof Notification !== "undefined") {
			var register = new Plugin();
		}
	});
})(this, jQuery);

/* End of file */
