/**
 * AJAXBoard XE Module Javascript
 * Copyright (C) 아약스보드. All rights reserved.
 **/

(function($)
{
	AJAXBoardStatusPlugin = xe.createPlugin("AJAXBoardStatusPlugin",
	{
		init: function(parent)
		{
			var that = this;
			
			/* Register plugin to AJAXBoard App. */
			parent.registerPlugin(this);
			/* Connect to the server. */
			this.setWholeVariables().done(function()
			{
				that.connect();
			});
		},
		connect: function()
		{
			if (!(this.token && this.server_url)) return this;
			
			var query = buildQuery({
				token   : this.token,
				respond : true
			});
			
			this.socket = io(this.server_url,
			{
				query: query,
				reconnectionAttempts: 10
			});
			
			return this.bindListeners();
		},
		bindListeners: function()
		{
			if (!this.socket) return this;
			
			var that = this;
			
			this.socket.on("connect", function()
			{
				that.oApp.triggerCall("events.plugin.connect", "after");
			});
			this.socket.on("error", function(reason)
			{
				that.oApp.triggerCall("events.plugin.error", "after", [reason]);
			});
			this.socket.on("reconnect_error", function()
			{
				that.oApp.triggerCall("events.plugin.reconnect_error", "after");
			});
			this.socket.on("reconnect_failed", function()
			{
				that.oApp.triggerCall("events.plugin.reconnect_failed", "after");
			});
			
			return this;
		},
		getWholeVariablesHandler: function()
		{
			return this.oApp.procAjax(this.oApp.request_uri, "ajaxboard", "getAjaxboardConnectVariables", null, "POST", "json");
		},
		setWholeVariables: function()
		{
			var that = this;
			var ajax = this.getWholeVariablesHandler();
			
			ajax.done(function(response, status, xhr)
			{
				$.extend(xe.lang, response.lang);
				that.timeout    = response.timeout;
				that.server_url = response.server_url;
				that.token      = response.token;
			})
			.fail(function(xhr, status, error)
			{
				try {console.error("%s: %s, %o", status, error, xhr)}
				catch(e) {}
			});
			
			return ajax;
		}
	});
})(jQuery);

jQuery(function($)
{
	/* Create instance. */
	oAJAXBoardStatusPlugin = new AJAXBoardStatusPlugin(oAJAXBoard);
});