<?php
/**
 * @class  특권(privilege)
 * @author 퍼니엑스이 (contact@funnyxe.com)
 * @brief  특권(privilege) 모듈의 controller class
 **/

class privilegeController extends privilege
{

	/**
	 * @brief 초기화
	 **/
	function init()
	{
	}

	/**
	 * before_module_proc 시점에서 실행되는 트리거
	 */
	public function triggerBeforeModuleProc(&$oModule)
	{
		// 로그인 정보를 구합니다
		$logged_info = Context::get('logged_info');

		// 로그인 하지 않은 경우 트리거 실행을 종료합니다
		if(!$logged_info)
		{
			return $this->makeObject();
		}

		// 모듈 인스턴스가 아닌 경우
		if(!$oModule->module_srl)
		{
			return $this->makeObject();
		}

		$columnList = array('grant_name');

		$args = new stdClass;
		$args->member_srl = $logged_info->member_srl;
		$args->module_srl = $oModule->module_srl;
		$args->order_type = 'desc';
		$args->start_date = date('YmdHis');
		$output = executeQueryArray('privilege.getMemberGrants', $args, $columnList);

		if($output->toBool() && is_array($output->data) && count($output->data) > 0)
		{
			foreach($output->data as $key => $val)
			{
				$grant_names = explode('|', $val->grant_name);
				foreach($grant_names as $k => &$grant_name)
				{
					if($grant_name == 'is_admin' || $grant_name == 'is_site_admin' || $grant_name == 'manager')
					{
						continue;
					}
					// 게시물 수정 권한인 경우
					if($grant_name == 'modify_document')
					{
						$oDocument = getModel('document')->getDocument(Context::get('document_srl'));
						if($oDocument->isExists())
						{
							$act = Context::get('act');

							if($act === 'dispBoardWrite')
							{
								$oDocument->setGrant();
								$oModule->grant->write_document = TRUE;
							} else {
								$_SESSION['own_document'][$oDocument->get('document_srl')] = FALSE;
							}

						}
					}
					else
					{
						$oModule->grant->{$grant_name} = TRUE;
					}
				}
			}
		}

		return $this->makeObject();
	}

	function triggerCouponInsert(&$content)
	{
		$oTemplate = &TemplateHandler::getInstance();

		$content .= $oTemplate->compile($this->module_path.'tpl', 'insert_coupon');

		return $this->makeObject();
	}
}