<?php
	/**
	 * @class  privilegeAdminView
	 * @author SMaker (dowon2308@paran.com)
	 * @brief privilege module의 admin view class
	 **/

	class privilegeAdminView extends privilege {

		var $config = null;

		/**
		 * @brief 초기화
		 **/
		function init() {
			$this->setTemplatePath($this->module_path.'tpl');
		}

		/**
		 * @brief manage grant
		 */
		function dispPrivilegeAdminManageGrant() {
			$args = new stdClass;
			$args->page = Context::get('page');

			$output = executeQueryArray('privilege.getPrivilegeGrantList', $args);
			if(!$output->toBool())
			{
				return $output;
			}

			Context::set('grant_list', $output->data);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page_navigation', $output->page_navigation);

			$this->setTemplateFile('manage_grant');
		}

		/**
		 * @brief manage group
		 */
		function dispPrivilegeAdminManageGroup()
		{
			$this->setTemplateFile('manage_group');
		}

		/**
		 * 권한 추가
		 */
		function dispPrivilegeAdminInsertGrant()
		{
			$grant_srl = Context::get('grant_srl');

			// 이미 등록된 권한을 수정한다면
			if($grant_srl)
			{
				$args = new stdClass;
				$args->grant_srl = Context::get('grant_srl');

				// 등록한 권한 정보를 가져옵니다
				$output = executeQuery('privilege.getPrivilegeGrant', $args);
				if(!$output->toBool())
				{
					return $output;
				}
			}

			// memberModel 객체 생성
			$oMemberModel = getModel('member');

			// 회원 설정을 가져옵니다
			$memberConfig = $oMemberModel->getMemberConfig();
			Context::set('identifier', $memberConfig->identifier);
			Context::set('memberConfig', $memberConfig);

			$grant_info = new stdClass;

			if($output->data)
			{
				$grant_info = &$output->data;

				if($memberConfig->identifier == 'user_id')
				{
					$columnList = array('user_id');
				}
				else
				{
					$columnList = array('email_address');
				}

				// 회원 정보를 구함
				$member_info = $oMemberModel->getMemberInfoByMemberSrl($grant_info->member_srl, $columnList);

				if($memberConfig->identifier == 'user_id')
				{
					$grant_info->user_id = $member_info->user_id;
				}
				else
				{
					$grant_info->email_address = $member_info->email_address;
				}
			}

			Context::set('grant_info', $grant_info);

			$this->setTemplateFile('insert_grant');
		}

		/**
		 * 권한 삭제
		 */
		public function dispPrivilegeAdminDeleteGrant()
		{
			$grant_srl = Context::get('grant_srl');

			// privilegeModel 객체 생성
			$oPrivilegeModel = getModel('privilege');

			$output = $oPrivilegeModel->getPrivilegeGrant($grant_srl);
			if(!$output->toBool())
			{
				return $output;
			}

			if(!$output->data)
			{
				return new Object(-1, 'msg_invalid_request');
			}

			// memberModel 객체 생성
			$oMemberModel = getModel('member');

			$member_info = $oMemberModel->getMemberInfoByMemberSrl($output->data->member_srl, array('nick_name'));

			// moduleModel 객체 생성
			$oModuleModel = getModel('module');

			$module_info = $oModuleModel->getModuleInfoByModuleSrl($output->data->module_srl, array('browser_title', 'mid', 'module'));
			$xml_info = $oModuleModel->getModuleActionXml($module_info->module);

			$output->data->nick_name = &$member_info->nick_name;
			$output->data->browser_title = $module_info->browser_title;
			$output->data->mid = $module_info->mid;

			Context::set('grant_info', $output->data);
			Context::set('grant_list', get_object_vars($xml_info->grant));

			$this->setTemplateFile('grant_delete');
		}
	}