<?php
/**
 * @class  privilege
 * @author 퍼니엑스이 (admin@funnyxe.com)
 * @brief  특권 시스템 (privilege) 모듈의 high class
 **/

class privilege extends ModuleObject
{
	private $add_triggers = array(
		array('moduleObject.proc', 'privilege', 'controller', 'triggerBeforeModuleProc', 'before'),
		array('coupon.dispCouponInsert', 'privilege', 'controller', 'triggerCouponInsert', 'after')
	);

	/**
	 * @brief 설치시 추가 작업이 필요할시 구현
	 **/
	function moduleInstall()
	{
		$oModuleController = getController('module');

		// 트리거 일괄 추가
		foreach($this->add_triggers as $trigger)
		{
			$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
		}

		$oDB = DB::getInstance();
		$oDB->addIndex('privilege_grants', 'idx_member_module_srl', array('member_srl', 'module_srl'));
	}

	/**
	 * @brief 제거시 추가 작업이 필요할시 구현
	 */
	function moduleUninstall()
	{
		$oModuleController = getController('module');

		// 트리거 일괄 삭제
		foreach($this->add_triggers as $trigger)
		{
			$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
		}

		$oDB = DB::getInstance();
		$oDB->dropIndex('privilege_grants', 'idx_member_module_srl');
	}

	/**
	 * @brief 설치가 이상이 없는지 체크하는 method
	 **/
	function checkUpdate()
	{
		$oModuleModel = getModel('module');

		// 트리거 일괄 체크
		foreach($this->add_triggers as $trigger)
		{
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return TRUE;
		}

		$oDB = DB::getInstance();
		if(!$oDB->isIndexExists('privilege_grants', 'idx_member_module_srl'))
		{
			return TRUE;
		}

		return FALSE;
	}

	/**
	 * @brief 업데이트 실행
	 **/
	function moduleUpdate()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');

		// 트리거 일괄 추가
		foreach($this->add_triggers as $trigger)
		{
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
				$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
		}

		$oDB = DB::getInstance();
		if(!$oDB->isIndexExists('privilege_grants', 'idx_member_module_srl'))
		{
			$oDB->addIndex('privilege_grants', 'idx_member_module_srl', array('member_srl', 'module_srl'));
		}

		return new Object(0, 'success_updated');
	}

	/**
	 * @brief 캐시 파일 재생성
	 **/
	function recompileCache()
	{
	}
}