<?php
class privilegeAdminController extends privilege
{
	/**
	 * 권한 추가
	 */
	public function procPrivilegeAdminInsertGrant()
	{
		$obj = Context::gets('grant_srl', 'target_module', 'target_member', 'privilege_grant', 'expire_date');
		if($obj->expire_date)
		{
			$obj->expire_date = zdate($obj->expire_date, 'YmdHis235959');
		}
		else
		{
			$obj->expire_date = '99999999999999';
		}

		// moduleModel 객체 생성
		$oModuleModel = getModel('module');
		$module_info = $oModuleModel->getModuleInfoByModuleSrl($obj->target_module);

		// memberModel 객체 생성
		$oMemberModel = getModel('member');

		// 회원 설정을 가져옵니다
		$memberConfig = $oMemberModel->getMemberConfig();

		$member_srls = array();
		$member_infos = array();

		// DB 객체 생성
		$oDB = DB::getInstance();

		// 트랜젝션 시작
		$oDB->begin();

		$grant = join('|', (array)$obj->privilege_grant);

		// 권한을 수정하는 경우
		if($obj->grant_srl)
		{
			// 로그인 방식이 user_id 인 경우
			if($memberConfig->identifier == 'user_id')
			{
				$member_info = $oMemberModel->getMemberInfoByUserId($obj->target_member, array('member_srl'));
			}
			// 로그인 방식이 email_address 인 경우
			else
			{
				$member_info = $oMemberModel->getMemberInfoByEmailAddress($obj->target_member, array('member_srl'));
			}

			// 대상 회원이 존재하지 않으면
			if(!$member_info)
			{
				$oDB->rollback();
				return new Object(-1, 'msg_target_member_not_founded');
			}

			$args = new stdClass;
			$args->grant_srl = $obj->grant_srl;
			$args->module_srl = $obj->target_module;
			$args->member_srl = $member_info->member_srl;
			$args->grant_name = $grant;
			$args->expire_date = $obj->expire_date;
			$output = executeQuery('privilege.updateGrant', $args);
			if(!$output->toBool())
			{
				$oDB->rollback();
				return $output;
			}
			$msg_code = 'success_updated';
		}
		else
		{
			$target_members = explode(',', $obj->target_member);

			foreach($target_members as $key => &$identifier)
			{
				if($memberConfig->identifier == 'user_id')
				{
					$member_info = $oMemberModel->getMemberInfoByUserId($identifier, array('member_srl'));
				}
				else
				{
					$member_info = $oMemberModel->getMemberInfoByEmailAddress($identifier, array('member_srl'));
				}

				if(!$member_info)
				{
					continue;
				}

				$output = $this->insertMemberGrant($obj->target_module, $member_info->member_srl, $grant, $obj->expire_date);
				if(!$output->toBool())
				{
					$oDB->rollback();
					return $output;
				}
			}

			$msg_code = 'success_registed';
		}

		$oDB->commit();

		$this->setMessage($msg_code);

		if(!in_array(Context::getResponseMethod(), array('XMLRPC', 'JSON')))
		{
			$returnUrl = Context::get('success_return_url');
			if(!$returnUrl)
			{
				$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispPrivilegeAdminManageGrant');
			}

			$this->setRedirectUrl($returnUrl);
		}
	}

	public function procPrivilegeAdminDeleteGrant()
	{
		$grant_srl = Context::get('grant_srl');

		// privilegeModel 객체 생성
		$oPrivilegeModel = getModel('privilege');

		$output = $oPrivilegeModel->getPrivilegeGrant($grant_srl);
		if(!$output->toBool())
		{
			return $output;
		}

		if(!$output->data)
		{
			return new Object(-1, 'msg_invalid_request');
		}

		$args = new stdClass;
		$args->grant_srl = $grant_srl;

		// 권한 삭제
		$ouptut = executeQuery('privilege.deletePrivilegeGrant', $args);
		if(!$output->toBool())
		{
			return $output;
		}

		$this->setMessage('success_deleted');

		if(in_array(Context::getResponseMethod(), array('XMLRPC', 'JSON')))
		{
			$page = Context::get('page');
			$returnUrl = Context::get('success_return_url');
			if(!$returnUrl)
			{
				$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispPrivilegeAdminManageGrant', 'page', $page);
			}

			$this->setRedirectUrl($returnUrl);
		}
	}

	/**
	 * 회원 권한 추가
	 */
	public function insertMemberGrant(&$module_srl, &$member_srl, &$grant_name, $expire_date = NULL)
	{
		$args = new stdClass;
		$args->grant_srl = getNextSequence();
		$args->module_srl = $module_srl;
		$args->member_srl = $member_srl;
		$args->grant_name = $grant_name;
		$args->expire_date = $expire_date;
		return executeQuery('privilege.insertMemberGrant', $args);
	}
}