(function($){
	function in_array(needle, haystack, argStrict) {
	  //  discuss at: http://phpjs.org/functions/in_array/
	  // original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
	  // improved by: vlado houba
	  // improved by: Jonas Sciangula Street (Joni2Back)
	  //    input by: Billy
	  // bugfixed by: Brett Zamir (http://brett-zamir.me)
	  //   example 1: in_array('van', ['Kevin', 'van', 'Zonneveld']);
	  //   returns 1: true
	  //   example 2: in_array('vlado', {0: 'Kevin', vlado: 'van', 1: 'Zonneveld'});
	  //   returns 2: false
	  //   example 3: in_array(1, ['1', '2', '3']);
	  //   example 3: in_array(1, ['1', '2', '3'], false);
	  //   returns 3: true
	  //   returns 3: true
	  //   example 4: in_array(1, ['1', '2', '3'], true);
	  //   returns 4: false

	  var key = '',
		strict = !! argStrict;

	  //we prevent the double check (strict && arr[key] === ndl) || (!strict && arr[key] == ndl)
	  //in just one for, in order to improve the performance 
	  //deciding wich type of comparation will do before walk array
	  if (strict) {
		for (key in haystack) {
		  if (haystack[key] === needle) {
			return true;
		  }
		}
	  } else {
		for (key in haystack) {
		  if (haystack[key] == needle) {
			return true;
		  }
		}
	  }

	  return false;
	}

	$(function(){
		var $form = $('#insert_grant');

		var module_srl = $form.find('input[name=target_module]').val();
			module_srl = parseInt(module_srl);

		if(module_srl > 0)
		{
			$.exec_json('module.getModuleAdminModuleInfo', { module_srl : module_srl }, completeGetModuleInfo);
		}

		/**
		 * 선택 완료 버튼 클릭 시
		 */
		$('button.moduleTriggerComplete').click(function(){
			var target_module_srl = $form.find('input[name=target_module]').val();

			target_module_srl = parseInt(target_module_srl);

			if(!target_module_srl)
			{
				alert('대상 모듈을 선택해 주세요.');
				return;
			}

			$('button.moduleTriggerComplete').hide();

			$.exec_json('module.getModuleAdminModuleInfo', { module_srl : target_module_srl }, completeGetModuleInfo);
		});

		/**
		 * 삭제 버튼 클릭 시
		 */
		$('#insert_grant button.delete').click(function(){
			$('#grantList > div.x_controls').empty();
			$('#grantList').hide();
			$('#expireDate').hide()
			$('#insert_grant .btnArea').hide();
			$('button.moduleTriggerComplete').show();
		});

		function completeGetModuleInfo(data)
		{
			if(!data.module_info)
			{
				alert('대상 모듈을 찾을 수 없습니다');
				return;
			}

			$.exec_json('module.getModuleAdminGrant', { target_module : data.module_info.module, module_srl : data.module_info.module_srl }, completeGetModuleGrant, errorGetModuleGrant );
		}

		function completeGetModuleGrant(data)
		{
			$('#grantList > div.x_controls').html('');

			var node;
			var checked;
			for(var key in data.grantList)
			{
				checked = '';
				if(selectedGrantList.length > 0)
				{
					if(in_array(key, selectedGrantList))
					{
						checked = ' checked';
					}
				}

				node = $('<input type="checkbox" id="grant_' + key + '" name="privilege_grant[]" value="' + key + '"' + checked + '> <label for="grant_' + key + '" class="x_inline">' + data.grantList[key].title + '</label>');
				node.appendTo('#grantList > div.x_controls');
			}

			$('#grantList').show();
			$('#expireDate').show();
			$('#insert_grant .btnArea').show();
		}

		function errorGetModuleGrant(data)
		{
			alert(data.message);
			$('button.moduleTriggerComplete').show();
		}
	});
})(jQuery);