<?php
/*
 * ipstring to num
**/
Function ip2float($ipstring) {
	$ipnum = (float)sprintf("%u",ip2long($ipstring));
	return $ipnum;
}

/*
 * Ʈ
**/
Function float2largearray($n) {
	$result = array();
	while ($n > 0) {
		array_push($result, ($n & 0xffff));
		list($n, $dummy) = explode('.', sprintf("%F", $n/65536.0));
	}
	return $result;
}

Function largearray2float($a) {
	$factor = 1.0;
	$result = 0.0;
	foreach ($a as $element) {
		$result += ($factor * $element);
		$factor = $factor << 16;
	}
	list($result, $dummy) = explode('.', sprintf("%F", $result));
	return $result;
}

Function largearray_and($a, $b) {
	$indexes = min(count($a), count($b));
	$c = array();
	for ($i=0; $i<$indexes; $i++) {
		array_push($c, $a[$i] & $b[$i]);
	}
	return $c;
}

Function largearray_or($a, $b) {
	$indexes = max(count($a), count($b));
	$c = array();
	for ($i=0; $i<$indexes; $i++) {
		if (!isset($a[$i])) $a[$i] = 0;
		if (!isset($b[$i])) $b[$i] = 0;
		array_push($c, $a[$i] | $b[$i]);
	}
	return $c;
}

Function float_and($a, $b) {
	return largearray2float(largearray_and(float2largearray($a), float2largearray($b)));
}

Function float_or($a, $b) {
	return largearray2float(largearray_or(float2largearray($a), float2largearray($b)));
}

/*
 * ip Ȯ
 * $range 
 * :		1.2.3.4
 * ϵī:	1.2.3.*
 * :		1.2.3.0-1.2.3.255
 * cidr:	1.2.3/24 or 1.2.3.4/255.255.255.0
**/
Function ip_in_range($ip, $range) {
	if(strpos($range, '/') !== false) {
		//CIDR
		list($range, $netmask) = array_map('trim', explode('/', $range, 2));
		if (strpos($netmask, '.') !== false) {
			$nets = explode('.', $netmask);
			while(count($nets) < 4) $nets[] = '*';

			$netmask = implode('.', $nets);
			$netmask = str_replace('*', '0', $netmask);
			$netmask_dec = ip2float($netmask);
		}
		else {
			$x = explode('.', $range);
			while(count($x) < 4) $x[] = '0';

			$range = implode('.', $x);
			$wildcard_dec = pow(2, (32-$netmask)) - 1;
			$netmask_dec = ~ $wildcard_dec;
			$netmask_dec = (float)(pow(2,32) - pow(2, (32-$netmask)));
		}
		return (float_and(ip2float($ip), $netmask_dec) == float_and(ip2float($range), $netmask_dec));
	}
	elseif(strpos($range, '-') !== false) {
		//rage° - ̸ ѷ 
		list($lower, $upper) = array_map('trim', explode('-', $range, 2));
    }
	else {
		//ϵī ip ó
		//ϵī 0 and 255  ,  ip´ lower upper ϰ
		$lower = str_replace('*', '0', $range);
		$upper = str_replace('*', '255', $range);
	}

	// ip long ȯ
	$user_ip = ip2float($ip);
	$range_lower = ip2float($lower);
	$range_upper = ip2float($upper);

	// ȯ
	return (($user_ip >= $range_lower) && ($user_ip <= $range_upper));
}
?>