<?php
/* Copyright (C) ForPeople <http://forpeople.co.kr> */

/**
 * @class  ggmailingController
 * @author GG (xeadmin@forppl.com)
 * @brief  ggmailing module admin controller class
 **/

class ggmailingController extends ggmailing {

	function init() {
	}

	function triggerInsertGgmailing(&$obj) {
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig('ggmailing');

		$num = 2000;
		$obj->is_sendok = 'B';
		$args->ggmailing_module_srl = $obj->module_srl;
		
		$output = executeQueryArray('ggmailing.getBoardMemberCount',$args);
		if(!$output->toBool()) return $output;
		
		if($output->data) {
			$dmn = getFullUrl('');
			$dmn = explode('://',$dmn);
			$domain = substr($dmn[1], 0, -1);
			$domain = str_replace('www.','',$domain);

			$url = 'http://woorimail.com/index.php';
			$post_data = array(
					'act' => 'dispWwapimanagerRequest',
					'authkey' => $config->ggmailing_authkey,
					'mid' => 'auth_woorimail',
					'domain' => $domain,
					'type' => 'ggmailing'
			);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$url);
			curl_setopt($ch, CURLOPT_POST,1);
			curl_setopt($ch, CURLOPT_POSTFIELDS,$post_data);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			//curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			//curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			$response = curl_exec($ch);
			$authcheck = json_decode($response);
			curl_close($ch);
			
			//더이상 불필요
			//$obj->sender_nickname = $domain;
			//$obj->sender_email = $authcheck->user_id . '@woorimail.com';
			
			//게시판명 구하기
			$ggmodule_info = Context::get('module_info');
			$obj->board_title = $ggmodule_info->browser_title;
			$obj->title = '[메일링] '.$obj->title;
			$obj->content = '<p>'.$obj->board_title.' 게시판에 '.$obj->nick_name.' 님의 새 글이 등록되었습니다. 빨리 확인해 주세요.</p><p><a href="'.getFullUrl('','mid',$obj->mid,'document_srl',$obj->document_srl,'comment_srl',$obj->comment_srl).'" target="_blank">[바로가기]</a></p><br /><br /><br /><p>* 본 메일은 '.getFullUrl('').' 의 {nickname} 님께서 신청하신 메일링에 의해서 전송되었습니다. 더이상 메일링 알림을 받고 싶지 않으시다면 해당 사이트에 가셔서 메일링 취소 버튼을 누르시면 됩니다.</p>';
		}

		foreach($output->data as $key => $val) {
			//수신거부 제외
			$obj->ggmailing_nickname = $val->ggmailing_nickname;
			$obj->ggmailing_email = $val->ggmailing_email;
			$obj->ggmailing_member_regdate = $val->ggmailing_member_regdate;
			$ggoutput = executeQueryArray('ggmailing.getDonotsend',$obj);
			
			if(!$ggoutput->data && $obj->nick_name != $val->ggmailing_nickname && $obj->email_address != $val->ggmailing_email) {
				// 받는닉네임 세팅
				$obj->receive_nickname .= $val->ggmailing_nickname . ',';
				// 받는이메일 세팅
				$obj->receive_email .= $val->ggmailing_email . ',';
				// 회원등록일 세팅
				$obj->receive_member_regdate .= $val->ggmailing_member_regdate . ',';

				if((($key+1) % $num == 0) && $num) {
					executeQuery('ggmailing.insertGgmailingAdminSend',$obj);
					$obj->receive_nickname = '';
					$obj->receive_email = '';
					$obj->receive_member_regdate = '';
				}//endif
			} //endif
		}//endforeach
		
		if($authcheck->ggauth_check == 'OK' && $output->data) {
			$is_Amount = $authcheck->event_point + $authcheck->free_point + $authcheck->etc_point + $authcheck->pay_point;
			if(count($output->data) <= $is_Amount) {
				if($num && ($obj->receive_nickname != '' || $obj->receive_email != '')) {
					executeQuery('ggmailing.insertGgmailingAdminSend',$obj);
				}
				$this->procGgmailingBoardSendOK();
			}
		}
	} //end function

	function procGgmailingBoardSendOK() {
		$args->is_sendok = 'B';
		$output = executeQueryArray('ggmailing.getGgmailingAdminSendEmail',$args);
		if(!$output->toBool()) {
			return $output;
		}

		$oGgmailingAdminController = getAdminController('ggmailing');

		foreach($output->data as $key => $val) {
			$ggmailing_send_srl = $val->ggmailing_send_srl;
			$is_sendok = $args->is_sendok;
			$oGgmailingAdminController->procGgmailingAdminSend($ggmailing_send_srl,$is_sendok);
		}

	} //end function

}
?>