<?php
/* Copyright (C) ForPeople <http://forpeople.co.kr> */

/**
 * @class  ggmailingAdminController
 * @author GG (xeadmin@forppl.com)
 * @brief  ggmailing module admin controller class
 **/

class ggmailingAdminController extends ggmailing {

	function init() {
	}

	function procGgmailingAdminAllSendOk() {
		$args = Context::getRequestVars();

		$args->is_sendok = 'N';
		$output = executeQueryArray('ggmailing.getGgmailingAdminSendEmail',$args);
		if(!$output->toBool()) {
			return $output;
		}

		foreach($output->data as $key => $val) {
			$ggmailing_receive_nickname = $val->ggmailing_receive_nickname;
			$ggmailing_receive_email = $val->ggmailing_receive_email;

			$ggmailing_send_srl = $val->ggmailing_send_srl;
			$this->procGgmailingAdminSend($ggmailing_send_srl);
		}

		$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminSend','page',$args->page);
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);

	} //end function

	function procGgmailingAdminSendOk() {
		$args = Context::getRequestVars();
		$ggmailing_send_srl = $args->ggmailing_send_srl;
		$this->procGgmailingAdminSend($ggmailing_send_srl);

		$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminSend','page',$args->page);
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);

	} //end function

	function procGgmailingAdminSend($ggmailing_send_srl) {

		$args->ggmailing_send_srl = $ggmailing_send_srl;
		$output = executeQueryArray('ggmailing.getGgmailingAdminSendEmail',$args);
		if(!$output->toBool()) {
			return $output;
		}
		$wwoutput = $output->data[0];

		$args->is_sendok = 'W';
		//주요 도메인 카운트
		$sep_countmail = explode(',',substr(trim($wwoutput->ggmailing_receive_email),0,-1));
		$countmail->gmail = 0;$countmail->naver = 0;$countmail->daum = 0;$countmail->hanmail = 0;$countmail->yahoo = 0;$countmail->hotmail = 0;$countmail->etc = 0;$countmail->nate = 0;//초기화
		for($i=0;$i<count($sep_countmail);$i++) {
			$sep_domain = explode('@',$sep_countmail[$i]);
			if($sep_domain[1] == 'gmail.com') $countmail->gmail = $countmail->gmail+1;
			elseif($sep_domain[1] == 'naver.com') $countmail->naver = $countmail->naver+1;
			elseif($sep_domain[1] == 'daum.net') $countmail->daum = $countmail->daum+1;
			elseif($sep_domain[1] == 'hanmail.net') $countmail->hanmail = $countmail->hanmail+1;
			elseif($sep_domain[1] == 'yahoo.com') $countmail->yahoo = $countmail->yahoo+1;
			elseif($sep_domain[1] == 'hotmail.com') $countmail->hotmail = $countmail->hotmail+1;
			elseif($sep_domain[1] == 'nate.com') $countmail->nate = $countmail->nate+1;
			else $countmail->etc = $countmail->etc+1;
		}
		$wwoutput->ggmailing_countmail = 'gmail,'.$countmail->gmail.'|@|naver,'.$countmail->naver.'|@|daum,'.$countmail->daum.'|@|hanmail,'.$countmail->hanmail.'|@|yahoo,'.$countmail->yahoo.'|@|hotmail,'.$countmail->hotmail.'|@|nate,'.$countmail->nate.'|@|etc,'.$countmail->etc;
		$countmail = '';

		//authkey 구하기
		$oModuleModel = &getModel('module');
		$config = $oModuleModel->getModuleConfig('ggmailing');
		$i_authkey = $config->ggmailing_authkey;
		$i_url = 'http://woorimail.com/';
		$i_type = 'ggmailing';
		$i_mid = 'auth_woorimail';
		$i_act = 'procWwapimanagerInsertSenderData';
		$url = $i_url . "index.php";
		$post_data = array(
				"authkey" => $i_authkey,
				"mid" => $i_mid,
				"act" => $i_act,
				"ggmailing_send_srl" => $wwoutput->ggmailing_send_srl,
				"ggmailing_document_srl" => $wwoutput->ggmailing_document_srl,
				"ggmailing_title" => $wwoutput->ggmailing_title,
				"ggmailing_content" => $wwoutput->ggmailing_content,
				"ggmailing_sender_nickname" => $wwoutput->ggmailing_sender_nickname,
				"ggmailing_sender_email" => $wwoutput->ggmailing_sender_email,
				"ggmailing_receive_nickname" => substr($wwoutput->ggmailing_receive_nickname,0,-1),
				"ggmailing_receive_email" => substr($wwoutput->ggmailing_receive_email,0,-1),
				"ggmailing_countmail" => $wwoutput->ggmailing_countmail,
				"ggmailing_member_regdate" => substr($wwoutput->ggmailing_member_regdate,0,-1),
				"type_donotsend" => $config->type_donotsend,
				"is_sendok" => $args->is_sendok
			);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_POST,1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,$post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		$response = curl_exec($ch);
		curl_close($ch);
		$authcheck = json_decode($response);

		if($response) executeQuery('ggmailing.updateGgmailingAdminSend',$args);

	} //end function

	function procGgmailingAdminModuleConfig() {

		$oModuleModel = &getModel('module');
		$config = $oModuleModel->getModuleConfig('ggmailing');
		$args = Context::getRequestVars();

		unset($config);//config 초기화

		$i_url = 'http://woorimail.com/';
		$i_type = 'ggmailing';
		$i_mid = 'auth_woorimail';
		$i_act = 'dispWwapimanagerRequest';

		$dmn = getFullUrl('');
		$dmn = explode('://',$dmn);
		$domain = substr($dmn[1], 0, -1);
		$i_domain = str_replace('www.','',$domain);

		if($args->ggmailing_authkey) $i_authkey = $args->ggmailing_authkey;
		else $i_authkey = $config->ggmailing_authkey;

		$url = $i_url . 'index.php';
		$post_data = array(
				"act" => $i_act,
				"authkey" => $i_authkey,
				"mid" => $i_mid,
				"domain" => $i_domain,
				"type" => $i_type
		);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_POST,1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,$post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		$response = curl_exec($ch);
		curl_close($ch);
		$authcheck = json_decode($response);

		// OK or FALSE
		if($authcheck->ggauth_check == 'FALSE' || !$response) {
			$returnUrl = getNotEncodedUrl('','module','admin','act','dispGgmailingAdminConfig','mode','notauth');
		} else {

			foreach($args as $key => $val) {
				if($val) $config->{$key} = trim($val);
			}

			// Save
			$oModuleController = &getController('module');
			$oModuleController->insertModuleConfig('ggmailing', $config);

			$returnUrl = getNotEncodedUrl('','module','admin','act','dispGgmailingAdminConfig','mode','save_ok');
		}
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);
		
	}

	function procGgmailingAdminInsert() {
		$args = Context::getRequestVars();

		if($args->primary_key) $obj->document_srl = $args->primary_key;
		else $obj->document_srl = getNextSequence();

		$obj->title = $args->title;
		$obj->content = $args->content;
		$obj->sender_nickname = $args->sender_nickname;
		$obj->sender_email = $args->sender_email;

		executeQuery('ggmailing.insertGgmailingAdminList',$obj);
		
		//파일첨부 활성화
		$args->isvalid = 'Y';
		$args->upload_target_srl = $obj->document_srl;
		executeQuery('file.updateFileValid',$args);

		$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminList');
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);
	}

	function procGgmailingAdminUpdate() {
		$args = Context::getRequestVars();

		$obj->document_srl = $args->primary_key;
		$obj->title = $args->title;
		$obj->content = $args->content;
		$obj->sender_nickname = $args->sender_nickname;
		$obj->sender_email = $args->sender_email;

		executeQuery('ggmailing.updateGgmailingAdminList',$obj);

		//파일첨부 활성화
		$args->isvalid = 'Y';
		$args->upload_target_srl = $obj->document_srl;
		executeQuery('file.updateFileValid',$args);

		$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminList');
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);
	}

	function procGgmailingAdminList() {
		$args = Context::getRequestVars();

		// Get the configuration information
		$oModuleModel = &getModel('module');
		$config = $oModuleModel->getModuleConfig('ggmailing');
		
		if($config->sender_num > 0) $num = $config->sender_num;
		else {
			$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminConfig','mode','no_num');
			//$this->setRedirectUrl($returnUrl);
			header("Location:" . $returnUrl);
		}
$args->cx = '<br /><br /><div>귀하의 메일주소는 {member_regdate}, '.getFullUrl('').' 에서 취득하였습니다.
메일 수신을 원하지 않으시면, <a href="'.getFullUrl('').'?act=dispGgmailingDonotsend&email={email}&regdate={member_regdate}&nick_name={nickname}">[수신거부]</a>를 눌러주십시오. 수신거부처리가 이루어집니다.
(If you don’t want to receive this e-mail anymore, click <a href="'.getFullUrl('').'?act=dispGgmailingDonotsend&email={email}&regdate={member_regdate}&nick_name={nickname}">[here]</a>)</div>';
$args->co = '<br /><br /><div>{nickname}님은 {member_regdate} '.getFullUrl('').' 에서 광고 수신에 동의하셨습니다.
광고 수신을 원하지 않으시면, <a href="'.getFullUrl('').'?act=dispGgmailingDonotsend&email={email}&regdate={member_regdate}&nick_name={nickname}">[수신거부]</a>를 눌러주십시오. 수신거부처리가 이루어집니다.
(If you don’t want to receive this e-mail anymore, click <a href="'.getFullUrl('').'?act=dispGgmailingDonotsend&email={email}&regdate={member_regdate}&nick_name={nickname}">[here]</a>)</div>';

		$obj->document_srl = $args->ggmailing_document_srl;
		$obj->title = $args->title;
		if($config->type_donotsend == 'cx') $args->type_donotsend = $args->cx;
		if($config->type_donotsend == 'co') $args->type_donotsend = $args->co;
		if($config->type_donotsend == 'none') $args->type_donotsend = '';
		$obj->content = $args->content . $args->type_donotsend;

		$obj->sender_nickname = $args->sender_nickname;
		$obj->sender_email = $args->sender_email;
		//$obj->receive_group = $args->receive_group;
		//$obj->mailing_allow = $args->mailing_allow;

		$output = executeQueryArray('member.getGroup',$args);
		foreach($output->data as $key => $val) {
			$args->ggmailing_group = $val->title;
			$mg = explode('_',$args->ggmailing_group);
		}
		if($mg[0]=='m') {
			$output = executeQueryArray('ggmailing.getGgmailingAdminMemberList',$args);
			if(!$output->toBool()) return $output;
			if(!$output->data) {
				$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminSend','mode','no_member');
				//$this->setRedirectUrl($returnUrl);
				header("Location:" . $returnUrl);
			}
			foreach($output->data as $key => $val) {
				//수신거부 제외
				$obj->ggmailing_nickname = $val->ggmailing_nickname;
				$obj->ggmailing_email = $val->ggmailing_email;
				$obj->ggmailing_member_regdate = $val->ggmailing_regdate;
				$ggoutput = executeQueryArray('ggmailing.getDonotsend',$obj);
				
				if(!$ggoutput->data && $val->ggmailing_nickname && $val->ggmailing_email) {
					// 받는닉네임 세팅
					$obj->receive_nickname .= $val->ggmailing_nickname . ',';
					// 받는이메일 세팅
					$obj->receive_email .= $val->ggmailing_email . ',';
					// 회원등록일 세팅
					$obj->receive_member_regdate .= $val->ggmailing_regdate . ',';

					if((($key+1) % $num == 0) && $num) {
						executeQuery('ggmailing.insertGgmailingAdminSend',$obj);
						$obj->receive_nickname = '';
						$obj->receive_email = '';
						$obj->receive_member_regdate = '';
					}//endif
				}
			}//endforeach
			if($num && ($obj->receive_nickname != '' || $obj->receive_email != '')) executeQuery('ggmailing.insertGgmailingAdminSend',$obj);
		} elseif($args->group_srl == 'all') {

			if($args->allow_mailing == 'Y') {
				$output = executeQueryArray('ggmailing.getEmailAddrAllowList',$args);
				if(!$output->toBool()) return $output; 
			} else {
				$output = executeQueryArray('ggmailing.getEmailAddrList',$args);
				if(!$output->toBool()) return $output;
			} 

			if(!$output->data) {
				$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminSend','mode','no_member');
				//$this->setRedirectUrl($returnUrl);
				header("Location:" . $returnUrl);
			}
			foreach($output->data as $key => $val) {
				//수신거부 제외
				$obj->ggmailing_nickname = $val->nick_name;
				$obj->ggmailing_email = $val->email_address;
				$obj->ggmailing_member_regdate = $val->regdate;
				$ggoutput = executeQueryArray('ggmailing.getDonotsend',$obj);
				
				if(!$ggoutput->data && $val->nick_name && $val->email_address) {
					// 받는닉네임 세팅
					$obj->receive_nickname .= $val->nick_name . ',';
					// 받는이메일 세팅
					$obj->receive_email .= $val->email_address . ',';
					// 회원등록일 세팅
					$obj->receive_member_regdate .= $val->regdate . ',';

					if((($key+1) % $num == 0) && $num) {
						executeQuery('ggmailing.insertGgmailingAdminSend',$obj);
						$obj->receive_nickname = '';
						$obj->receive_email = '';
						$obj->receive_member_regdate = '';
					}//endif
				}
			}//endforeach

			if($num && ($obj->receive_nickname != '' || $obj->receive_email != '')) executeQuery('ggmailing.insertGgmailingAdminSend',$obj);

		} else {

			if($args->allow_mailing == 'Y') {
				$output = executeQueryArray('ggmailing.getGroupEmailAddrAllowList',$args);
				if(!$output->toBool()) return $output;
			} else {
				$output = executeQueryArray('ggmailing.getGroupEmailAddrList', $args);
				if(!$output->toBool()) return $output;
			}
			if(!$output->data) {
				$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminSend','mode','no_member');
				//$this->setRedirectUrl($returnUrl);
				header("Location:" . $returnUrl);
			}
			foreach($output->data as $key => $val) {
				//수신거부 제외
				$obj->ggmailing_nickname = $val->nick_name;
				$obj->ggmailing_email = $val->email_address;
				$obj->ggmailing_member_regdate = $val->regdate;
				$ggoutput = executeQueryArray('ggmailing.getDonotsend',$obj);
				
				if(!$ggoutput->data && $val->nick_name && $val->email_address) {
					// 받는닉네임 세팅
					$obj->receive_nickname .= $val->nick_name . ',';
					// 받는이메일 세팅
					$obj->receive_email .= $val->email_address . ',';
					// 회원등록일 세팅
					$obj->receive_member_regdate .= $val->regdate . ',';

					if((($key+1) % $num == 0) && $num) {
						executeQuery('ggmailing.insertGgmailingAdminSend',$obj);
						$obj->receive_nickname = '';
						$obj->receive_email = '';
						$obj->receive_member_regdate = '';
					}//endif
				}
			}//endforeach

			if($num && ($obj->receive_nickname != '' || $obj->receive_email != '')) executeQuery('ggmailing.insertGgmailingAdminSend',$obj);

		}

		$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminSend');
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);
	}

	function procGgmailingAdminDel() {
		$args = Context::getRequestVars();
		if($args->ggmailing_document_srl) {

			executeQuery('ggmailing.deleteGgmailingAdminList',$args);

			$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminList');
			//$this->setRedirectUrl($returnUrl);
			header("Location:" . $returnUrl);
		}
		if($args->ggmailing_send_srl) {

			executeQuery('ggmailing.deleteGgmailingAdminSend',$args);

			$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminSend');
			//$this->setRedirectUrl($returnUrl);
			header("Location:" . $returnUrl);
		}
	}

	function procGgmailingAdminMemberInsert() {
		// 기본 정보를 받음
		$args = Context::getRequestVars();
		
		@ mkdir('files/ggmailing/');
		@ chmod('files/ggmailing/',0755);
		@ mkdir('files/ggmailing/uploads/');
		@ chmod('files/ggmailing/uploads/',0755);

		$target_path = 'files/ggmailing/uploads/';

		// 파일이 없으면 되돌려 보냄
		if(!$_FILES['uploadedfile']['tmp_name']) {
			$returnUrl = getNotEncodedUrl('','module','admin','act','dispGgmailingAdminInsertmembers');
			//$this->setRedirectUrl($returnUrl);
			header("Location:" . $returnUrl);
			return;
		}

		//파일 업데이트시 기존의 파일을 싹 날림
		FileHandler::removeDir('files/ggmailing/uploads/tmp/');
		@ mkdir($target_path. 'tmp/');
		$file_tmp_name = $_FILES['uploadedfile']['tmp_name'];
		$file_name = basename($_FILES['uploadedfile']['name']);
		$file_name = sha1($file_name) . ".xls";
		$file_path = $target_path . 'tmp/' .$file_name; 
		@ move_uploaded_file($file_tmp_name, $file_path);
		@ chmod($file_path,0755);

		/** PHPExcel_IOFactory */
		include 'modules/ggmailing/classes/PHPExcel/IOFactory.php';

		$inputFileName = $file_path;
		//echo 'Loading file ',pathinfo($inputFileName,PATHINFO_BASENAME),' using IOFactory to identify the format<br />';
		$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);

		$sheetData = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true); //엑셀파일 행렬 값을 배열화

		//회원가입프로세스
		for($i=1; $sheetData[$i]; $i++) {

			$args->ggmailing_nickname = $sheetData[$i][A];
			$args->ggmailing_email = $sheetData[$i][B];
			$args->ggmailing_group = $sheetData[$i][C];

			// remove whitespace
			$checkInfos = array('ggmailing_nickname', 'ggmailing_email', 'ggmailing_group');
			$replaceStr = array("\r\n", "\r", "\n", " ", "\t", "\xC2\xAD");
			foreach($checkInfos as $val){
				if(isset($args->{$val})){
					$args->{$val} = str_replace($replaceStr, '', $args->{$val});
				}
			}

			//멤버추가
			$output = executeQueryArray('ggmailing.getGgmailingAdminMemberList', $args);
			if($output->data) { 
				foreach($output->data as $key => $val) {
					if(($val->ggmailing_group != $args->ggmailing_group) || (($val->ggmailing_email != $args->ggmailing_email) && ($val->ggmailing_group == $args->ggmailing_group))) {
						executeQuery('ggmailing.insertGgmailingAdminMember',$args);
					}
				} //end foreach
			} else {
				executeQuery('ggmailing.insertGgmailingAdminMember',$args);
			}
		} //end for
		// URL 재지정
		$returnUrl = getNotEncodedUrl('','module','admin','act','dispGgmailingAdminInsertmembers');
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);
	}//end function

	function procGgmailingAdminMemberDelete() {
		$args = Context::getRequestVars();

		executeQuery('ggmailing.deleteGgmailingAdminMember',$args);

		$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGgmailingAdminInsertmembers');
		//$this->setRedirectUrl($returnUrl);
		header("Location:" . $returnUrl);

	}
} 
?>
