<?php
/* Copyright (C) ForPeople <http://forpeople.co.kr> */

/**
 * @class  ggmailingAdminView
 * @author GG (xeadmin@forppl.com)
 * @brief  ggmailing module admin view class
 **/

class ggmailingAdminView extends ggmailing {

	function init() {
		$module_srl = Context::get('module_srl');
		if(!$module_srl && $this->module_srl) {
			$module_srl = $this->module_srl;
			Context::set('module_srl', $module_srl);
		}

		$oModuleModel = &getModel('module');

		if($module_srl) {
			$module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
			$this->module_info = $module_info;
			Context::set('module_info',$module_info);
		}

		$groupOutput = executeQueryArray('ggmailing.getGroups');
		if(!$groupOutput->data) $groupOutput->data = array();
		Context::set('group_list', $groupOutput->data);

		$config = $oModuleModel->getModuleConfig('ggmailing');
		$this->config = $config;
		Context::set('config', $config);
		
		$dmn = getFullUrl('');
		$dmn = explode('://',$dmn);
		$domain = substr($dmn[1], 0, -1);

		$url = 'http://woorimail.com/index.php';
		$post_data = array(
				'act' => 'dispWwapimanagerRequest',
				'authkey' => $config->ggmailing_authkey,
				'mid' => 'auth_woorimail',
				'domain' => $domain,
				'type' => 'ggmailing'
		);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_POST,1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,$post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		$response = curl_exec($ch);
		curl_close($ch);
		$authcheck = json_decode($response);

		if(!$authcheck->ggauth_check) $authcheck->ggauth_check = '서버점검중';
		Context::set('authcheck',$authcheck);

		$template_path = sprintf("%stpl/",$this->module_path);
		$this->setTemplatePath($template_path);
	}

	function dispGgmailingAdminPayment() {
	
		$this->setTemplateFile('payment');
	}

	function dispGgmailingAdminIndex() {
		$this->setTemplateFile('index');
	}

	function dispGgmailingAdminList() {
		$args = Context::getRequestVars();
		Context::set('args',$args);
		$oGgmailingAdminModel = &getAdminModel('ggmailing');
		$output = $oGgmailingAdminModel->getGgmailingAdminList($args);

		Context::set('mail_info', $output->data);

		// Set values of document_model::getDocumentList() objects for a template
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		//Context::set('document_list', $output->data);
		//Context::set('status_name_list', $statusNameList);
		Context::set('page_navigation', $output->page_navigation);

		$this->setTemplateFile('list');
	}

	function dispGgmailingAdminSend() {
		$args = Context::getRequestVars();
		Context::set('args',$args);
		$oGgmailingAdminModel = &getAdminModel('ggmailing');
		$output = $oGgmailingAdminModel->getGgmailingAdminSend($args);

		Context::set('mail_info', $output->data);

		// Set values of document_model::getDocumentList() objects for a template
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		//Context::set('document_list', $output->data);
		//Context::set('status_name_list', $statusNameList);
		Context::set('page_navigation', $output->page_navigation);

		$this->setTemplateFile('send');
	}

	function dispGgmailingAdminConfig() {
		$args = Context::getRequestVars();
		Context::set('args',$args);

		$this->setTemplateFile('config');
	}

	function dispGgmailingAdminInsertmembers() {
		$args = Context::getRequestVars();

		Context::set('args',$args);
		$oMemberGroup = &getModel('member');

		$groups = $oMemberGroup->getGroups();
		Context::set('groups',$groups);

		$oGgmailingAdminModel = &getAdminModel('ggmailing');
		$output = $oGgmailingAdminModel->getGgmailingAdminMemberList($args);
		Context::set('mail_info',$output->data);

		// Set values of document_model::getDocumentList() objects for a template
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		//Context::set('document_list', $output->data);
		//Context::set('status_name_list', $statusNameList);
		Context::set('page_navigation', $output->page_navigation);

		$this->setTemplateFile('insertmembers');
	}

	function dispGgmailingAdminInsert() {
		$is_update = Context::get('ggmailing_document_srl');
		if($is_update) {
			$args->ggmailing_document_srl = $is_update;
			$oGgmailingAdminModel = &getAdminModel('ggmailing');
			$output = $oGgmailingAdminModel->getGgmailingAdminEmail($args);
			foreach($output->data as $key => $val) {
				Context::set('args', $val);
			}
		}

		$this->setTemplateFile('mailing');
	}

	function dispGgmailingAdminPreview() {
		$args = Context::getRequestVars();
		$oGgmailingAdminModel = &getAdminModel('ggmailing');
		$output = $oGgmailingAdminModel->getGgmailingAdminEmail($args);
		Context::set('mail_info', $output->data);

		$this->setTemplateFile('preview');
	}

}
?>
