<?php
/**
 * @class  moneysendAdminView
 * @author 아카데미 뮤즈 (kuma@academymuze.com)
 * @brief  moneysend 모듈의 admin view 클래스
 **/

class moneysendAdminView extends moneysend
{

	/**
	 * @brief 초기화
	 **/
	function init()
	{
		// 템플릿 경로 지정 (moneysend의 경우 tpl에 관리자용 템플릿 모아놓음)
		$template_path = $this->module_path.'tpl';
		$this->setTemplatePath($template_path);

		// 관리자 페이지에서 공통으로 사용하는 js 파일 로드
		Context::addJsFile($this->module_path.'tpl/js/moneysend_admin.js');
	}

	function dispMoneysendAdminIndex()
	{
		// 스킨 목록을 구해옴
		$oModuleModel = getModel('module');
		$skin_list = $oModuleModel->getSkins($this->module_path);
		Context::set('skin_list',$skin_list);

		// 설정 구함
		$oMoneySendModel = getModel('moneysend');
		$config = $oMoneySendModel->getConfig(true);
		Context::set('config', $config);

		// 생성된 그룹 목록 구함
		$oMemberModel = getModel('member');
		$group_list = $oMemberModel->getGroups();
		Context::set('group_list', $group_list);

		// 로그인 기록 모듈이 설치되어 있는지 검사
		$oLoginlog = getClass('loginlog');
		Context::set('loginlog_installed', is_object($oLoginlog) ? true : false);

		// 템플릿 파일 지정
		$this->setTemplateFile('config');
	}

	function dispMoneysendAdminSend()
	{
		// 템플릿 파일 지정
		$this->setTemplateFile('send');
	}

	function dispMoneysendAdminSendToGroup()
	{
		// 생성된 그룹 목록 구함
		$oMemberModel = getModel('member');
		$group_list = $oMemberModel->getGroups();
		Context::set('group_list', $group_list);

		// 템플릿 파일 지정
		$this->setTemplateFile('send_group');
	}

	function dispMoneysendAdminLogList()
	{
		// 포인트 선물 내역 목록 구함
		$oMoneysendModel = getModel('moneysend');

		$args = new stdClass;
		$args->page = Context::get('page');
		$args->list_count = 30;
		$args->search_target = Context::get('search_target');
		$args->search_keyword = Context::get('search_keyword');

		$output = $oMoneysendModel->getLogList($args);
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('log_list', $output->data);
		Context::set('page_navigation', $output->page_navigation);

		// 템플릿 파일 지정
		$this->setTemplateFile('log_list');
	}

	function dispMoneysendAdminBatchLogList() {
		// 포인트 선물 내역 목록 구함
		$oMoneysendModel = getModel('moneysend');

		$args = new stdClass;
		$args->page = Context::get('page');
		$args->list_count = 30;
		$args->search_target = Context::get('search_target');
		$args->search_keyword = Context::get('search_keyword');

		$output = $oMoneysendModel->getBatchLogList($args);
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('log_list', $output->data);
		Context::set('page_navigation', $output->page_navigation);

		// 템플릿 파일 지정
		$this->setTemplateFile('batch_log_list');
	}

	function dispMoneysendAdminRevert()
	{
		// 템플릿 파일 지정
		$this->setTemplateFile('revert');
	}

	function dispMoneysendAdminDeleteLog()
	{
		$log_srl = Context::get('log_srl');
		if(!$log_srl) return new Object(-1, 'msg_invalid_request');

		$oModel = getModel('moneysend');
		$log_info = $oModel->getLogInfoByLogSrl($log_srl);
		if(!$log_info) return new Object(-1, 'msg_invalid_request');

		Context::set('log_info', $log_info);

		// 템플릿 파일 지정
		$this->setTemplateFile('delete_log');
	}
}

/* End of file : moneysend.admin.view.php */
/* Location : ./modules/moneysend/moneysend.admin.view.php */