<?php
/**
 * @class  pointsendAdminController
 * @author 아카데미뮤즈 (kuma@academymuze.com)
 * @brief  moneysend 모듈의 Admin Controller class
 **/

class moneysendAdminController extends moneysend
{
	/**
	 * @brief 초기화
	 **/
	function init()
	{
	}

	/**
	 * @brief 설정 저장
	 */ 
	function procMoneysendAdminInsertConfig()
	{
		// 입력받은 설정 항목을 구함
		$config = Context::getRequestVars();

		// 불필요한 항목 제외
		unset($config->module);
		unset($config->act);
		unset($config->body);
		unset($config->ruleset);
		unset($config->_filter);

		// 기본값 지정
		if(!$config->skin) $config->skin = 'default';
		if(!$config->use_fee) $config->use_fee = 'N';
		if(!$config->sameip_deny) $config->sameip_deny = 'N';

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('moneysend', $config);

		$this->setMessage('success_saved');

		if(!in_array(Context::getRequestMethod(), array('XMLRPC', 'JSON')))
		{
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneysendAdminIndex');
			$this->setRedirectUrl($returnUrl);
		}
	}

	/**
	 * @brief 포인트 선물 취소 (관리자용)
	 */
	function procMoneysendAdminRevert() {
		$log_srl = (int)Context::get('log_srl');
		if(!$log_srl) return new Object(-1, 'msg_invalid_request');

		$oMoneysendModel = getModel('moneysend');
		$log_info = $oMoneysendModel->getLogInfoByLogSrl($log_srl);

		$sender_srl = (int)$log_info->sender_srl;
		$receiver_srl = (int)$log_info->receiver_srl;

		if(!$sender_srl || !$receiver_srl) return new Object(-1, 'msg_invalid_request');

		$oMemberModel = getModel('member');
		$config = $oMoneysendModel->getConfig();

		$point = $log_info->money;
		$sender_money = $money;
		$receiver_money = $money;

		$sender_info = $oMemberModel->getMemberInfoByMemberSrl($sender_srl);
		$receiver_info = $oMemberModel->getMemberInfoByMemberSrl($receiver_srl);

		// 수수료에 따른 포인트 계산
		$fee_per = (int)$config->fee;
		$fee_apply_money = (int)$config->fee_apply_money;
		$fee = 0;
		if($config->use_fee == 'Y' && $fee_per && $money>=$fee_apply_money) $fee = $money * ($config->fee/100);

		$receiver_money -= $fee;

		$oMoneyController = getController('point');
		$oMoneyController->setMoney($sender_srl, $sender_money, 'add');
		$oMoneyController->setMoney($receiver_srl, $receiver_money, 'minus');

		// 쪽지 보내기
		$title = Context::getLang('moneysendc_title');
		$content = sprintf(Context::getLang('moneysendc_content2'), $sender_info->nick_name, $sender_info->user_id, $receiver_money);
		$content2 = sprintf(Context::getLang('moneysendc_content'), $receiver_info->nick_name, $receiver_info->user_id, $sender_money);

		$oCommunicationController = getController('communication');
		$oCommunicationController->sendMessage($sender_srl, $receiver_srl, $title, $content, false);
		$oCommunicationController->sendMessage($receiver_srl, $sender_srl, $title, $content2, false);

		$args = new stdClass;
		$args->log_srl = $log_srl;
		executeQuery('moneysend.deleteMoneysendLog',$args);

		if(!in_array(Context::getRequestMethod(), array('XMLRPC', 'JSON')))
		{
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneysendAdminIndex');
			$this->setRedirectUrl($returnUrl);
		}
	}

	function procMoneysendAdminSendToMember()
	{
		$obj = Context::gets('user_id', 'member_srls', 'money', 'message_title', 'message_body');

		$member_srls = array();

		if(!$obj->member_srls && $obj->user_id)
		{
			$oMemberModel = getModel('member');

			$user_ids = explode(',', $obj->user_id);
			array_walk($user_ids, create_function('&$val', '$val = trim($val);'));

			$args = new stdClass;
			$args->user_id = $obj->user_id;
			$output = executeQueryArray('moneysend.getMemberSrlByUserId', $args);
			if(!$output->toBool()) return $output;
			if(!$output->data) continue;

			foreach($output->data as $key => $val)
			{
				$member_srls[] = $val->member_srl;
			}
			$member_srls = implode(',', $member_srls);

			$obj->member_srls = $member_srls;
		}

		if(!$obj->member_srls)
		{
			return new Object(-1, 'msg_invalid_request');
		}

		$oController = getController('moneysend');
		$output = $oController->moneysendToMember($obj->member_srls, $obj->money, $obj->message_title, $obj->message_body);
		if(!$output->toBool()) return $output;

		$msg = sprintf(Context::getLang('success_member_moneygift'), $output->get('member_count'));
		$this->setMessage($msg);

		if(!in_array(Context::getRequestMethod(), array('XMLRPC', 'JSON')))
		{
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneysendAdminSend');
			$this->setRedirectUrl($returnUrl);
		}
	}

	/**
	 * @brief 일괄 포인트 선물 - 그룹별
	 */
	function procMoneysendAdminSendToGroup() {
		$cart = Context::get('cart');
		if(!$cart) return new Object(-1, 'msg_invalid_request');

		$group_srls = str_replace('|@|', ',', Context::get('cart'));
		$send_money = Context::get('money');
		$title = Context::get('message_title');
		$content = Context::get('message_body');

		$oController = getController('moneysend');
		$output = $oController->moneysendToGroup($group_srls, $send_money, $title, $content);

		$total = $output->get('group_count');
		$success = $output->get('success_group');
		$failed = $output->get('failed_group');
		$ignore = $output->get('ignore_group');

		$msg = sprintf(Context::getLang('success_group_pointgift'), $total, $success, $failed, $ignore);
		$this->setMessage($msg);


		if(!in_array(Context::getRequestMethod(), array('XMLRPC', 'JSON')))
		{
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneysendAdminSendToGroup');
			$this->setRedirectUrl($returnUrl);
		}
	}

	/**
	 * @brief 포인트 선물 내역 삭제
	 */
	function procMoneysendAdminDeleteLog() {
		$log_srl = Context::get('log_srl');
		if(!$log_srl) return new Object(-1, 'msg_invalid_request');

		// 삭제
		$oController = getController('moneysend');
		$output = $oController->deleteLog($log_srl);

		// 에러가 발생하면
		if(!$output->toBool()) return $output;

		// 메시지 지정
		$this->setMessage('success_deleted');

		if(!in_array(Context::getRequestMethod(), array('XMLRPC', 'JSON')))
		{
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneysendAdminLogList');
			$this->setRedirectUrl($returnUrl);
		}
	}
}

/* End of file : moneysend.admin.controller.php */
/* Location : ./modules/moneysend/moneysend.admin.controller.php */