<?php

/**
 * jQuery CDN XE Addon
 * @file jquerycdn.class.php
 * @author 이즈야 (izuzero@gmail.com)
 * Copyright (C) ISIZU. All rights reserved.
 **/
	
class jQueryCDNHandler extends HTMLDisplayHandler
{
	function _loadJSCSS()
	{
		$oContext = Context::getInstance();
		parent::_loadJSCSS();
		
		if (__DEBUG__)
		{
			$oContext->unloadFile('./common/js/jquery-1.x.js', 'lt IE 9');
			$oContext->unloadFile('./common/js/jquery.js', 'gte IE 9');
			$oContext->unloadFile('./common/js/jquery.js');
		}
		else
		{
			$oContext->unloadFile('./common/js/jquery-1.x.min.js', 'lt IE 9');
			$oContext->unloadFile('./common/js/jquery.min.js', 'gte IE 9');
			$oContext->unloadFile('./common/js/jquery.min.js');
		}
	}
	
	/**
	 * Import jQuery CDN files.
	 * @return void.
	 **/
	function _loadCDNJS(&$type)
	{
		$oContext = Context::getInstance();
		
		if (__DEBUG__)
		{
			if (!$type || $type == 'jquery')
			{
				$oContext->loadFile(array('///code.jquery.com/jquery-1.11.0.js', 'head', 'lt IE 9', -111000));
				$oContext->loadFile(array('///code.jquery.com/jquery-2.1.0.js', 'head', 'gte IE 9', -110000));
			}
			else if ($type == 'google')
			{
				$oContext->loadFile(array('///ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.js', 'head', 'lt IE 9', -111000));
				$oContext->loadFile(array('///ajax.googleapis.com/ajax/libs/jquery/2.1.0/jquery.js', 'head', 'gte IE 9', -110000));
			}
			else if ($type == 'microsoft')
			{
				$oContext->loadFile(array('///ajax.aspnetcdn.com/ajax/jquery/jquery-1.11.0.js', 'head', 'lt IE 9', -111000));
				$oContext->loadFile(array('///ajax.aspnetcdn.com/ajax/jquery/jquery-2.1.0.js', 'head', 'gte IE 9', -110000));
				$oContext->loadFile(array('///ajax.aspnetcdn.com/ajax/jquery.migrate/jquery-migrate-1.2.1.js', 'head', '', -110000));
			}
			if ($type != 'microsoft')
			{
				$oContext->loadFile(array('///code.jquery.com/jquery-migrate-1.2.1.js', 'head', '', -110000));
			}
		}
		else
		{
			if (!$type || $type == 'jquery')
			{
				$oContext->loadFile(array('///code.jquery.com/jquery-1.11.0.min.js', 'head', 'lt IE 9', -111000));
				$oContext->loadFile(array('///code.jquery.com/jquery-2.1.0.min.js', 'head', 'gte IE 9', -110000));
			}
			else if ($type == 'google')
			{
				$oContext->loadFile(array('///ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js', 'head', 'lt IE 9', -111000));
				$oContext->loadFile(array('///ajax.googleapis.com/ajax/libs/jquery/2.1.0/jquery.min.js', 'head', 'gte IE 9', -110000));
			}
			else if ($type == 'microsoft')
			{
				$oContext->loadFile(array('///ajax.aspnetcdn.com/ajax/jquery/jquery-1.11.0.min.js', 'head', 'lt IE 9', -111000));
				$oContext->loadFile(array('///ajax.aspnetcdn.com/ajax/jquery/jquery-2.1.0.min.js', 'head', 'gte IE 9', -110000));
				$oContext->loadFile(array('///ajax.aspnetcdn.com/ajax/jquery.migrate/jquery-migrate-1.2.1.min.js', 'head', '', -110000));
			}
			if ($type != 'microsoft')
			{
				$oContext->loadFile(array('///code.jquery.com/jquery-migrate-1.2.1.min.js', 'head', '', -110000));
			}
		}
	}
}