<?php
	class jQueryUICDN {
		public $oFrontEndFileHandler;

		static function unloadJqueryUI($cdn_name, $version = '1.10.3', $css_load = true){
			$oContext = Context::getInstance();

			$CDNStrings = array(
				'google' => array(
					'js'  => 'ajax.googleapis.com/ajax/libs/jqueryui/%s/jquery-ui.min.js',
					'css' => 'ajax.googleapis.com/ajax/libs/jqueryui/%s/themes/smoothness/jquery-ui.css'
				),
				'cdnjs' => array(
					'js'  => 'cdnjs.cloudflare.com/ajax/libs/jqueryui/%s/jquery-ui.min.js',
					'css' => 'cdnjs.cloudflare.com/ajax/libs/jqueryui/%s/css/jquery-ui.min.css'
				),
				'microsoft' => array(
					'js'  => 'ajax.aspnetcdn.com/ajax/jquery.ui/%s/jquery-ui.min.js',
					'css' => 'ajax.aspnetcdn.com/ajax/jquery.ui/%s/themes/smoothness/jquery-ui.css'
				),
				'maxcdn' => array(
					'js'  => 'code.jquery.com/ui/%s/jquery-ui.min.js',
					'css' => 'code.jquery.com/ui/%s/themes/smoothness/jquery-ui.css'
				)
			);

			$oContext->unloadJsFile('/common/js/plugins/ui/jquery-ui.min.js');
			$oContext->loadFile(array('///' . sprintf($CDNStrings[$cdn_name]['js'], $version), 'body', '' , -110000));

			if($css_load !== false){
				$oContext->unloadCSSFile('/common/js/plugins/ui/jquery-ui.min.css');
				$oContext->loadFile(array('///' . sprintf($CDNStrings[$cdn_name]['css'], $version), '', '', -110000));
			}
			return false;
		}
	}