<?php

/* Initializing layout configurations */
$li = &Context::get('layout_info');

if (!$li->layout_type)            $li->layout_type = 'mainpage';
if (!$li->search_type)            $li->search_type = 'default';
if (!$li->menu_colorset)          $li->menu_colorset = 'black';
if (!$li->use_content)            $li->use_content = 'Y';
if (!$li->lib_fa)                 $li->lib_fa = 'Y';
if (!$li->lib_fa_cdn)             $li->lib_fa_cdn = 'Y';
if (!$li->lib_jq_easing)          $li->lib_jq_easing = 'Y';
if (!$li->lib_jq_placeholder)     $li->lib_jq_placeholder = 'Y';
if (!$li->lib_cufon)              $li->lib_cufon = 'Y';
if (!$li->lib_cufon_font)         $li->lib_cufon_font = '600';
if (!$li->lib_camera_slide)       $li->lib_camera_slide = 'Y';
if (!$li->use_camera_slide)       $li->use_camera_slide = 'N';
if (!$li->use_camera_slide_thumb) $li->use_camera_slide_thumb = 'N';
if (!$li->camera_slide_pattern)   $li->camera_slide_pattern = 'none';
if (!$li->camera_slide_alignment) $li->camera_slide_alignment = 'center';

$footer_menu = &Context::get('footer_menu');
foreach ($footer_menu->list as $key=>$val)
{
	$output = array();
	
	if ($val['selected'])                   $output[] = 'active';
	if ($val === reset($footer_menu->list)) $output[] = 'first-child';
	if ($val === end($footer_menu->list))   $output[] = 'last-child';
	
	$output = implode(' ', $output);
	$footer_menu->list[$key]['class'] = $output;
}

/* Option of Integration Search */
$mid = Context::get('mid');
$act = Context::get('act');
if ($li->search_type == 'fixed' && $mid == 'IS' && $act != 'IS')
{
	$db_info     = Context::getDBInfo();
	$default_url = $db_info->default_url;
	
	unset($db_info);
	header(sprintf('Location: %s', $default_url));
}

/* initializing others */
Context::set('li', $li);
Context::set('if_migrated', version_compare(__XE_VERSION__ | __ZBXE_VERSION__, '1.7.0.0', '<'));
Context::addMetaTag('viewport', 'width=960');
Context::addBodyClass($li->layout_type);
Context::addBodyClass($li->menu_colorset);