<?php
/**
 * vi:set ts=4 sw=4 noexpandtab fileencoding=utf-8:
 * @class epayAdminView
 * @author wiley@nurigo.net
 * @brief epay admin view
 **/
class epayAdminView extends epay
{
	function epayAdminView()
	{ 
	}

	function init()
	{
		$template_path = sprintf("%stpl/",$this->module_path);
		$this->setTemplatePath($template_path);	


		// module model 객체 생성
		$oModuleModel = &getModel('module');

		// 모듈 카테고리 목록을 구함
		$module_category = $oModuleModel->getModuleCategories();
		Context::set('module_category', $module_category);

        if(Context::get('module')=='cympusadmin')
        {
            $classfile = _XE_PATH_.'modules/cympusadmin/cympusadmin.class.php';
            if(file_exists($classfile))
            {
                    require_once($classfile);
                    cympusadmin::init();
            }
        }
	}

	/**
	 * @brief 결제모듈 목록
	 **/
	function dispEpayAdminEpayList()
	{
		// 등록된 board 모듈을 불러와 세팅
		$args->sort_index = "module_srl";
		$args->page = Context::get('page');
		$args->list_count = 20;
		$args->page_count = 10;
		$args->s_module_category_srl = Context::get('module_category_srl');
		$output = executeQueryArray('epay.getEpayList', $args);
		ModuleModel::syncModuleToSite($output->data);

		// 템플릿에 쓰기 위해서 context::set
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('epay_list', $output->data);
		Context::set('page_navigation', $output->page_navigation);

		// 템플릿 파일 지정
		$this->setTemplateFile('epaylist');
	}

	function dispEpayAdminInsertEpay()
	{
		$oModuleModel = &getModel('module');
		$oEpayModel = &getModel('epay');

		$module_srl = Context::get('module_srl');
		if(!$module_srl && $this->module_srl)
		{
			$module_srl = $this->module_srl;
			Context::set('module_srl', $module_srl);
		}

		// module_srl이 넘어오면 해당 모듈의 정보를 미리 구해 놓음
		if($module_srl)
		{
			$module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
			if(!$module_info)
			{
				return new Object(-1, 'msg_invalid_request');
			}
			else
			{
				ModuleModel::syncModuleToSite($module_info);
				Context::set('module_info',$module_info);
			}
		}

		// 스킨 목록을 구해옴
		$skin_list = $oModuleModel->getSkins($this->module_path);
		Context::set('skin_list',$skin_list);

		$mskin_list = $oModuleModel->getSkins($this->module_path, "m.skins");
		Context::set('mskin_list', $mskin_list);

		// 레이아웃 목록을 구해옴
		$oLayoutModel = &getModel('layout');
		$layout_list = $oLayoutModel->getLayoutList();
		Context::set('layout_list', $layout_list);

		$mobile_layout_list = $oLayoutModel->getLayoutList(0,"M");
		Context::set('mlayout_list', $mobile_layout_list);

		// plugins
		$plugins = $oEpayModel->getPluginList();
		Context::set('plugins', $plugins);

		$this->setTemplateFile('insertepay');
	}
	
	function dispEpayAdminPluginList()
	{
		$args->page = Context::get('page');
		$output = executeQueryArray('epay.getPluginList', $args);
		if (!$output->toBool()) return $output;

		Context::set('plugins', $output->data);
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('page_navigation', $output->page_navigation);

		$this->setTemplateFile('pluginlist');
	}

	function dispEpayAdminInsertPlugin()
	{
		// plugins
		$oEpayModel = &getModel('epay');
		$plugins = $oEpayModel->getPluginsXmlInfo();
		Context::set('plugins', $plugins);

		$this->setTemplateFile('insertplugin');
	}

	function dispEpayAdminUpdatePlugin()
	{
		$oEpayModel = &getModel('epay');

		$plugin_srl = Context::get('plugin_srl');

		// plugin info
		$plugin_info = $oEpayModel->getPluginInfo($plugin_srl);
		Context::set('plugin_info', $plugin_info);

		$this->setTemplateFile('updateplugin');
	}

	function dispEpayAdminTransactions()
	{
		// transactions
		$args->page = Context::get('page');
		$output = executeQueryArray('epay.getTransactionList',$args);
		if(!$output->toBool()) return $output;
		Context::set('list', $output->data);
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('page_navigation', $output->page_navigation);

		// module instances
		$output = executeQueryArray('epay.getAllModInstList');
		$modinst_list = array();
		$list = $output->data;
		if(!is_array($list)) $list = array();
		foreach($list as $key=>$modinfo)
		{
			$modinst_list[$modinfo->module_srl] = $modinfo;
		}
		Context::set('modinst_list',$modinst_list);

		$this->setTemplateFile('transactions');
	}
}
/* End of file epay.admin.view.php */
/* Location: ./modules/epay/plugins/epay.admin.view.php */
