<?php
/**
 * vi:set sw=4 ts=4 noexpandtab fileencoding=utf-8:
 * @class  nstoreModel
 * @author NURIGO(contact@nurigo.net)
 * @brief  nstoreModel
 */
class nstoreModel extends nstore
{
	function getModuleConfig()
	{
		$oModuleModel = &getModel('module');
		$config = $oModuleModel->getModuleConfig('nstore');
		if (!$config->cart_thumbnail_width) $config->cart_thumbnail_width = 100;
		if (!$config->cart_thumbnail_height) $config->cart_thumbnail_height = 100;
		if (!$config->favorite_thumbnail_width) $config->favorite_thumbnail_width = 100;
		if (!$config->favorite_thumbnail_height) $config->favorite_thumbnail_height = 100;
		if (!$config->order_thumbnail_width) $config->order_thumbnail_width = 100;
		if (!$config->order_thumbnail_height) $config->order_thumbnail_height = 100;
		if (!$config->currency) $config->currency = 'KRW';
		if (!$config->as_sign) $config->as_sign = 'Y';
		if (!$config->decimals) $config->decimals = 0;
		if (!$config->address_input) $config->address_input = 'krzip';
		return $config;
	}

	function getNstoreAddressInfo() {
		$logged_info = Context::get('logged_info');
		if (!$logged_info) return new Object(-1, 'msg_invalid_request');

		$args->member_srl = $logged_info->member_srl;
		$args->address_srl = Context::get('address_srl');
		$output = executeQuery('nstore.getAddressInfo', $args);
		if (!$output->toBool()) return $output;
		$address = unserialize($output->data->address);
		$output->data->address = $address[0];
		$output->data->address2 = $address[1];
		$this->add('data', $output->data);
	}


	function getDefaultAddress($member_srl) {

		$args->member_srl = $member_srl;
		$args->default = 'Y';
		$output = executeQuery('nstore.getAddressList', $args);
		if (!$output->toBool()) return $output;
		$default_address = $output->data;
		if (is_array($default_address)) $default_address = $default_address[0];
		if ($default_address) return $default_address;

		$args->member_srl = $member_srl;
		$args->default = 'N';
		$output = executeQuery('nstore.getAddressList', $args);
		if (!$output->toBool()) return $output;
		$default_address = $output->data;
		if (is_array($default_address)) $default_address = $default_address[0];
		return $default_address;
	}

	function getNstoreEscrowInfo()
	{
		$logged_info = Context::get('logged_info');

		$args->order_srl = Context::get('order_srl');
		$args->member_srl = $logged_info->member_srl;
		$output = executeQuery('nstore.getEscrowInfo', $args);
		$this->add('data', $output->data);
	}

	function triggerGetProcModules(&$module_list)
	{
		$modinfo = new StdClass();
		$modinfo->module = $this->module;
		$modinfo->title = Context::getLang('shoppingmall_product');
		$module_list[$this->module] = $modinfo;
	}

	function getOrderTitle(&$item_list)
	{
		$item_count = count($item_list);

		$max_unit_price = -1;
		$title = '';
		foreach ($item_list as $key=>$val) {
			$sum = $val->price * $val->quantity;
			if ($val->price > $max_unit_price) {
				$max_unit_price = $val->price;
				$title = $val->item_name;
			}
		}
		if ($item_count > 1) $title = sprintf(Context::getLang('order_title'), $title, ($item_count-1));
		return $title;
	}


	function getOrderInfo($order_srl) 
	{
		$config = $this->getModuleConfig();

		// order info.
		$args->order_srl = $order_srl;
		$output = executeQuery('nstore.getOrderInfo', $args);
		$order_info = $output->data;

		// ordered items
		$args->order_srl = $order_srl;
		$output = executeQueryArray('nstore.getOrderItems', $args);
		$item_list = $output->data;
		if(!is_array($item_list)) $item_list = array($item_list);
		foreach ($item_list as $key=>$val) {
			$item = new nstoreItem($val, $config->currency, $config->as_sign, $config->decimals);
			/*
			if ($item->option_srl)
			{
				$item->price += ($item->option_price);
			}
			 */
			$item_list[$key] = $item;
		}

		$order_info->item_list = $item_list;

		return $order_info;
	}

	function getOrdersInfo($order_srls)
	{
		$order_srls_arr = explode(',',$order_srls);
		$order_info_arr = array();
		foreach ($order_srls_arr as $order_srl)
		{
			$order_info_arr[] = $this->getOrderInfo($order_srl);
		}
		return $order_info_arr;
	}


	function getDeliveryCompanies()
	{
		return $this->delivery_companies;
	}

	function getNproductExtraVars()
	{
		if(Context::get('extra_values')) $extra_values = Context::get('extra_values');

		$extra_var->column_type = "checkbox";
		$extra_var->column_name = "item_delivery_free";
		$extra_var->column_title = Context::getLang('cmd_delivery_fee');
		$extra_var->default_value = Context::getLang('freebie');
		$extra_var->required = "N";
		if($extra_values["nstore_extra_1"]) $extra_var->value = $extra_values["nstore_extra_1"];
		$extra_var->description = Context::getLang('about_item_delivery_fee');
		$extra_vars[] = $extra_var;

		unset($extra_var);

		$extra_var->column_type = "text";
		$extra_var->column_name = "stock";
		$extra_var->column_title = Context::getLang('cmd_stock');
		if($extra_values["nstore_extra_2"]) $extra_var->value = $extra_values["nstore_extra_2"];
		$extra_var->description = Context::getLang('about_stock');
		$extra_var->required = "N";
		$extra_vars[] = $extra_var;

		return $extra_vars;

	}

	function checkNproductExtraName($string)
	{
		if($string == "item_delivery_free" || $string == "stock")  return true;
		else return false;
	}

	function triggerMemberMenu($in_args)
	{
		$logged_info = Context::get('logged_info');
		if($logged_info && $logged_info->is_admin=='Y')
		{
			$url = getUrl('','module','nstore','act','dispNstoreAdminPurchaserInfo','member_srl',Context::get('target_srl'));
			$oMemberController = &getController('member');
			$oMemberController->addMemberPopupMenu($url, Context::getLang('cmd_purchaser_info'), '', 'popup');

 			if(Context::get('cympusadmin_menu')) $url = getUrl('','module','cympusadmin','act','dispNstoreAdminOrderManagement','search_key','member_srl','search_value',Context::get('target_srl'));
			else $url = getUrl('','module','admin','act','dispNstoreAdminOrderManagement','search_key','member_srl','search_value',Context::get('target_srl'));
			$oMemberController = &getController('member');
			$oMemberController->addMemberPopupMenu($url, '주문관리');
		}
	}

	/**
	 * @brief return module name in sitemap
	 **/
	function triggerModuleListInSitemap(&$obj)
	{
		array_push($obj, 'nstore');
	}
}
/* End of file nstore.model.php */
/* Location: ./nstore/nstore.model.php */
