<?php
/**
 * vi:set sw=4 ts=4 noexpandtab fileencoding=utf-8:
 * @class  nproduct
 * @author NURIGO(contact@nurigo.net)
 * @brief  nproduct
 */
require_once(_XE_PATH_.'modules/nproduct/nproduct.item.php');
require_once(_XE_PATH_.'modules/nproduct/ExtraItem.class.php');

define('WAIT_FOR_DEPOSIT', '1');
define('PREPARE_DELIVERY', '2');

class nproduct extends ModuleObject
{
	const ORDER_STATE_PAID = '2';
	const ORDER_STATE_COMPLETE = '3';

	function nproduct()
	{
		$this->ORDER_STATE_COMPLETE = nproduct::ORDER_STATE_COMPLETE;
		$this->ORDER_STATE_PAID = nproduct::ORDER_STATE_PAID;
		$this->order_status = array('0'=>'카트보관', '1'=>'입금대기', '2'=>'입금완료', '3'=>'구매완료','A'=>'취소','B'=>'반품,교환','C'=>'환불');
	}

	function getOrderStatus()
	{
		static $trans_flag = FALSE;

		if ($trans_flag) return $this->order_status;
		foreach ($this->order_status as $key => $val)
		{
			if (Context::getLang($val)) $this->order_status[$key] = Context::getLang($val);
		}
		$trans_flag = TRUE;
		return $this->order_status;
	}


	/**
	 * @brief 모듈 설치 실행
	 **/
	function moduleInstall()
	{
		$oModuleModel = &getModel('module');
		$oModuleController = &getController('module');
		return new Object();
	}

	/**
	 * @brief 설치가 이상없는지 체크
	 **/
	function checkUpdate()
	{
		$oModuleModel = &getModel('module');
		$oDB = &DB::getInstance();
				
		//extra_Vars check
		$output = $this->checkModuleExtraVars();
		if($output == 'true') return true;

		// 2013. 09. 25 when add new menu in sitemap, custom menu add
		if(!$oModuleModel->getTrigger('menu.getModuleListInSitemap', 'nproduct', 'model', 'triggerModuleListInSitemap', 'after')) return true;

		// 2013/10/29
		if(!$oDB->isColumnExists('nproduct_items', 'updatetime')) return true;

		return false;
	}

	function checkModuleExtraVars($condition = null)
	{
		$oModuleModel = &getModel('module');
		$oModuleAdminModel = &getAdminModel('module');
		$oNproductModel =  &getModel('nproduct');

		$args->module = 'nproduct';
		$output = $oModuleAdminModel->getModuleMidList($args); // module_list get

		if($output->data)
		{
			foreach($output->data as $k => $v)
			{
				// proc_module get
				$extra_output = $oModuleModel->getModuleExtraVars($v->module_srl);
				$proc_module = $extra_output[$v->module_srl]->proc_module;


				// default extra_vars
				$default_extra_forms = $oNproductModel->getNproductExtraVars($proc_module);

				if($default_extra_forms)
				{
					// current extra_vars
					$item_extra_output = $oNproductModel->getItemExtraByModuleSrl($v->module_srl);
					if($item_extra_output)
					{
						$item_extra = array();
						foreach($item_extra_output as $key => $val)
						{
							$item_extra[] = $val->column_name;
						}
					}

					if(!$item_extra_output)
					{
						if($condition == 'install') $this->updateExtraVars($v->module_srl);
						else return 'true';
					}
					else
					{
						foreach($default_extra_forms as $key => $val)
						{
							if(!in_array($val->column_name, $item_extra))
							{
								if($condition == 'install') $this->updateExtraVars($v->module_srl, $val->column_name);
								else return 'true';
							}
						}
					}
				}
			}
		}
	}

	function updateExtraVars($module_srl, $condition=null)
	{
		$oModuleModel =  &getModel('module');
		$oNproductModel =  &getModel('nproduct');
		$oNprocutAdminController = &getAdminController('nproduct');
		$module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
		if(!$module_info) return;

		$default_extra_forms = $oNproductModel->getNproductExtraVars($module_info->proc_module);

		if($default_extra_forms)
		{
			foreach($default_extra_forms as $key=>$val)
			{
				$extra->module_srl = $module_srl;
				$extra->column_type = $val->column_type;
				$extra->column_name = $val->column_name;
				$extra->column_title = $val->column_title;
				$extra->default_value = explode("\n", str_replace("\r", '',$val->default_value));
				$extra->required = $val->required;
				$extra->is_active = (isset($extra->required));
				$extra->description = $val->description;

				if($condition)
				{
					if($condition == $val->column_name)
					{
						$output = $oNprocutAdminController->insertItemExtra($extra);
						unset($extra);
					}
				}
				else
				{
					$output = $oNprocutAdminController->insertItemExtra($extra);
					unset($extra);
				}
			}
		}
	}

	/**
	 * @brief 업데이트(업그레이드)
	 **/
	function moduleUpdate()
	{
		$oDB = &DB::getInstance();
		$oModuleModel = &getModel('module');
		$oModuleController = &getController('module');

		// 2013. 09. 25 when add new menu in sitemap, custom menu add
		if(!$oModuleModel->getTrigger('menu.getModuleListInSitemap', 'nproduct', 'model', 'triggerModuleListInSitemap', 'after'))
			$oModuleController->insertTrigger('menu.getModuleListInSitemap', 'nproduct', 'model', 'triggerModuleListInSitemap', 'after');

		$this->checkModuleExtraVars('install');

		// 2013/10/29
		if(!$oDB->isColumnExists('nproduct_items', 'updatetime')) $oDB->addColumn('nproduct_items', 'updatetime', 'date');

		return new Object(0, 'success_updated');
	}

	function moduleUninstall()
	{
		$oModuleController = &getController('module');
	}

	/**
	 * @brief 캐시파일 재생성
	 **/
	function recompileCache()
	{
	}
}
/* End of file nproduct.class.php */
/* Location: ./nproduct/nproduct.class.php */
