<?php
	/**
	 * @class  cashController
     * @author CONORY (http://www.conory.com)
	 * @brief Controller class of money modules
	 */
	class moneyController extends money
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}
		
		/**
		 * @brief ĳ
		 */
		function setMoney($member_srl, $money, $mode = null)
		{
			$member_srl = abs($member_srl);
			$mode_arr = array('add', 'minus', 'update');
			if(!$mode || !in_array($mode,$mode_arr)) $mode = 'update';
			
			$oMemberModel = &getModel('member');
			$oModuleModel = &getModel('module');
			$oMoneyModel = &getModel('money');
			$prev_money = $oMoneyModel->getMoney($member_srl, true);
			$config = $oModuleModel->getModuleConfig('money');		
		
			// ĳ  Ǵ 
			$args = new stdClass();
			$args->member_srl = $member_srl;
			$args->money = $prev_money;

			switch($mode)
			{
				case 'add' :
					$args->money += $money;
					break;
				case 'minus' :
					$args->money -= $money;
					break;
				case 'update' :
					$args->money = $money;
					break;
			}
			if($args->money < 0) $args->money = 0;

			// Call a trigger (before)
			$trigger_output = ModuleHandler::triggerCall('money.setMoney', 'before', $args);
			if(!$trigger_output->toBool()) return $trigger_output;
			
			if($oMoneyModel->isExistsMoney($member_srl)) executeQuery("money.updateMoney", $args);
			else executeQuery("money.insertMoney", $args);
			
			//ĳ  ׷캯
			$money_group = $config->money_group;
			if($money_group && is_array($money_group) && count($money_group)){
				$default_group = $oMemberModel->getDefaultGroup();
				$del_group_list = array();
				$new_group_srls = array();
				asort($money_group);

				// ׷ ʱȭ   ׷ ο
				if($config->group_reset != 'N'){
					foreach($money_group as $group_srl => $target_money){
						$del_group_list[] = $group_srl;
					}	
					$del_group_list[] = $default_group->group_srl;
					
					for($i=$args->money; $i > 0; $i--){
						if(in_array($i, $money_group)){
							foreach($money_group as $group_srl => $target_money){
								if($target_money == $i) $new_group_srls[] = $group_srl;
							}
							break;	
						}	
					}
					
					// ׷츸 ο
				}else{
					foreach($money_group as $group_srl => $target_money){
						$del_group_list[] = $group_srl;
						if($target_money <= $args->money) $new_group_srls[] = $group_srl;
					}
				}
				
				if(!$new_group_srls[0]) $new_group_srls[0] = $default_group->group_srl;
				
				// ׷
				if($del_group_list && count($del_group_list))
				{
					$del_group_args = new stdClass();
					$del_group_args->member_srl = $member_srl;
					$del_group_args->group_srl = implode(',', $del_group_list);
					$del_group_output = executeQuery('money.deleteMemberGroup', $del_group_args);
				}
				// ׷ο
				foreach($new_group_srls as $group_srl)
				{
					$new_group_args = new stdClass();
					$new_group_args->member_srl = $member_srl;
					$new_group_args->group_srl = $group_srl;
					executeQuery('member.addMemberToGroup', $new_group_args);
				}
			}
			
			// ĳ 
			$cache_path = sprintf('./files/member_extra_info/money/%s/', getNumberingPath($member_srl));
			FileHandler::makedir($cache_path);

			$cache_filename = sprintf('%s%d.cache.txt', $cache_path, $member_srl);
			FileHandler::writeFile($cache_filename, $args->money);
			
			// Call a trigger (after)
			$trigger_output = ModuleHandler::triggerCall('money.setMoney', 'after', $args);
			if(!$trigger_output->toBool()) return $trigger_output;
			
			$oModuleModel = &getModel('module');
			$module_config = $oModuleModel->getModuleConfig('money');
			
			//ĳ Ǹ ˸ ߼
			if($module_config->message_money_add=='Y' && ($args->money > $prev_money)){
				$title = sprintf(Context::getLang('send_message_money_add'),$args->money - $prev_money);
				$content = sprintf(Context::getLang('send_message_money_add'),$args->money - $prev_money);
				$oCommunicationController = &getController('communication');
				$oCommunicationController->sendMessage($args->member_srl, $args->member_srl, $title, $content, true);
			}
		
			return $output;
		}
	
	}