<?php
	/**
	 * @class  moneyAdminController
     * @author Academy MUze (http://www.muzevillage.com)
	 * @brief The admin controller class of the money module
	 */
	
	class moneyAdminController extends money 
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}

	/**
	 * @brief  
	 */
	function procMoneyAdminInsertConfig()
	{
		$args = Context::getRequestVars();

		//
		$config->message_money_add = $args->message_money_add;
		$config->group_reset = $args->group_reset;
		
		$oMemberModel = &getModel('member');
		$group_list = $oMemberModel->getGroups();	
		
		// ׷캰 
		foreach($group_list as $group){
			if($group->is_admin == 'Y' || $group->is_default == 'Y') continue;
			$group_srl = $group->group_srl;
			if($args->{'money_group_'.$group_srl}){
				$config->money_group[$group_srl] = $args->{'money_group_'.$group_srl};
			}else{
				unset($config->money_group[$group_srl]);
			}
		}
		
		$oModuleController = &getController('module');
		$oModuleController->insertModuleConfig('money', $config);

		$this->setMessage('success_updated');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneyAdminConfig');
		$this->setRedirectUrl($returnUrl);
	}
	
		/**
		 * @brief ĳ Ʈ
		 */
		function procMoneyAdminUpdateMoney()
		{
			$member_srl = Context::get('member_srl');
			$money = Context::get('money');

			preg_match('/^(\+|-)?([1-9][0-9]*)$/', $money, $m);

			$action = '';
			switch($m[1])
			{
				case '+':
					$action = 'add';
					break;
				case '-':
					$action = 'minus';
					break;
				default:
					$action = 'update';
					break;
			}
			$money = $m[2];

			$oMoneyController = &getController('money');
			$output = $oMoneyController->setMoney($member_srl, (int)$money, $action);

			$this->setError(-1);
			$this->setMessage('success_updated', 'info');

			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneyAdminMoneyList');
			return $this->setRedirectUrl($returnUrl, $output);
		}

	}