<?php
	if (!defined('__ZBXE__')) exit();

	/**
	 * @file langfilter.addon.php
	 * @author lispro06 (suritam9.pe.kr)
	 * @brief 언어기반 스팸 필터
	 *
	 * 게시글 내용을 언어기반으로 확인해 스팸 판단 및 필터링을 합니다.
	 **/
$message="스팸으로 의심되어 차단되었습니다.";

	 $logged_info = Context::get('logged_info');
	 
// 애드온 작동 액션 : procBoardInsertDocument(글쓰기), procBoardInsertComment(댓글달기)
    if (Context::get('act') != 'procBoardInsertDocument' && Context::get('act') != 'procBoardInsertComment')
        return;

if($logged_info->is_admin != 'Y' && $called_position == 'before_module_proc') {
		$content=Context::get('content');
		if(strlen($content)<1){
			$is_spam = true;
		}else{
			preg_match_all('!['
				.'\x{0061}-\x{007a}|\x{0041}-\x{005a}'
				.']+!u', $content, $match);
			$arr['eng']=count($match[0]);
			//  한글
			preg_match_all('!['
				.'\x{1100}-\x{11ff}\x{3130}-\x{318f}\x{ac00}-\x{d7af}'
				.']+!u', $content, $match2);
			$arr['kor']=count($match2[0]);
			  
			//  한자
			preg_match_all('!['
				.'\x{2E80}-\x{2EFF}'// 한,중,일 부수 보충
				.'\x{31C0}-\x{31EF}\x{3200}-\x{32FF}'
				.'\x{3400}-\x{4DBF}\x{4E00}-\x{9FBF}\x{F900}-\x{FAFF}'
				.'\x{20000}-\x{2A6DF}\x{2F800}-\x{2FA1F}'// 한,중,일 호환한자
				.']+!u', $content, $match3);
			$arr['han']=count($match3[0]);
			  
			//  일어
			preg_match_all('!['
				.'\x{3040}-\x{309F}'// 히라가나
				.'\x{30A0}-\x{30FF}'// 가타카나
				.'\x{31F0}-\x{31FF}'// 가타카나 음성 확장
				.']+!u', $content, $match4);
			$arr['jap']=count($match4[0]);
			$sum=array_sum($arr);
			$kr=100*round($arr['kor']/$sum, 2);
			$en=100*round($arr['eng']/$sum, 2);
			$ha=100*round($arr['han']/$sum, 2);
			$jp=100*round($arr['jap']/$sum, 2);
			$eng	= $addon_info->target1;		# 영어
			$kor	= $addon_info->target2;		# 한글
			$han	= $addon_info->target3;		# 한자
			$jap	= $addon_info->target4;		# 일어
				if($addon_info->act_type=="korless"){
					if($arr['kor']==0){
						$is_spam = true;
						if(strlen($logged_info->user_name)>1){
							$logged_info->user_name="";
							$logged_info->member_srl="";
							$logged_info->nick_name="";
						}else{
							Context::set('content', "");
							Context::set('nick_name', "");
							Context::set('title', "");
						}
					}
				}elseif($addon_info->act_type=="manual"){
					if($kor<$kr||$eng<$en||$han<$ha||$jap<$jp){
						$is_spam = true;
						if(strlen($logged_info->user_name)>1){
							$logged_info->user_name="";
							$logged_info->member_srl="";
							$logged_info->nick_name="";
						}else{
							Context::set('content', "");
							Context::set('nick_name', "");
							Context::set('title', "");
						}
					}
				}
		}
}

if($is_spam) {
	$output = new Object(-1, $message);
}
?>
