<?php
	if(!defined('__XE__')) exit();
	if($called_position != 'before_module_proc') return;
	if($this->act != 'procBoardInsertDocument') return;

	require_once('./addons/url_shortener/url_shortener.lib.php');
	
	$obj = Context::getRequestVars();

	$api_key = $addon_info->api_key;
	$domain_type = $addon_info->domain_type;
	
	$content = $obj->content;
	$content = url_shortener_autolink($content, 200, ' target="_blank"');

	$html = url_shortener_str_get_html($content);

	$text_array = $html->find('text');
	if(is_array($text_array) && count($text_array) > 0) {
		foreach($text_array as &$element) {
			$tag = $element->parent->tag;
			if($tag == 'a') continue;
			$element->innertext = preg_replace('/((http|ftp|https):\/\/[\w-]+(\.[\w-]+)+([\w.,@?^=%&amp;:\/~+#-]*[\w@?^=%&amp;\/~+#-])?)/', '<a href="\1" target="_blank">\1</a>', $element->innertext);
		}
	}
	
	$content = $html->save();
	$html = url_shortener_str_get_html($content);
	
	$a_array = &$html->find('a');
	if(is_array($a_array) && count($a_array) > 0) {
		foreach($a_array as &$element) {
			$link = $element->href;
			$shorten_link = FileHandler::getRemoteResource('http://shortener.kr/api?key='.$api_key.'&domain='.$domain_type.'&url='.urlencode(htmlspecialchars_decode($link)));
			if(preg_match('/\b(https?:\/\/(.+?))\b/', $shorten_link)) $element->href = $shorten_link;
		}
	}
		
	$content = $html->save();
	Context::set('content', $content, true);
?>