<?php
/**
 * @author Elkha <m@elkha.kr>
 * http://elkha.kr/
 **/

if($called_position!='before_display_content') return;
isset($oContext) || $oContext = &Context::getInstance();
if($oContext->getResponseMethod()!='HTML') return;
if($oContext->get('module')=='admin') return;
if($oModule->module_info->module_type=='controller') return;
if($addon_info->apply=='is_admin')
{
	isset($logged_info) || $logged_info = $oContext->get('logged_info');
	if($logged_info->is_admin!='Y') return;
}


$addon_info->html_gzip = (int)$addon_info->html_gzip;
// 1순위: 서버에서 설정한 output_handler 옵션.
if(strlen(ini_get('output_handler')))
{
	$this->gz_enabled = FALSE;
}
// 2순위: 애드온에서 설정한 '자동' 으로 설정하고 zlib 가능한 경우
else if(!$addon_info->html_gzip && $this->gz_enabled && extension_loaded('zlib'))
{
	$this->gz_enabled = FALSE;
	ini_set('zlib.output_compression', 4096);
	ini_set('zlib.output_compression_level', 5);
}
// 3순위: ob_gzhandler 해제
else if($addon_info->html_gzip > 20)
{
	$this->gz_enabled = FALSE;
	// zlib.output_compression 적용 (가능한 경우)
	if($addon_info->html_gzip/*%10 == 2*/ == 22 && extension_loaded('zlib'))
	{
		ini_set('zlib.output_compression', 4096);
		ini_set('zlib.output_compression_level', 5);
	}
}


// ie인 경우 php - js/css 압축을 무조건 해제함.
if(preg_match('/(?i)msie [6-8]/',$_SERVER['HTTP_USER_AGENT']))
{
	$addon_info->zipped_css_php = FALSE;
	$addon_info->zipped_js_php = FALSE;
}
else
{
	$addon_info->zipped_js_php = stripos($addon_info->zipped_javascript, 'php')!==FALSE;
	$addon_info->zipped_css_php = stripos($addon_info->zipped_css, 'php')!==FALSE;
}
// js,css 압축옵션 어케할지.

$db_info = $oContext->getDBInfo();

// config->ob_start = TRUE 인 경우 ob_start 통해 몽땅 묶음.
$addon_info->ob_start = !$this->gz_enabled;
$addon_info->path = _XE_PATH_;
$addon_info->web_root = preg_replace('#^[^/]+//[^/]+(/.*)$#', '\1', $db_info->default_url);

if(strlen($addon_info->exclude_dir = trim($addon_info->exclude_dir)))
	$addon_info->exclude_dir = preg_quote($addon_info->exclude_dir, '/') . ' ';
else
	$addon_info->exclude_dir = '';

// 웹인 경우 무조건 패스.
$addon_info->exclude_dir .= '^(?:https?:)?\/\/';
$addon_info->exclude_dir = '/' . preg_replace('/[\s]+/s', '|', $addon_info->exclude_dir) . '/iu';

class_exists('Trimmed') || include( dirname(__FILE__) . '/Trimmed.class.php');
$oTrim = &Trimmed::getInstance();
$oTrim->setConfig($addon_info);

// js files 1.7
if(isset($oContext->oFrontEndFileHandler))
{
	$oHandler = &$oContext->oFrontEndFileHandler;

	if($addon_info->zipped_javascript!='N')
	{
		function_exists('zipped_xe_17') || include(dirname(__FILE__) . '/zipped_xe_17.function.php');
		foreach($oHandler->jsHeadMap as &$val)
			zipped_xe_17($val, $oTrim, $oHandler);
		foreach($oHandler->jsBodyMap as &$val)
			zipped_xe_17($val, $oTrim, $oHandler);
	}
	if($addon_info->zipped_css!='N')
	{
		function_exists('zipped_xe_17') || include(dirname(__FILE__) . '/zipped_xe_17.function.php');
		foreach($oHandler->cssMap as &$val)
			zipped_xe_17($val, $oTrim, $oHandler);
	}
}
// js files 1.4
/*else
{
	if($addon_info->zipped_javascript!='N')
	{
		function_exists('zipped_xe_14') || include(dirname(__FILE__) . '/zipped_xe_14.function.php');
		$extension = 'js';
		foreach($oContext->js_files_map as &$val)
		{
			zipped_xe_14($val, $oTrim, $extension);
		}
	}
	if($addon_info->zipped_css!='N')
	{
		$extension = 'css';
		function_exists('zipped_xe_14') || include(dirname(__FILE__) . '/zipped_xe_14.function.php');
		zipped_xe_14($oContext->css_files_map, $oTrim, $extension);
	}
}*/

if($addon_info->html_gzip!=9)
{
	$oTrim->trim($output);
	$oTrim->trim($oContext->body_header);
	$oTrim->trim($oContext->html_header);
	$oTrim->trim($oContext->html_footer);
}
?>