<?php
/**
 * @class Trimmed
 * @author Elkha <m@elkha.kr>
 * http://elkha.kr/
 **/

class Trimmed
{
	var $version = '0.2';

	// auto 아닌 값을 입력해야 함..
	var $default_config = array
	(
		'javascript'	=> 'N'
		,'css'			=> 'N'
		,'html_encode'	=> 'Y'
	);
	var $str_config = array
	(
		'exclude_string'	=>	'<!\[CDATA\[|\]\]>'
		,'js_file_path'		=>	'files/cache/zipped_xe/'
	);

	public static function getInstance()
	{
		static $instance;
		if(!$instance) $instance = new Trimmed();
		return $instance;
	}

	// 1번만 세팅함.
	public function setConfig($config = NULL)
	{
		if(gettype($config)!='object') $config = new stdClass();
		$this->config = &$config;
		$this->defaultConfig();
		return $config;
	}
	protected function defaultConfig()
	{
		$config = &$this->config;
		foreach($this->default_config as $key => &$val)
			$config->{$key} = $config->{$key}!=$val;
		foreach($this->str_config as $k => &$v)
			strlen($config->{$k}) || $config->{$k} = &$v;
	}

	public function trim(&$html)
	{
		if($this->config->ob_start)
		{
			// 이미 ob_start 한 경우 패스.
			if(isset($this->ob_start)) return;
			$this->ob_start = TRUE;
			ob_start(array(&$this, 'trim_html'));
		}
		else
		{
			$this->trim_html($html);
		}
	}
	public function trim_html(&$output)
	{
		$output = trim($output);
		if(!strlen($output)) return;

		$this->html($output);

		// html 주석 제거는 패스. beforeDocument 등.
		/*if($addon_info->TEST)
		{
			$search[] = '/<!--.*?-->/s';
			$replacement[] = '';
		}*/

		if($this->config->javascript || $this->config->css)
		{
			$regex = ($this->config->javascript && $this->config->css)? 'script|style' : ($this->config->javascript? 'script':'css');
			$regex = sprintf('@(<\s*(%s)[^>]*\>)(.+?)(?=<\s*/\s*\2\s*>)@ius', $regex);
			$output = preg_replace_callback($regex, array(&$this, 'parse_js_css'), $output);
		}

		return $output;
	}

	protected function html(&$output)
	{
		$search = $replace = array();
		if($this->config->html_encode)
			$search[] = '/(<\s*(script|style|xmp|pre|textarea|input|option)[^>]*(?:>.*?<\s*\/\s*\2|\/)\s*>)|\s{2,}/ius';
		else
			$search[] = '/(<\s*(script|style|xmp|pre|textarea|input|option)[^>]*(?:>.*?<\s*\/\s*\2|\/)\s*>)|\s+/ius';
		$replace[] = '\1 ';
		$output = preg_replace($search, $replace, $output);
	}


	public function parse_js_css($matches)
	{
		// 컨텐츠
		$tagName = strtolower($matches[2]);
		$buff = &$matches[3];
		unset($matches[0], $matches[2]);

		if($tagName=='style')
		{
			$this->css($buff);
			return implode('', $matches);
		}

		// 여기서부텀 javascript
		$this->javascript($buff, TRUE);
		return implode("\n", $matches);
	}

	public function css(&$buff)
	{
		$buff = preg_replace('@/\s*\*.*?\*/\s*|\s+@s', ' ', $buff);
	}

	public function javascript(&$buff, $html = FALSE)
	{
		$html? $exclude_string = $this->config->exclude_string : '';
		$regex = &$this->get_regex_js($exclude_string);

		$this->get_regex_js_trigger($exclude_string);

		// 주석처리.. CDATA는 패스.
		$buff = trim(preg_replace($regex->search, $regex->replace, $buff));
	}

	protected function get_regex_js(&$exclude_string)
	{
		isset($this->regex_js) || $this->regex_js = array();
		if(isset($this->regex_js[$exclude_string])) return $this->regex_js[$exclude_string];

		$replace = $search = array();

		// 취소: ^[\s\t\v\n\r]+|[\s\t\v\n\r]+$
		$search[] = '/\r|\\\\[\r\n]+|;[\s\t\v\r\n]*$/';
		$replace[] = '';

		// html에 삽입되는 javascript를 파싱함.. 약하게 처리함.
		if(strlen($exclude_string))
		{
			// 주석 삭제: 공백으로 시작하는 문자열인 경우에만 처리하므로 따옴표('") 는 처리안함.
			$search[] = sprintf('#(^|\n)[\s\t\v\n]*(?:(//.*?(?:%s).*|/\*[\s\S]*?(?:%s)[\s\S]*?\*/)|(?://.*|/\*[\s\S]*?\*/))|//[^\'"\n]*(?=\n)#iu', $exclude_string, $exclude_string);
			$replace[] = '\1\2\3';
		}
		// .js 파일
		//else
		//{
		//	$search['//'] = '#([\r\n])+(?:[\s\t\v\n\r])*//.*#';
		//	$replace['//'] = '';
			// /* ~ */ 주석 삭제.
		//	$search['/**/'] = '#(?:([\r\n])+|^)(\s)*/\*.*?\*/\s*#s';
		//	$replace['/**/'] = '\1';
		//}

		$search['\n'] = '#[\s\t\v\n]*?\n+[\s\t\v\n]*#';
		//$search['\n'] = '#(?<=\n[^\'"/\n]+)#u';
		$replace['\n'] = "\n";

		$this->regex_js[$exclude_string]->search = &$search;
		$this->regex_js[$exclude_string]->replace = &$replace;
		return $this->regex_js[$exclude_string];
	}
	protected function get_regex_js_trigger(&$exclude_string){}

	public function replace($file_name, $cache_file, &$type, $php = FALSE)
	{
		$file_name = $this->config->path . str_replace($this->config->path, '', $file_name);
		$cache_file = $this->config->path . str_replace($this->config->path, '', $cache_file);

		$buff = @file_get_contents($file_name);
		if($type=='js')
		{
			$status = $this->js_minifier($buff, $file_name);
		}
		else
		{
			$status = $this->css_minifier($buff, $file_name);
		}
		if($status!='success')
		{
			$fp = fopen($log = $this->config->path.$this->config->js_file_path.'error_log.txt', 'a');
			fwrite($fp, "$status\n");
			fclose($fp);
			@chmod($log, 0644);
		}
		// filehandler 언젠간 제거하기로 -_-;;;
		FileHandler::writeFile($cache_file, $buff);
		if($php)
		{
			// secure
			$buff = preg_replace('/(<+|>+)/', '<?php echo \'\1\';?>', $buff);
			$buff = $this->get_php_cache() . $buff;
			FileHandler::writeFile("$cache_file.php", $buff);
		}
	}

	protected function get_php_cache()
	{
		if(isset($this->php_cache)) return $this->php_cache;
		$php_cache = file_get_contents(dirname(__FILE__)."/Trimmed.cache.php");
		$php_cache = preg_replace('#[\r\n]+//.*|[\r\n\t\v\r]*?[\n][\r\n\t\v\r]*#', ' ', $php_cache);
		$this->php_cache = &$php_cache;
		return $php_cache;
	}

	public function js_minifier(&$buff, $file_name = '')
	{
		class_exists('JSMinPlus') || include(dirname(__FILE__) . '/libs/jsminplus.php');
		ob_start();
		$output = JSMinPlus::minify($buff, $file_name);
		$status = trim(ob_get_clean());
		// error
		if(strlen($status))
			return $status;
		// success
		$buff = $output;
		return 'success';
	}

	public function css_minifier(&$buff, &$file_name)
	{
		if(!class_exists('CssMin')) include(dirname(__FILE__) . '/libs/CssMin.php');
		isset($this->CssMin) || $this->CssMin = new CssMin();

		// 프로토콜이나 루트는 패스: (?!https?://|/)
		$regex = '#(\@?\s*import\s*(?:url\s*)?\(?\s*(["\'])\s*)(?!https?://|/)(.+?)\s*\2#ius';
		$web_path = $this->getWebPath($file_name);
		$oTrim = &$this;

		// php 5.3(use keyword) && 애드옵 옵션에 설정한 경우
		if(stripos($this->config->zipped_css, 'import')!==FALSE && version_compare(PHP_VERSION, '5.3') > 0)
		{
			$buff = preg_replace_callback(
				$regex, function($matches) use ($oTrim, $web_path) {
					unset($matches[0]);
					$file_name = $web_path.$matches[3];
					// 제외할 경로라면 패스함.
					if($oTrim->isExcludeDir($file_name))
					{
						return $matches[1].$file_name.$matches[2];
					}
					else
					{
						$pathinfo = pathinfo($file_name);
						// import 파일의 filemtime 못 구하는게 문제다.
						$cache_file = $oTrim->config->js_file_path.$pathinfo['filename'].'_'.md5($file_name).'.css';

						$file_name = str_replace($oTrim->config->web_root, '', $file_name);
						$oTrim->replace($file_name, $cache_file, $fileinfo['extension']);

						return $matches[1].$cache_file.$matches[2];
					}
				}, $buff
			);
		}
		else
		{
			$buff = preg_replace($regex, sprintf('\1%s\3\2', $web_path), $buff);
		}


		$buff = $this->CssMin->minify($buff, array(), array(
			'UrlPrefix' => array( 'BaseUrl' => $web_path )
		));

		return 'success';
	}

	public function getWebPath(&$file_name)
	{
		//$web_path = preg_replace('#[^/]+#', '..', $this->config->js_file_path);
		$web_path = str_replace($this->config->path, '', $file_name);
		// remove string: filename
		$web_path = preg_replace('#^(?:\./)?(.*?)[^/]+$#u', '\1', $web_path);
		if(strpos($web_path, '/')===0) return $web_path;
		return $this->config->web_root.$web_path;
	}

	public function isExcludeDir(&$file_name)
	{
		return (strlen($this->config->exclude_dir) && preg_match($this->config->exclude_dir, $file_name));
	}



}
?>