<?php
/**
 * @class Trimmed
 * @author Elkha <m@elkha.kr>
 * http://elkha.kr/
 **/

class Trimmed
{
	// auto 아닌 값을 입력해야 함..
	var $default_config = array
	(
		'javascript'	=> 'N'
		,'css'			=> 'N'
		,'html_encode'	=> 'Y'
	);
	var $str_config = array
	(
		'exclude_string'	=>	'<!\[CDATA\[|\]\]>'
		,'js_file_path'		=>	'files/cache/zipped_xe/'
	);

	public static function getInstance()
	{
		static $instance;
		if(!$instance) $instance = new Trimmed();
		return $instance;
	}

	// 1번만 세팅함.
	public function setConfig($config = NULL)
	{
		if(gettype($config)!='object') $config = new stdClass();
		$this->config = &$config;
		$this->defaultConfig();
		return $config;
	}
	protected function defaultConfig()
	{
		$config = &$this->config;
		foreach($this->default_config as $key => &$val)
			$config->{$key} = $config->{$key}!=$val;
		foreach($this->str_config as $k => &$v)
			strlen($config->{$k}) || $config->{$k} = &$v;
	}

	public function trim(&$html)
	{
		if($this->config->ob_start)
		{
			// 이미 ob_start 한 경우 패스.
			if(isset($this->ob_start)) return;
			$this->ob_start = TRUE;
			ob_start(array(&$this, 'trim_html'));
		}
		else
		{
			$this->trim_html($html);
		}
	}
	public function trim_html(&$output)
	{
		$output = trim($output);
		if(!strlen($output)) return;

		$this->html($output);

		// html 주석 제거는 패스. beforeDocument 등.
		/*if($addon_info->TEST)
		{
			$search[] = '/<!--.*?-->/s';
			$replacement[] = '';
		}*/

		if($this->config->javascript || $this->config->css)
		{
			$regex = ($this->config->javascript && $this->config->css)? 'script|style' : ($this->config->javascript? 'script':'css');
			$regex = sprintf('@(<\s*(%s)[^>]*\>)(.+)(?=<\s*/\s*\2\s*>)@is', $regex);
			$output = preg_replace_callback($regex, array(&$this, 'parse_js_css'), $output);
		}

		return $output;
	}

	protected function html(&$output)
	{
		$search = $replace = array();
		if($this->config->html_encode)
			$search[] = '/\s*(<\s*(script|style|xmp|pre|textarea|input|option)[^>]*(?:>.*?<\s*\/\s*\2|\/)\s*>)\s*|\s{2,}/is';
		else
			$search[] = '/\s*(<\s*(script|style|xmp|pre|textarea|input|option)[^>]*(?:>.*?<\s*\/\s*\2|\/)\s*>)\s*|\s+/is';
		$replace[] = '\1 ';
		$output = preg_replace($search, $replace, $output);
	}


	public function parse_js_css($matches)
	{
		// 컨텐츠
		$tagName = strtolower($matches[2]);
		$buff = &$matches[3];
		unset($matches[0], $matches[2]);

		if($tagName=='style')
		{
			$this->css($buff);
			return implode('', $matches);
		}

		// 여기서부텀 javascript
		$this->javascript($buff, TRUE);
		return implode("\n", $matches);
	}

	public function css(&$buff)
	{
		$buff = preg_replace('@/\*.*?\*/|\s+@s', ' ', $buff);
	}

	public function javascript(&$buff, $html = FALSE)
	{
		$html? $exclude_string = $this->config->exclude_string : '';
		$regex = &$this->get_regex_js($exclude_string);

		$this->get_regex_js_trigger($exclude_string);

		// 주석처리.. CDATA는 패스.
		if(!$html) $buff = trim(preg_replace($regex->search, $regex->replace, $buff));
		else $buff = preg_replace($regex->search, $regex->replace, $buff);
	}

	protected function get_regex_js(&$exclude_string)
	{
		isset($this->regex_js) || $this->regex_js = array();
		if(isset($this->regex_js[$exclude_string])) return $this->regex_js[$exclude_string];

		$replace = $search = array();

		// \ 문자열 줄바꿈
		$search['\\\n'] = '/\\\\[\r\n]+/';
		$replace['\\\n'] = '';

		// html에 삽입되는 javascript를 파싱함.. 약하게 처리함.
		if(strlen($exclude_string))
		{
			// '//' 주석 삭제: 공백으로 시작하는 문자열인 경우에만 처리하므로 따옴표('") 는 처리안함.
			$search['//'] = sprintf('#(?:[\s\t\v\n\r])*?([\r\n])+(?:[\s\t\v\n\r])*//(?(?=%s)[^%s]|.)*?[\r\n]+#', $exclude_string, str_replace('|', '', $exclude_string));
			$replace['//'] = "\n";

			// /* ~ */ 주석 삭제.
			$search['/**/'] = sprintf('#[\s\t\v\n\r]*/\*(?(?=%s)[^%s]|[\s\S])*?\*/[\s\t\v\n\r]*#', $exclude_string, str_replace('|', '', $exclude_string));
			$replace['/**/'] = '';
		}
		// .js 파일
		//else
		//{
		//	$search['//'] = '#([\r\n])+(?:[\s\t\v\n\r])*//.*#';
		//	$replace['//'] = '';
			// /* ~ */ 주석 삭제.
		//	$search['/**/'] = '#(?:([\r\n])+|^)(\s)*/\*.*?\*/\s*#s';
		//	$replace['/**/'] = '\1';
		//}

		$search['\n'] = '#[\s\t\v\n\r]*[\r\n]+[\s\t\v\n\r]*#';
		$replace['\n'] = "\n";

		$this->regex_js[$exclude_string]->search = &$search;
		$this->regex_js[$exclude_string]->replace = &$replace;
		return $this->regex_js[$exclude_string];
	}
	protected function get_regex_js_trigger(&$exclude_string){}

	public function replace(&$file_name, &$cache_file, &$type)
	{
		$buff = @file_get_contents($file_name);
		if($type=='js')
		{
			$status = $this->js_minifier($buff, $file_name);
		}
		else
		{
			$status = $this->css_minifier($buff, $file_name);
		}
		if($status!='success')
		{
			$fp = fopen($log = $this->config->path.$this->config->js_file_path.'error_log.txt', 'a');
			fwrite($fp, "$status\n");
			fclose($fp);
			@chmod($log, 0644);
		}
		// filehandler 언젠간 제거하기로 -_-;;;
		FileHandler::writeFile($cache_file, $buff);
	}
	public function js_minifier(&$buff, $file_name = '')
	{
		if(!class_exists('JSMinPlus')) include(dirname(__FILE__) . '/libs/jsminplus.php');
		ob_start();
		$output = JSMinPlus::minify($buff, $file_name);
		$status = trim(ob_get_clean());
		// error
		if(strlen($status))
			return $status;
		// success
		$buff = $output;
		return 'success';
	}

	public function css_minifier(&$buff, &$file_name)
	{
		if(!class_exists('CssMin')) include(dirname(__FILE__) . '/libs/CssMin.php');
		isset($this->CssMin) || $this->CssMin = new CssMin();

		//if(preg_match('#^(https?:)?//#', $file_name))
		//{
		//}
		//else
		//{
			// 경로를 .. 형태로 구함.
			//$path = preg_replace('#[^/]+#', '..', $this->config->js_file_path);
			// file_name 에서
			$path = str_replace(_XE_PATH_, '', $file_name);
			$path = preg_replace('#^(?:\./)?(.*?)[^/]+$#i', '\1', $path);
			$path = preg_replace('#[^/]*$#', '', $_SERVER['SCRIPT_NAME']) . $path;

			$buff = $this->CssMin->minify($buff, array(), array(
				'UrlPrefix' => array( 'BaseUrl' => $path )
			));
		//}

		return 'success';
	}


}
?>