<?php
	/**
	 * @class  cashModel
	 * @author CONORY (http://www.conory.com)
	 * @brief The model class fo the cash module
	 */
	class cashModel extends cash
	{
		var $cashList = array();

		/**
		 * @brief Initialization
		 */
		function init()
		{
		}

		/**
		 * @brief ĳ  üũ
		 */
		function isExistsCash($member_srl)
		{
			$member_srl = abs($member_srl);
			if($this->cashList[$member_srl]) return true;

			// ĳ ִ 
			$path = sprintf('./files/member_extra_info/cash/%s',getNumberingPath($member_srl));
			$cache_filename = sprintf('%s%d.cache.txt', $path, $member_srl);
			if(file_exists($cache_filename))
			{
				if(!$this->cashList[$member_srl])
					$this->cashList[$member_srl] = trim(FileHandler::readFile($cache_filename));
				return true;
			}

			$args = new stdClass();
			$args->member_srl = $member_srl;
			$output = executeQuery('cash.getCash', $args);
			if($output->data->member_srl == $member_srl)
			{
				if(!$this->cashList[$member_srl])
					$this->cashList[$member_srl] = (int)$output->data->cash;
				return true;
			}
			return false;
		}

		/**
		 * @brief ĳ 
		 */
		function getCash($member_srl, $from_db = false)
		{
			$member_srl = abs($member_srl);
			if(!$from_db && $this->cashList[$member_srl]) return $this->cashList[$member_srl];

			// ĳ ִ 
			$path = sprintf('./files/member_extra_info/cash/%s',getNumberingPath($member_srl));
			$cache_filename = sprintf('%s%d.cache.txt', $path, $member_srl);

			if(!$from_db && file_exists($cache_filename))
				return $this->cashList[$member_srl] = trim(FileHandler::readFile($cache_filename));

			$args = new stdClass();
			$args->member_srl = $member_srl;
			$output = executeQuery('cash.getCash', $args);

			if(isset($output->data->member_srl))
			{
				$cash = (int)$output->data->cash;
				$this->cashList[$member_srl] = $cash;
				if(!is_dir($path)) FileHandler::makeDir($path);
				FileHandler::writeFile($cache_filename, $cash);
				return $cash;
			}
			return 0;
		}

		/**
		 * @brief ȸ ĳ 
		 */
		function getMemberList($args = null, $columnList = array())
		{
			// ˻ɼ
			$args->is_admin = Context::get('is_admin')=='Y'?'Y':'';
			$args->is_denied = Context::get('is_denied')=='Y'?'Y':'';
			$args->selected_group_srl = Context::get('selected_group_srl');

			$search_target = trim(Context::get('search_target'));
			$search_keyword = trim(Context::get('search_keyword'));

			if(!$search_keyword)
			{
				unset($args->is_admin, $args->is_denied, $args->selected_group_srl, $search_target);
			}

			if($search_target && $search_keyword)
			{
				switch($search_target)
				{
					case 'user_id' :
						if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
						$args->s_user_id = $search_keyword;
						break;
					case 'user_name' :
						if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
						$args->s_user_name = $search_keyword;
						break;
					case 'nick_name' :
						if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
						$args->s_nick_name = $search_keyword;
						break;
					case 'email_address' :
						if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
						$args->s_email_address = $search_keyword;
						break;
					case 'regdate' :
						$args->s_regdate = $search_keyword;
						break;
					case 'last_login' :
						$args->s_last_login = $search_keyword;
						break;
					case 'extra_vars' :
						$args->s_extra_vars = $search_keyword;
						break;
				}
			}
			// If there is a selected_group_srl, change the "query id" (for table join)
			if($args->selected_group_srl) $query_id = 'cash.getMemberListWithinGroup';
			else $query_id = 'cash.getMemberList';

			$output = executeQuery($query_id, $args, $columnList);
            if($output->data) {
                foreach($output->data as $key => $info) {		
				$output->data[$key]->cash = $this->getCash($info->member_srl,true);
                }
            }	
			
			return $output;
		}
	}
	