<?php
	/**
	 * @class  cashController
     * @author CONORY (http://www.conory.com)
	 * @brief Controller class of cash modules
	 */
	class cashController extends cash
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}
		
		/**
		 * @brief ĳ
		 */
		function setCash($member_srl, $cash, $mode = null)
		{
			$member_srl = abs($member_srl);
			$mode_arr = array('add', 'minus', 'update');
			if(!$mode || !in_array($mode,$mode_arr)) $mode = 'update';
			
			$oMemberModel = &getModel('member');
			$oModuleModel = &getModel('module');
			$oCashModel = &getModel('cash');
			$prev_cash = $oCashModel->getCash($member_srl, true);
			$config = $oModuleModel->getModuleConfig('cash');		
		
			// ĳ  Ǵ 
			$args = new stdClass();
			$args->member_srl = $member_srl;
			$args->cash = $prev_cash;

			switch($mode)
			{
				case 'add' :
					$args->cash += $cash;
					break;
				case 'minus' :
					$args->cash -= $cash;
					break;
				case 'update' :
					$args->cash = $cash;
					break;
			}
			if($args->cash < 0) $args->cash = 0;

			// Call a trigger (before)
			$trigger_output = ModuleHandler::triggerCall('cash.setCash', 'before', $args);
			if(!$trigger_output->toBool()) return $trigger_output;
			
			if($oCashModel->isExistsCash($member_srl)) executeQuery("cash.updateCash", $args);
			else executeQuery("cash.insertCash", $args);
			
			//ĳ  ׷캯
			$cash_group = $config->cash_group;
			if($cash_group && is_array($cash_group) && count($cash_group)){
				$default_group = $oMemberModel->getDefaultGroup();
				$del_group_list = array();
				$new_group_srls = array();
				asort($cash_group);

				// ׷ ʱȭ   ׷ ο
				if($config->group_reset != 'N'){
					foreach($cash_group as $group_srl => $target_cash){
						$del_group_list[] = $group_srl;
					}	
					$del_group_list[] = $default_group->group_srl;
					
					for($i=$args->cash; $i > 0; $i--){
						if(in_array($i, $cash_group)){
							foreach($cash_group as $group_srl => $target_cash){
								if($target_cash == $i) $new_group_srls[] = $group_srl;
							}
							break;	
						}	
					}
					
					// ׷츸 ο
				}else{
					foreach($cash_group as $group_srl => $target_cash){
						$del_group_list[] = $group_srl;
						if($target_cash <= $args->cash) $new_group_srls[] = $group_srl;
					}
				}
				
				if(!$new_group_srls[0]) $new_group_srls[0] = $default_group->group_srl;
				
				// ׷
				if($del_group_list && count($del_group_list))
				{
					$del_group_args = new stdClass();
					$del_group_args->member_srl = $member_srl;
					$del_group_args->group_srl = implode(',', $del_group_list);
					$del_group_output = executeQuery('cash.deleteMemberGroup', $del_group_args);
				}
				// ׷ο
				foreach($new_group_srls as $group_srl)
				{
					$new_group_args = new stdClass();
					$new_group_args->member_srl = $member_srl;
					$new_group_args->group_srl = $group_srl;
					executeQuery('member.addMemberToGroup', $new_group_args);
				}
			}
			
			// ĳ 
			$cache_path = sprintf('./files/member_extra_info/cash/%s/', getNumberingPath($member_srl));
			FileHandler::makedir($cache_path);

			$cache_filename = sprintf('%s%d.cache.txt', $cache_path, $member_srl);
			FileHandler::writeFile($cache_filename, $args->cash);
			
			// Call a trigger (after)
			$trigger_output = ModuleHandler::triggerCall('cash.setCash', 'after', $args);
			if(!$trigger_output->toBool()) return $trigger_output;
			
			$oModuleModel = &getModel('module');
			$module_config = $oModuleModel->getModuleConfig('cash');
			
			//ĳ Ǹ ˸ ߼
			if($module_config->message_cash_add=='Y' && ($args->cash > $prev_cash)){
				$title = sprintf(Context::getLang('send_message_cash_add'),$args->cash - $prev_cash);
				$content = sprintf(Context::getLang('send_message_cash_add'),$args->cash - $prev_cash);
				$oCommunicationController = &getController('communication');
				$oCommunicationController->sendMessage($args->member_srl, $args->member_srl, $title, $content, true);
			}
		
			return $output;
		}
	
	}