<?php
	/**
	 * @class  cashAdminView
     * @author CONORY (http://www.conory.com)
	 * @brief The admin view class of the cash module
	 */
	 
	class cashAdminView extends cash
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
			$oModuleModel = &getModel('module');
			$config = $oModuleModel->getModuleConfig('cash');
			Context::set('module_config', $config);

			$this->setTemplatePath($this->module_path.'tpl');
		}

		/**
		 * @brief ĳ ý 
		 */
		function dispCashAdminConfig()
		{
			// ׷ 
			$oMemberModel = &getModel('member');
			$group_list = $oMemberModel->getGroups();
			$selected_group_list = array();
			if(count($group_list)){
				foreach($group_list as $key => $val){
					$selected_group_list[$key] = $val;
				}
			}
			Context::set('group_list', $selected_group_list);
			
			$this->setTemplateFile('config');
		}

		/**
		 * @brief ȸ ĳ 
		 */
		function dispCashAdminCashList()
		{
			$oCashModel = &getModel('cash');

			$args = new stdClass();
			$args->list_count = 20;
			$args->page = Context::get('page');

			$oMemberModel = &getModel('member');
			$memberConfig = $oMemberModel->getMemberConfig();

			Context::set('identifier', $memberConfig->identifier);

			$columnList = array('member_srl', 'user_id', 'email_address', 'nick_name');
			$output = $oCashModel->getMemberList($args, $columnList);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('member_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);
			
			$oMemberModel = &getModel('member');
			$this->group_list = $oMemberModel->getGroups();
			Context::set('group_list', $this->group_list);
			
			//Security
			$security = new Security();			
			$security->encodeHTML('group_list..title','group_list..description');
			$security->encodeHTML('member_list..');

			// Set the template
			$this->setTemplateFile('member_list');
		}
	}
