<?php
	/**
	 * @class  cashAdminController
     * @author CONORY (http://www.conory.com)
	 * @brief The admin controller class of the cash module
	 */
	
	class cashAdminController extends cash 
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}

	/**
	 * @brief  
	 */
	function procCashAdminInsertConfig()
	{
		$args = Context::getRequestVars();

		//
		$config->message_cash_add = $args->message_cash_add;
		$config->group_reset = $args->group_reset;
		
		$oMemberModel = &getModel('member');
		$group_list = $oMemberModel->getGroups();	
		
		// ׷캰 
		foreach($group_list as $group){
			if($group->is_admin == 'Y' || $group->is_default == 'Y') continue;
			$group_srl = $group->group_srl;
			if($args->{'cash_group_'.$group_srl}){
				$config->cash_group[$group_srl] = $args->{'cash_group_'.$group_srl};
			}else{
				unset($config->cash_group[$group_srl]);
			}
		}
		
		$oModuleController = &getController('module');
		$oModuleController->insertModuleConfig('cash', $config);

		$this->setMessage('success_updated');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispCashAdminConfig');
		$this->setRedirectUrl($returnUrl);
	}
	
		/**
		 * @brief ĳ Ʈ
		 */
		function procCashAdminUpdateCash()
		{
			$member_srl = Context::get('member_srl');
			$cash = Context::get('cash');

			preg_match('/^(\+|-)?([1-9][0-9]*)$/', $cash, $m);

			$action = '';
			switch($m[1])
			{
				case '+':
					$action = 'add';
					break;
				case '-':
					$action = 'minus';
					break;
				default:
					$action = 'update';
					break;
			}
			$cash = $m[2];

			$oCashController = &getController('cash');
			$output = $oCashController->setCash($member_srl, (int)$cash, $action);

			$this->setError(-1);
			$this->setMessage('success_updated', 'info');

			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispCashAdminCashList');
			return $this->setRedirectUrl($returnUrl, $output);
		}

	}