<?php
/**
 * @class traffic_status
 * @author UPGLE (admin@upgle.com)
 * @version 0.1
 * @brief Display server traffic status by using data in the throttle-me
 */
class traffic_status extends WidgetHandler
{
	/**
	 * @brief Widget execution
	 * Get extra_vars declared in ./widgets/widget/conf/info.xml as arguments
	 * After generating the result, do not print but return it.
	 */
	function proc($args)
	{
		// Set skin vars
		$throttle = $args->throttle_src;

		// Set allow_url_fopen On
		ini_set("allow_url_fopen","1"); 

		$file = file($throttle);

		$traffic = sprintf("%0.2f",strip_tags($file[43]) / 1024);
		$limit = sprintf("%0.1f",strip_tags(eregi_replace("M", "",$file[47])));
		$percent = sprintf("%.2f" ,(($traffic/$limit)*100));
		$percent_rd = round(($traffic/$limit)*100);

		// Set allow_url_fopen Off
		ini_set("allow_url_fopen","0");

		Context::set('traffic', $traffic);
		Context::set('limit', $limit);
		Context::set('percent', $percent);
		Context::set('percent_rd', $percent_rd);

		// Set a path of the template skin (values of skin, colorset settings)
		$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
		Context::set('colorset', $args->colorset);

		// Specify a template file
		$tpl_file = 'traffic_status';
		
		// Compile a template
		$oTemplate = &TemplateHandler::getInstance();
		return $oTemplate->compile($tpl_path, $tpl_file);
	}
}
/* End of file traffic_status.class.php */
/* Location: ./widgets/traffic_status/traffic_status.class.php */
