<?php
	/**
	 * @class  realnoticeController
	 * @author wincomi (wincomi@me.com)
	 * @brief  realnotice 모듈의 Controller class
	 **/

	class realnoticeController extends realnotice {

		/**
		 * @brief Initialization
		 **/
		function init() {
			
		}
		
		function triggerBeforeDisplay() {
			if(Context::get('module') == 'admin') return;
			
			$module_info = Context::get('module_info');
			//if(in_array($module_info->mid, array('Trash'))) return;
    
			$oModuleModel = &getModel('module');
			$rn_config = $oModuleModel->getModuleConfig('realnotice');
			Context::set('rn_config', $rn_config);
            if($rn_config->rn_enabled!='Y') return;
            
			Context::addCSSFile($this->module_path.'tpl/jgrowl/jquery.jgrowl.css',false);
			Context::addJSFile('http://js.pusher.com/1.12/pusher.min.js',false);
			//Context::addJSFile('http://www.parsecdn.com/js/parse-1.2.1.min.js',false);
			Context::addJSFile($this->module_path.'tpl/jgrowl/jquery.jgrowl.min.js',false,'',null,'body');
			//Context::addJSFile($this->module_path.'tpl/sticky/sticky.min.js',false);
			//Context::addCSSFile($this->module_path.'tpl/sticky/sticky.min.css',false);
			$logged_info = Context::get('logged_info');


			$rn_js = <<<SCRIPT
<script type='text/javascript'>
// RealNotice Module by Wincomi (http://www.wincomi.com)
var pusher = new Pusher('$rn_config->pusher_key');
var channel = pusher.subscribe('realnotice');
channel.bind('all', function(data){rn_notification(data)});
channel.bind('member_$logged_info->member_srl',function(data){rn_notification(data);});
function rn_notification(data){
	if(window.localStorage['rn_notification_browser']=='true'){
		var rn_notification_browser = window.webkitNotifications.createNotification('','',data);
		rn_notification_browser.show();
	} else {
		jQuery.jGrowl(data,{sticky:true});
	}
}
</script>

SCRIPT;
			Context::addHTMLFooter($rn_js.$key);
		}
		
		/**
		* @brief 글 등록시 실시간 알림 테스트
		**/
		function triggerAfterInsertDocument(&$obj) {
			$oModuleModel = &getModel('module');
			$rn_config = $oModuleModel->getModuleConfig('realnotice');
			Context::set('rn_config', $rn_config);
             if($rn_config->rn_enabled!='Y') return;
            if($rn_config->rn_enabled_new_doc!=true) return;

			//debugPrint($obj);
			if($obj->status!='PUBLIC') return;
			
			require_once('Pusher.php');
			Context::set('rn_config', $rn_config);

			$args = $vars = Context::getRequestVars();
			$message = nl2br(trim($vars->notice_content));
			$key=$rn_config->pusher_key;$secret=$rn_config->pusher_secret;$app_id=$rn_config->pusher_app_id;
			$pusher = new Pusher($key,$secret,$app_id);
			$message = "<a href='".$obj->document_srl."'><strong>".$obj->title."</strong><br />by. ".$obj->nick_name."</a>";
			$result = $pusher->trigger('realnotice', 'all',$message);
			
			//debugPrint($result);
		}
	}
?>