<?php
	/**
	* @class	realnotice
	* @author wincomi (wincomi@me.com)
	* @brief	realnotice 모듈의 상위 class
	**/
	
	class realnotice extends ModuleObject {
		// Thanks to CMD
		var $triggers = array(
			array('document.insertDocument', 'realnotice', 'controller', 'triggerAfterInsertDocument', 'after'), // 문서 작성 시 트리거
			array('comment.insertComment', 'realnotice', 'controller', 'triggerAfterInsertComment', 'after'), // 댓글 작성 시 트리거
			array('display', 'realnotice', 'controller', 'triggerBeforeDisplay', 'before') // Context::addCSSFile 사용을 위한 트리거
		);
		
		/**
		* @brief 설치가 이상이 없는지 체크하는 method
		**/
		function checkUpdate() {
			$oModuleModel = &getModel('module');
			$oDB = &DB::getInstance();
			
			foreach($this->triggers as $trigger) {
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
			}
			/*if(!$oDB->isColumnExists('realnotice_log', 'readed')) {
			return true;
			}*/
			
			return false;
		}
		
		/**
		* @brief 업데이트 실행
		**/
		function moduleUpdate() {
			$oModuleModel = &getModel('module');
			$oModuleController = &getController('module');
			$oDB = &DB::getInstance();
				
			foreach($this->triggers as $trigger) {
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) {
					$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
				}
			}
			return new Object(0, 'success_updated');
		}
		
		/**
		* @brief 캐시 파일 재생성
		**/
		function recompileCache() {
			
		}
	
		/**
		* @brief 설치시 추가 작업이 필요할시 구현
		**/
		function moduleUninstall() {
			$oModuleController = &getController('module');
			
			foreach($this->triggers as $trigger) {
				$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
			}
			
			return new Object();
		}
	}
?>