<?php
	/**
	 * @class  realnoticeAdminView
	 * @author wincomi (wincomi@me.com)
	 * @brief  realnotice 모듈의 AdminView class
	 **/

	class realnoticeAdminView extends realnotice {

		/**
		 * @brief Initialization
		 **/
		function init() {
			$oModuleModel = &getModel('module');
			
			$template_path = sprintf("%stpl/",$this->module_path);
			$this->setTemplatePath($template_path);
			
			$rn_module_info = $oModuleModel->getModuleInfoXml('realnotice');
			Context::set('rn_module_info', $rn_module_info);
		}
		/**
		 * @brief 알림 보내기
		 **/
		function dispRealnoticeAdminSend() {
			$oModuleModel = &getModel('module');
			$rn_config = $oModuleModel->getModuleConfig('realnotice');
			Context::set('rn_config', $rn_config);

			$this->setTemplateFile("index");
		}
		/**
		 * @brief Pusher 설정
		 **/
		function dispRealnoticeAdminConfig() {
			$oModuleModel = &getModel('module');
			$rn_config = $oModuleModel->getModuleConfig('realnotice');
			Context::set('rn_config', $rn_config);
			
			$this->setTemplateFile("config");
		}
		/**
		 * @brief 알림 리스트
		 **/
		function dispRealnoticeAdminList() {
			$oModuleModel = &getModel('module');

			/*$oRealnoticeModel = &getAdminModel('realnotice');
			$output = $oRealnoticeModel->getRealnoticeAdminLog($args);
			*/
			$output = executeQueryArray('realnotice.getRealnoticeLog', $args);

			Context::set('rn_log',$output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
			Context::set('page_navigation', $output->page_navigation);
			
			$this->setTemplateFile("list");
		}
		/**
		 * @brief 샘플 코드
		 **/
		function dispRealnoticeAdminSampleCode() {
			$this->setTemplateFile("sample_code");
		}

	}
?>