<?php
	/**
	 * @class  realnoticeAdminController
	 * @author wincomi (wincomi@me.com)
	 * @brief  realnotice 모듈의 AdminController class
	 **/

	class realnoticeAdminController extends realnotice {

		/**
		 * @brief Initialization
		 **/
		function init() {
			
		}
		/**
		 * @brief Real Notice 메시지 전송
		 **/
		function procRealnoticeAdminSend() {
			require_once('Pusher.php');
			
			$oModuleModel = &getModel('module');
			$rn_config = $oModuleModel->getModuleConfig('realnotice');
			Context::set('rn_config', $rn_config);
			
			$args = $vars = Context::getRequestVars();
			$message = nl2br(trim($vars->notice_content));
			$key=$rn_config->pusher_key;$secret=$rn_config->pusher_secret;$app_id=$rn_config->pusher_app_id;
			$pusher = new Pusher($key, $secret, $app_id);
			$result =$pusher->trigger('realnotice', 'all',$message);
			//$output = executeQuery('realnotice.insertRealnoticeLog', $args);
			//debugPrint($output);
			if($result){
				$msg_code = '"'.$message.'"가 전송되었습니다.';
				$this->setRedirectUrl(Context::get('success_return_url'));
				$this->setMessage($msg_code);
			} else {
				$msg_code = 'Pusher 설정을 확인하세요.';
				$this->setRedirectUrl(Context::get('error_return_url'));
				$this->setMessage($msg_code,'error');
			}
		}
		
		/**
		 * @brief Real Notice 설정
		 **/
		function procRealNoticeAdminConfig(){
			$vars = Context::getRequestVars();
			$oModuleController = &getController('module');

			/*$config->rn_enabled = $vars->rn_enabled;
			$config->rn_noti_type = $vars->rn_noti_type;
			$config->rn_enable_new_doc = $vars->rn_enable_new_doc;
			$config->pusher_app_id = trim($vars->pusher_app_id);
			$config->pusher_key = trim($vars->pusher_key);
			$config->pusher_secret = trim($vars->pusher_secret);*/
			$oModuleController->insertModuleConfig('realnotice', $vars);
			
			$msg_code = 'success_saved';
			//debugPrint($msg_code);
			$this->setRedirectUrl(Context::get('success_return_url'));
			$this->setMessage($msg_code);
			
		}
	}
?>