<?php

/**
 * multidomainModel class
 * multidomain model class of multidomain module
 * @author largeden (cbrghost@gmail.com)
 * @package /modules/multidomain
 * @version 1.0
 */
class multidomainModel extends multidomain
{
	/**
	 * @brief initialization
	 **/
	function init() {
	}

	/**
	 * Setup the default domain
	 * @return void
	 */
	function triggerMultidomain()
	{
		if($_SERVER['REQUEST_METHOD'] != 'POST')
		{
			return FALSE;
		}

		if(Context::getDefaultUrl() || !$this->isActivatedAddon('multidomain', 0))
		{
			return;
		}

		if(Mobile::isFromMobilePhone() && !$this->isActivatedAddon('multidomain', 0, 'mobile'))
		{
			return;
		}

		$args->domain = $this->parseUri(Context::get('request_uri'));
		$multidomain_info = $this->getMultidomain($args);

		$this->defaultUrl($multidomain_info->domain);
	}

	/**
	 * 멀티 도메인 체크
	 * @param int $multidomain_srl
	 * @param array $columnList
	 * @return object
	 */
	function getMultidomainSrl($multidomain_srl = null, $columnList = array())
	{
		if(!$multidomain_srl)
		{
			return;
		}

		$args->multidomain_srl = $multidomain_srl;
		$output = executeQuery('multidomain.getMultidomainSrl', $args, $columnList);
		if(!$output->toBool()||!$output->data) return;

		return $output->data;
	}

	/**
	 * 멀티 도메인 상세 정보보기
	 * @param array $args
	 * @param array $columnList
	 * @return object
	 */
	function getMultidomain($args = array(), $columnList = array())
	{
		// cache를 불러옵니다.
		if($cache = $this->getMultidomainCache('object_getMultidomain', array($args->domain)))
		{
			return $cache;
		}

		$output = executeQuery('multidomain.getMultidomain', $args, $columnList);
		if(!$output->toBool()||!$output->data) return;

		// cache를 저장합니다.
		$this->setMultidomainCache('object_getMultidomain', array($args->domain), $output->data);

		return $output->data;
	}

	/**
	 * mid, document_srl 구하기
	 * @return object
	 */
	function getMultidomainURL()
	{
		if(Context::getDefaultUrl())
		{
			return;
		}

		$args->domain = $this->parseUri(Context::get('request_uri'));

		// cache를 불러옵니다.
		if($cache = $this->getMultidomainCache('object_getMultidomainUrl', array($args->domain)))
		{
			return $cache;
		}

		$output = executeQuery('multidomain.getMultidomainUrl', $args);
		if(!$output->toBool()||!$output->data) return;

		// cache를 저장합니다.
		$this->setMultidomainCache('object_getMultidomainUrl', array($args->domain), $output->data);

		return $output->data;
	}

	/**
	 * HOST 정보얻기
	 * @return string
	 */
	function parseUri($uri = NULL)
	{
		if($uri == NULL)
		{
			return;
		}

		if(!preg_match("/^(http|https|tcp|udp|ssl|vls):\/\//", $uri))
		{
			$uri = "http://{$uri}";
		}
		$uri = parse_url($uri);

		$host = $uri['scheme'].'://'.$uri['host'];
		if($uri['port'])
		{
			$host .= ':'.$uri['port'];
		}

		return $host;
	}

	/**
	 * Returns whether to activate
	 *
	 * @param string $addon Name to check
	 * @param int $site_srl Site srl
	 * @param string $type pc or mobile
	 * @param string $gtype site or global
	 * @return bool If addon is activated returns true. Otherwise returns false.
	 */
	function isActivatedAddon($addon, $site_srl = 0, $type = 'pc', $gtype = 'site')
	{
		$args = new stdClass();
		$args->addon = $addon;
		if($gtype == 'global')
		{
			if($type == 'pc')
			{
				// cache를 불러옵니다.
				if(!$cache = $this->getMultidomainCache('object_getAddonIsActivated_md', array($addon)))
				{
					$output = executeQuery('addon.getAddonIsActivated', $args);

					// cache를 저장합니다.
					$this->setMultidomainCache('object_getAddonIsActivated_md', array($addon), $output->data->count);
					$cache = $output->data->count;
				}
			}
			else
			{
				// cache를 불러옵니다.
				if(!$cache = $this->getMultidomainCache('object_getMAddonIsActivated_md', array($addon)))
				{
					$output = executeQuery('addon.getMAddonIsActivated', $args);

					// cache를 저장합니다.
					$this->setMultidomainCache('object_getMAddonIsActivated_md', array($addon), $output->data->count);
					$cache = $output->data->count;
				}
			}
		}
		else
		{
			$args->site_srl = $site_srl;
			if($type == 'pc')
			{
				// cache를 불러옵니다.
				if(!$cache = $this->getMultidomainCache('object_getSiteAddonIsActivated_md', array($addon)))
				{
					$output = executeQuery('addon.getSiteAddonIsActivated', $args);

					// cache를 저장합니다.
					$this->setMultidomainCache('object_getSiteAddonIsActivated_md', array($addon), $output->data->count);
					$cache = $output->data->count;
				}
			}
			else
			{
				// cache를 불러옵니다.
				if(!$cache = $this->getMultidomainCache('object_getSiteMAddonIsActivated_md', array($addon)))
				{
					$output = executeQuery('addon.getSiteMAddonIsActivated', $args);

					// cache를 저장합니다.
					$this->setMultidomainCache('object_getSiteMAddonIsActivated_md', array($addon), $output->data->count);
					$cache = $output->data->count;
				}
			}
		}
		if($cache > 0)
		{
			return TRUE;
		}
		return FALSE;
	}

	/**
	 * 카페, 텍스타일의 가상도메인 검사(관리자용)
	 * @param array $args
	 * @param array $columnList
	 * @return object
	 */
	function getIsSitesMD($args = null, $columnList = array())
	{
		$uri = parse_url($args->domain);
		$obj->domain = $uri['host'];
		$output = executeQuery('multidomain.getIsSitesMD', $obj, $columnList);
		if(!$output->toBool()||!$output->data) return;

		return $output->data;
	}

	/**
	 * 기본 도메인 생성
	 * @param bool $url
	 * @return void
	 */
	function defaultUrl($url = NULL)
	{
		if($url == NULL)
		{
			return;
		}

		$domain = Context::getInstance();
		$domain->db_info->default_url = $url;
	}

	/**
	 * 접근 안되는 증상 회피
	 * @return void
	 */
	function getMultidomainReturn()
	{
		$urls = array(Context::get('success_return_url'), Context::get('error_return_url'));
		foreach($urls as $url)
		{
			if(empty($url))
			{
				continue;
			}

			$obj->domain = $this->parseUri($url);
			if(!$obj->domain)
			{
				continue;
			}

			if($multidomain_info = $this->getMultidomain($obj))
			{
				$this->defaultUrl($obj->domain);
				return;
			}

			if($multidomain_site_info = $this->getIsSitesMD($obj))
			{
				$this->defaultUrl($obj->domain);
				return;
			}
		}
	}
}
/* End of file multidomain.model.php */
/* Location: ./modules/multidomain/multidomain.model.php */