<?php

/**
 * multidomainAdminView class
 * multidomain view class of multidomain module
 * @author largeden (cbrghost@gmail.com)
 * @package /modules/multidomain
 * @version 1.0
 */
class multidomainAdminView extends multidomain
{

	/**
	 * Initilization
	 * @return void
	 */
	function init()
	{
		$template_path = sprintf("%stpl/",$this->module_path);
		$this->setTemplatePath($template_path);
	}

	/**
	 * 멀티 도메인 관리자페이지
	 * @return void
	 */
	function dispMultidomainAdminSetup()
	{
		if(Context::get('order_type'))
		{
			$args->order_type = Context::get('order_type');
		}
		else
		{
			$args->order_type = 'desc';
		}
		$args->sort_index = Context::get('sort_index');
		$args->page = Context::get('page');
		$args->list_count = 20;
		$args->page_count = 20;

		$oMultidomainAdminModel = &getAdminModel('multidomain');
		$oMultidomainModel = getModel('multidomain');

		$multidomain = $oMultidomainAdminModel->getMultidomainList($args);

		// Add to the list settings
		$oAddonModel = getAdminModel('addon');
		$addon_list = $oAddonModel->getAddonListForSuperAdmin();

		$security = new Security($addon_list);
		$addon_list = $security->encodeHTML('..', '..author..');

		foreach($addon_list as $no => $addon_info)
		{
			
			if($addon_info->addon == 'multidomain')
			{
				$multi_addon[$no] = $addon_info;
				$multi_addon[$no]->description = nl2br(trim($addon_info->description));

				break;
			}
		}

		// 멀티 도메인 애드온 정보
		Context::set('addon_list', $multi_addon);
		Context::set('multidomain_addon_pc', $oMultidomainModel->isActivatedAddon('multidomain', 0));
		Context::set('multidomain_addon_mobile', $oMultidomainModel->isActivatedAddon('multidomain', 0, 'mobile'));

		// 기본 URL
		$db_info = Context::getDBInfo();
		Context::set('default_url', $db_info->default_url);

		// 멀티 도메인 리스트
		Context::set('total_count', $multidomain->total_count);
		Context::set('total_page', $multidomain->total_page);
		Context::set('page', $multidomain->page);
		Context::set('multidomain_list', $multidomain->data);
		Context::set('page_navigation', $multidomain->page_navigation);

		$this->setTemplateFile('list');
	}
}
/* End of file multidomain.admin.view.php */
/* Location: ./modules/multidomain/multidomain.admin.view.php */