<?php
    /**
     * @class foodin
     * @author foodin (poprdo@gmail.com)
     * @brief widget to display foodin list
     * @version 0.1
     **/

    class foodin extends WidgetHandler {

        /**
         * @brief Widget handler
         **/
        function proc($args) {
            $foodin_id = Context::get("employ_id");
        	if($foodin_id != '' && is_numeric($foodin_id) && self::viewexist($args)){
        		$args->employ_id = $foodin_id;
        		
        		$args->mode = 'view';
        	}else{
        		$args->mode = 'list';
        	}
        	// TODO XML 타입 추가
        	if($args->mode == 'list'){
        		$content_items = $this->_getJsonItems($args);
        		
        		$output = $this->_compile($args,$content_items);
        		return $output;
        	}else{
        		$foodin_item = $this->_getJsonItem($args);
        		$output = $this->_compileItem($args,$foodin_item);
        		return $output;
        	}
        }
		
        private function viewexist($args){
        	$viewFile = sprintf('%sskins/%s/view.html', $this->widget_path, $args->skin);
        	return file_exists($viewFile);
        } 
        
        function requestFoodinJSonContents($apikey,$count = 10,$page = 1){
        	return $this->curl_get("http://www.food-in.net/openapi/list.json.php?key=$apikey&count=$count&page=$page");
        }
        
        function requestFoodinJsonContentItem($apikey,$employ_id){
        	return $this->curl_get("http://www.food-in.net/openapi/read.json.php?key=$apikey&no=$employ_id");
        }
        
        function _getJsonItem($args){
        	$jsonResult = $this->requestFoodinJsonContentItem($args->apikey,$args->employ_id);
        	$jsonObject = json_decode($jsonResult);
        	
        	$foodinItem = new foodinItem();
        	
        	$foodinItem->setNo($jsonObject->employinfo->no);
        	 
        	$foodinItem->setCompany($jsonObject->company->company_name_in);
        	$foodinItem->setAddress($jsonObject->company->address);
        	$foodinItem->setHomepage($jsonObject->company->homepage);
        	if(empty($jsonObject->employinfo->photo)){
        		$foodinItem->setPhoto(sprintf('%sskins/%s/img/foodin_logo_200x70.png', $this->widget_path, $args->skin));
        	}else{
        		$foodinItem->setPhoto($jsonObject->employinfo->photo);
        	}
        	
        	
        	$foodinItem->setName($jsonObject->company->name);
        	$foodinItem->setEmail($jsonObject->company->email);
        	$foodinItem->setHphone($jsonObject->company->hphone);
        	$foodinItem->setPhone($jsonObject->company->phone);
        	$foodinItem->setCompanyLink($jsonObject->company->companylink);
        	
        	$foodinItem->setAccept($jsonObject->employinfo->accept);
        	$foodinItem->setAcceptMethod($jsonObject->employinfo->accept_method);
        	$foodinItem->setArea($jsonObject->employinfo->area);
        	
        	$foodinItem->setTitle($jsonObject->employinfo->subject_in);        	
        	$foodinItem->setMale($jsonObject->employinfo->male_in);
        	$foodinItem->setAge($jsonObject->employinfo->age_in);
        	$foodinItem->setCareer($jsonObject->employinfo->career_in);
        	$foodinItem->setScholarship($jsonObject->employinfo->scholarship_in);
        	$foodinItem->setMarry($jsonObject->employinfo->marry_str);
        	
        	$foodinItem->setIndustries(@explode(',',$jsonObject->employinfo->industries_str));
        	$foodinItem->setJobpart(@explode(',',$jsonObject->employinfo->job_part));
        	$foodinItem->setEmployForm($jsonObject->employinfo->employ_form_arr);
        	$foodinItem->setHealth($jsonObject->employinfo->health_in);
        	$foodinItem->setRetire($jsonObject->employinfo->retire_str);
        	$foodinItem->setHomefood($jsonObject->employinfo->home_food_str);
        	$foodinItem->setWorkTime($jsonObject->employinfo->worktime);
        	$foodinItem->setVacation($jsonObject->employinfo->vacation_in);
        	$foodinItem->setSendPaper($jsonObject->employinfo->send_paper_str);
        	$foodinItem->setLink($jsonObject->employinfo->link);

        	$foodinItem->setRegdate($jsonObject->employinfo->rdate);
        	$foodinItem->setUpdate($jsonObject->employinfo->update);
        	
        	
        	return $foodinItem;
        }
        
        function _getJsonItems($args){
        	
        	$jsonResult = $this->requestFoodinJSonContents($args->apikey,$args->count,Context::get('page'));
        	$jsonObject = json_decode($jsonResult);
        	
        	$foodinItems = array();
        	if(isset($jsonObject->list)){
        		
        		foreach($jsonObject->list as $foodin){
        			$foodinItem = new foodinItem();
        			$foodinItem->setNo($foodin->no);
        			$foodinItem->setIcon($foodin->icon);
        			if($args->link_type == 'insite'){
        				if(empty($args->menu)){
        					$args->menu = Context::get('mid');
        				}
        				$foodinItem->setLink(getUrl('mid',$args->menu,'employ_id',$foodin->no,'page',Context::get('page')));
        			}else{
        				$foodinItem->setLink($foodin->link);
        			}
        			
        			$foodinItem->setCompany($foodin->company);
        			$foodinItem->setArea($foodin->area);
        			$foodinItem->setJobpart($foodin->jobpart);
        			$foodinItem->setPayType(self::pay_time_str_to_class($foodin->payType));
        			$foodinItem->setPay($foodin->pay);
        			$foodinItem->setTitle($foodin->title);
        			$foodinItem->setUpdate($foodin->update);
        			$foodinItems[] = $foodinItem;
        		}
        		$jsonObject->list = $foodinItems;
        	}
        	
        	return $jsonObject; 
        	
        }
        
        function _compile($args,$content_items){
            $oTemplate = &TemplateHandler::getInstance();
            // Set variables for widget
            $widget_info->apikey = $args->apikey;
            $widget_info->page = $_GET[page];
            $widget_info->content_items = $content_items;
            $widget_info->args = $args;
            Context::set('widget_info', $widget_info);

            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            return $oTemplate->compile($tpl_path, "list");
        }
        
        function _compileItem($args,$foodin_item){
        	$oTemplate = &TemplateHandler::getInstance();
        	$widget_info->apikey = $args->apikey;
        	$widget_info->content_item = $foodin_item;
        	$widget_info->args = $args;
        	Context::set('widget_info', $widget_info);
        	$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
        	return $oTemplate->compile($tpl_path, 'view');
        	
        }
        
        static function pay_time_str_to_class($str){
        	$pay_arr = array('시급'=>'hour','일급'=>'day','주급'=>'week','월급'=>'month','건별'=>'workby','내규'=>'incom','협상'=>'intable','직접'=>'direct','연봉'=>'year');
        	return $pay_arr[$str];
        }
        
        /**
         * Send a GET requst using cURL
         * @param string $url to request
         * @param array $get values to send
         * @param array $options for cURL
         * @return string
         */
        function curl_get($url, array $options = array())
        {
        	$defaults = array(
        			CURLOPT_URL => $url,
        			CURLOPT_HEADER => 0,
        			CURLOPT_RETURNTRANSFER => TRUE,
        			CURLOPT_TIMEOUT => 5
        	);
        
        	$ch = curl_init();
        	curl_setopt_array($ch, ($options + $defaults));
        	if( ! $result = curl_exec($ch))
        	{
        		@trigger_error(curl_error($ch));
        	}
        	curl_close($ch);
        	return $result;
        }        
    }
    
    class foodinItem extends Object{
    	function setNo($no){
    		$this->add('no',$no);
    	}
    	function getNo(){
    		return $this->get('no');
    	}
    	function setIcon($icon){
    		$this->add('icon',$icon);
    	}
    	function getIcon(){
    		return $this->get('icon');
    	}
    	 
    	function setLink($link){
    		$this->add('link',$link);
    	}
    	function getLink(){
    		return $this->get('link');
    	}
    	function setCompany($company){
    		$this->add('company',$company);
    	}
    	function getCompany(){
    		return $this->get('company');
    	}
    	function setArea($area){
    		$this->add('area',$area);
    	}
    	function getArea(){
    		return $this->get('area');
    	}
    	function setJobpart($jobpart){
    		$this->add('jobpart',$jobpart);
    	}
    	function getJobpart(){
    		return $this->get('jobpart');
    	}
    	function setPayType($payType){
    		$this->add('payType',$payType);
    	}
    	function getPayType(){
    		return $this->get('payType');
    	}
    	function setPay($pay){
    		$this->add('pay',$pay);
    	}
    	function getPay(){
    		return $this->get('pay');
    	}
    	function setTitle($title){
    		$this->add('title',$title);
    	}
    	function getTitle(){
    		return $this->get('title');
    	}
    	/* company */
    	function setAddress($address){
    		$this->add('address',$address);
    	}
        function getAddress(){
        	return $this->get('address');
    	}
    	function setName($name){
    		$this->add('name',$name);
    	}
    	function getName(){
    		return $this->get('name');
    	}
    	function setEmail($email){
    		$this->add('email',$email);
    	}
    	function getEmail(){
    		return $this->get('email');
    	}
    	function setHphone($hphone){
    		$this->add('hphone',$hphone);
    	}
    	function getHphone(){
    		return $this->get('hphone');
    	}
    	function setPhone($phone){
    		$this->add('phone',$phone);
    	}
    	function getPhone(){
    		return $this->get('phone');
    	}
    	function setHomepage($homepage){
    		$this->add('homepage',$homepage);
    	}
    	function getHomepage(){
    		return $this->get('homepage');
    	}
    	function setPhoto($photo){
    		$this->add('photo',$photo);
    	}
    	function getPhoto(){
    		return $this->get('photo');
    	}
    	function setCompanyLink($link){
    		$this->add('company_link',$link);
    	}
        function getCompanyLink(){
    		return $this->get('company_link');
    	}
    	/* employ info*/
        function setMale($male){
    		$this->add('male',$male);
    	}
    	function getMale(){
    		return $this->get('male');
    	}
    	function setAge($age){
    		$this->add('age',$age);
    	}
    	function getAge(){
    		return $this->get('age');
    	}
    	function setCareer($career){
    		$this->add('career',$career);
    	}
    	function getCareer(){
    		return $this->get('career');
    	}
    	function setScholarship($scholarship){
    		$this->add('scholarship',$scholarship);
    	}
    	function getScholarship(){
    		return $this->get('scholarship');
    	}
    	function setMarry($marry){
    		$this->add('marry',$marry);
    	}
    	function getMarry(){
    		return $this->get('marry');
    	}
    	function setHomeFood($home_food){
    		$this->add('home_food',$home_food);
    	}
    	function getHomeFood(){
    		return $this->get('home_food');
    	}
    	function setAccept($accept){
    		$this->add('accept',$accept);
    	}
    	function getAccept(){
    		return $this->get('accept');
    	}
    	function setAcceptMethod($accept_method){
    		$this->add('accept_method',$accept_method);
    	}
    	function getAcceptMethod(){
    		return $this->get('accept_method');
    	}
    	function setIndustries($industries){
    		$this->add('industries',$industries);
    	}
    	function getIndustries(){
    		return $this->get('industries');
    	}
        function setEmployForm($employ_form){
    		$this->add('employ_form',$employ_form);
    	}
    	function getEmployForm(){
    		return $this->get('employ_form');
    	}
        function setHealth($health){
    		$this->add('health',$health);
    	}
    	function getHealth(){
    		return $this->get('health');
    	}
        function setRetire($retire){
    		$this->add('retire',$retire);
    	}
    	function getRetire(){
    		return $this->get('retire');
    	}
    	function setWorkTime($worktime){
    		$this->add('worktime',$worktime);
    	}
    	function getWorkTime(){
    		return $this->get('worktime');
    	}
    	function setVacation($vacation){
    		$this->add('vacation',$vacation);
    	}
    	function getVacation(){
    		return $this->get('vacation');
    	}
        function setSendPaper($send_paper){
    		$this->add('send_paper',$send_paper);
    	}
    	function getSendPaper(){
    		return $this->get('send_paper');
    	}
    	
    	function setUpdate($update){
    		$this->add('update',$update);
    	}
    	function getUpdate(){
    		return $this->get('update');
    	}
    	function setRegdate($regdate){
    		$this->add('regdate',$regdate);
    	}
    	function getRegdate(){
    		return $this->get('regdate');
    	}
    	
    }
?>
