<?php
class xehoverdir extends WidgetHandler {
	function proc($args) {

// 추출대상
		if(!in_array($args->colect_type, array('module','document'))) $args->colect_type = 'module';
		$xHovdr_info->colect_type = $args->colect_type;
// 문서 번호
		if(!$args->document_srl) $args->document_srl = '';
		$args->document_srl = urldecode($args->document_srl);
		if($args->colect_type=="document" && $args->document_srl=='') return Context::getLang('컨텐츠 추출대상이 문서인 경우, 문서번호는 반드시 입력해야 합니다.');
		$xHovdr_info->document_srl = $args->document_srl;
// 카테고리 번호
		if(!$args->category_srl) $args->category_srl = '';
		$xHovdr_info->category_srl = $args->category_srl;
// 기간(일) - duration
		if(!$args->duration) $args->duration = 0;
		$xHovdr_info->duration = (int)$args->duration;
// 전체 목록수
		if(!$args->list_count) $args->list_count = 6;
		$xHovdr_info->list_count = (int)$args->list_count;
// 이미지 가로 넓이
		if(!$args->image_width) $image_width = 400;
		else $image_width = $args->image_width;
		$xHovdr_info->image_width = (int)$image_width;
// 이미지 세로 높이
		if(!$args->image_height) $image_height = 280;
		else $image_height = $args->image_height;
		$xHovdr_info->image_height = (int)$image_height;
// 표시항목
		$xHovdr_info->show_image = "N";
		$xHovdr_info->show_title = "N";
		$xHovdr_info->show_content = "N";
		$xHovdr_info->show_browser_title = "N";
		$xHovdr_info->show_category = "N";
		$xHovdr_info->show_comment_count = "N";
		$xHovdr_info->show_nickname = "N";
		$xHovdr_info->show_regdate = "N";
		$xHovdr_info->show_icon = "N";

		$xHovdr_info->show_list = $args->show_list;
		$args->show_list_arr = explode(',',$args->show_list);
		$xHovdr_info->show_list_arr = $args->show_list_arr;
		for($i=0,$c=count($args->show_list_arr);$i<$c;$i++)
		{
			switch($args->show_list_arr[$i])
			{
				case 'show_image':
					$xHovdr_info->show_image = "Y";
					break;
				case 'show_title':
					$xHovdr_info->show_title = "Y";
					break;
				case 'show_content':
					$xHovdr_info->show_content = "Y";
					break;
				case 'show_browser_title':
					$xHovdr_info->show_browser_title = "Y";
					break;
				case 'show_category':
					$xHovdr_info->show_category = "Y";
					break;
				case 'show_comment_count':
					$xHovdr_info->show_comment_count = "Y";
					break;
				case 'show_nickname':
					$xHovdr_info->show_nickname = "Y";
					break;
				case 'show_regdate':
					$xHovdr_info->show_regdate = "Y";
					break;
				case 'show_icon':
					$xHovdr_info->show_icon = "Y";
					break;
			}
		}

// new 표시 시간
		if(!$args->duration_new) $args->duration_new = 12;
		$xHovdr_info->duration_new = (int)$args->duration_new;
// 정렬 대상 - order_target
		if(!in_array($args->order_target, array('list_order','update_order','voted_count','readed_count','comment_count','trackback_count','uploaded_count','reward_point'))) $args->order_target = 'list_order';
		$xHovdr_info->order_target = $args->order_target;
// 정렬 방법
		if(!$args->order_type) $args->order_type = 'desc';
		$xHovdr_info->order_type = $args->order_type;
// 게시물 순서 섞기
		if(!$args->items_shuffle) $args->items_shuffle = 'N';
		$xHovdr_info->items_shuffle = $args->items_shuffle;
// 이미지 생성 방법
		if(!$args->image_type) $args->image_type = 'ratio';
		$xHovdr_info->image_type = $args->image_type;
// 이미지 배경색
		if(!$args->image_bgcolor) $image_bgcolor = '#FFFFFF';
		else $image_bgcolor = $args->image_bgcolor;
		$xHovdr_info->image_bgcolor = $image_bgcolor;
// 이미지 테두리 두께
		if(!$args->image_bdsize) $image_bdsize = 0;
		else $image_bdsize = $args->image_bdsize;
		$xHovdr_info->image_bdsize = (int)$image_bdsize;
// 이미지 테두리 색
		if(!$args->image_bdcolor) $image_bdcolor = 'rgba(0,0,0,0.1)';
		else $image_bdcolor = $args->image_bdcolor;
		$xHovdr_info->image_bdcolor = $image_bdcolor;
// Hover 색
		if(!$args->image_hvcolor) $image_hvcolor = 'rgba(75,75,75,0.7)';
		else $image_hvcolor = $args->image_hvcolor;
		$xHovdr_info->image_hvcolor = $image_hvcolor;
// 이미지 외부 여백
		if(!$args->image_outer) $image_outer = 0;
		else $image_outer = $args->image_outer;
		$xHovdr_info->image_outer = (int)$image_outer;
// 이미지 그림자 효과
		if(!$args->image_shadow) $args->image_shadow = 'Y';
		$xHovdr_info->image_shadow = $args->image_shadow;
// 이미지 라운딩 효과
		if(!$args->image_round) $args->image_round = 'Y';
		$xHovdr_info->image_round = $args->image_round;
// 이미지 라운딩 수치 입력
		if(!$args->image_round_px) $image_round_px = 3;
		else $image_round_px = $args->image_round_px;
		$xHovdr_info->image_round_px = (int)$image_round_px;
// 이미지 클릭 이벤트
		if(!$args->image_event) $args->image_event = 'N';
		$xHovdr_info->image_event = $args->image_event;
// 이미지 링크
		if(!$args->image_newtab) $args->image_newtab = 'N';
		$xHovdr_info->image_newtab = $args->image_newtab;

// 제목 글자수
		if(!$args->subject_cut_size) $args->subject_cut_size = 0;
		$xHovdr_info->subject_cut_size = $args->subject_cut_size;
// 제목 글씨체
		if(!in_array($args->title_font_family, array('Default','Dotum','Gulim','Batang','Gungsuh','Tahoma','Verdana','Helvetica','Georgia','Sans-serif'))) $args->title_font_family = 'Default';
		$xHovdr_info->title_font_family = $args->title_font_family;
// 제목 글꼴 직접 입력
		if(!$args->title_font_user) $args->title_font_user = '';
		$xHovdr_info->title_font_user = $args->title_font_user;
// 제목 문자 크기
		if(!$args->title_font_size) $title_font_size = 0;
		else $title_font_size = $args->title_font_size;
		$xHovdr_info->title_font_size = (int)$title_font_size;
// 제목 글자색
		if(!$args->title_font_color) $title_font_color = 'rgba(255,255,255,0.9)';
		else $title_font_color = $args->title_font_color;
		$xHovdr_info->title_font_color = $title_font_color;
// 제목 그림자색
		if(!$args->title_shadow_color) $title_shadow_color = 'rgba(0,0,0,0.2)';
		else $title_shadow_color = $args->title_shadow_color;
		$xHovdr_info->title_shadow_color = $title_shadow_color;
// 제목 밑줄 라인색
		if(!$args->title_bg_color) $title_bg_color = 'rgba(255,255,255,0.3)';
		else $title_bg_color = $args->title_bg_color;
		$xHovdr_info->title_bg_color = $title_bg_color;
// 제목 밑줄 라인 두께
		if(!$args->title_uline_px) $title_uline_px = '10';
		else $title_uline_px = $args->title_uline_px;
		$xHovdr_info->title_uline_px = $title_uline_px;
// 제목 높이
		if(!$args->title_height) $title_height = 0;
		else $title_height = $args->title_height;
		$xHovdr_info->title_height = (int)$title_height;

// 내용 글자수
		if(!$args->content_cut_size) $args->content_cut_size = 200;
		$xHovdr_info->content_cut_size = $args->content_cut_size;
// 내용 글씨체
		if(!in_array($args->content_font_family, array('Default','Dotum','Gulim','Batang','Gungsuh','Tahoma','Verdana','Helvetica','Georgia','Sans-serif'))) $args->content_font_family = 'Default';
		$xHovdr_info->content_font_family = $args->content_font_family;
// 내용 글꼴 직접 입력
		if(!$args->content_font_user) $args->content_font_user = '';
		$xHovdr_info->content_font_user = $args->content_font_user;
// 내용 문자 크기
		if(!$args->content_font_size) $content_font_size = 0;
		else $content_font_size = $args->content_font_size;
		$xHovdr_info->content_font_size = (int)$content_font_size;
// 내용 글자색
		if(!$args->content_font_color) $content_font_color = 'rgba(255,255,255,0.9)';
		else $content_font_color = $args->content_font_color;
		$xHovdr_info->content_font_color = $content_font_color;
// 내용 그림자색
		if(!$args->content_shadow_color) $content_shadow_color = 'rgba(0,0,0,0.2)';
		else $content_shadow_color = $args->content_shadow_color;
		$xHovdr_info->content_shadow_color = $content_shadow_color;
// 내용 밑줄 라인색
		if(!$args->content_bg_color) $content_bg_color = 'rgba(255,255,255,0.5)';
		else $content_bg_color = $args->content_bg_color;
		$xHovdr_info->content_bg_color = $content_bg_color;
// 내용 밑줄 라인 두께
		if(!$args->content_uline_px) $content_uline_px = '1';
		else $content_uline_px = $args->content_uline_px;
		$xHovdr_info->content_uline_px = $content_uline_px;
// 내용 높이
		if(!$args->content_height) $content_height = 0;
		else $content_height = $args->content_height;
		$xHovdr_info->content_height = (int)$content_height;

// plugin 활성화
		if($xHovdr_info->image_event=='V') $xHovdr_info->viewer = 'Y';
		else $xHovdr_info->viewer = 'N';
// Viewer Type
		if(!$args->viewer_type) $args->viewer_type = 'prettyPhoto';
		$xHovdr_info->viewer_type = $args->viewer_type;
// prettyPhoto 테마
		if(!in_array($args->viewer_theme, array('pp_default','light_rounded','dark_rounded','light_square','dark_square','facebook'))) $args->viewer_theme = 'pp_default';
		$xHovdr_info->viewer_theme = $args->viewer_theme;
// Viewer 소셜버튼
		if(!$args->viewer_social) $args->viewer_social = 'false';
		$xHovdr_info->viewer_social = $args->viewer_social;
		if($args->viewer_social=='false') $args->viewer_tools = 'social_tools:false,';
		else $args->viewer_tools = '';
		$xHovdr_info->viewer_tools = $args->viewer_tools;
// Viewer 컨텐츠
		if(!$args->viewer_text) $args->viewer_text = 'true';
		$xHovdr_info->viewer_text = $args->viewer_text;
// Viewer 이미지소스
		if(!$args->viewer_src) $args->viewer_src = 'N';
		$xHovdr_info->viewer_src = $args->viewer_src;

// 이미지 확장변수
		if($args->target_ext1_var!='Y') $args->target_ext1_var = 'N';
		$xHovdr_info->target_ext1_var = $args->target_ext1_var;
		if(!$args->ext1_var) $args->ext1_var = '';
		$xHovdr_info->ext1_var = $args->ext1_var;
// 링크 확장변수
		if(!$args->target_ext2_var) $args->target_ext2_var = 'N';
		if($args->image_event=='X') $args->target_ext2_var == 'Y';
		$xHovdr_info->target_ext2_var = $args->target_ext2_var;
		if(!$args->ext2_var) $args->ext2_var = '';
		$xHovdr_info->ext2_var = $args->ext2_var;
// 글쓴이 확장변수
		if(!$args->target_ext3_var) $args->target_ext3_var = 'N';
		$xHovdr_info->target_ext3_var = $args->target_ext3_var;
		if(!$args->ext3_var) $args->ext3_var = '';
		$xHovdr_info->ext3_var = $args->ext3_var;
// 제목 확장변수
		if(!$args->target_ext4_var) $args->target_ext4_var = 'N';
		$xHovdr_info->target_ext4_var = $args->target_ext4_var;
		if(!$args->ext4_var) $args->ext4_var = '';
		$xHovdr_info->ext4_var = $args->ext4_var;
// 부제목 확장변수
		if(!$args->target_ext5_var) $args->target_ext5_var = 'N';
		$xHovdr_info->target_ext5_var = $args->target_ext5_var;
		if(!$args->ext5_var) $args->ext5_var = '';
		$xHovdr_info->ext5_var = $args->ext5_var;
// 내용 확장변수
		if(!$args->target_ext6_var) $args->target_ext6_var = 'N';
		$xHovdr_info->target_ext6_var = $args->target_ext6_var;
		if(!$args->ext6_var) $args->ext6_var = '';
		$xHovdr_info->ext6_var = $args->ext6_var;
// 날짜 확장변수
		if(!$args->target_ext7_var) $args->target_ext7_var = 'N';
		$xHovdr_info->target_ext7_var = $args->target_ext7_var;
		if(!$args->ext7_var) $args->ext7_var = '';
		$xHovdr_info->ext7_var = $args->ext7_var;

		$mobile_agent = '/(iPod|iPhone|Android|BlackBerry|SymbianOS|SCH-M\d+|Opera Mini|Windows CE|Nokia|SonyEricsson|webOS|PalmOS)/';
		if (preg_match($mobile_agent, $_SERVER['HTTP_USER_AGENT'])) $args->mobile = 'Y';
		else $args->mobile = 'N';
		$xHovdr_info->mobile = $args->mobile;

		if(preg_match('/iP(hone|ad|od)/',$_SERVER['HTTP_USER_AGENT']))
		{
			$args->mobile_os = 'iphone';
		}
		elseif(preg_match('/android/',$_SERVER['HTTP_USER_AGENT']))
		{
			$args->mobile_os = 'android';
		}
		elseif(preg_match('/Windows/',$_SERVER['HTTP_USER_AGENT']))
		{
			$args->mobile_os = 'windows';
		}
		else
		{
			$args->mobile_os = 'android';
		}
		$xHovdr_info->mobile_os = $args->mobile_os;


		if(preg_match('/(?i)msie [1-7]/',$_SERVER['HTTP_USER_AGENT']))
		{
			$args->browser = "msie7";
		}
		elseif(preg_match('/(?i)msie 8/',$_SERVER['HTTP_USER_AGENT']))
		{
			$args->browser = "msie8";
		}
		elseif(preg_match('/(?i)msie 9/',$_SERVER['HTTP_USER_AGENT']))
		{
			$args->browser = "msie9";
		}
		elseif(preg_match('/(?i)Chrome/',$_SERVER['HTTP_USER_AGENT']))
		{
			$args->browser = "chrome";
		}
		else
		{
			$args->browser = "other";
		}
		$xHovdr_info->browser = $args->browser;

// xehoverdir 위젯 정보가져오기
//$oWidgetModel = &getModel('widget');
//$info_widget = $oWidgetModel->getWidgetInfo('xehoverdir');
//Context::set('info_widget', $info_widget);
//$xHovdr_info->info_widget = $args->info_widget;

		// Set variables used internally
		$oModuleModel = &getModel('module');
		$module_srls = $args->modules_info = $args->module_srls_info = array();
		$site_module_info = Context::get('site_module_info');

		// Apply to all modules in the site if a target module is not specified
		if($args->module_srls=='')
		{
			unset($obj);
			$obj->site_srl = (int)$site_module_info->site_srl;
			$output = executeQueryArray('widgets.xehoverdir.getMids', $obj);
			if($output->data)
			{
				foreach($output->data as $key => $val)
				{
					$args->modules_info[$val->mid] = $val;
					$args->module_srls_info[$val->module_srl] = $val;
					$module_srls[] = $val->module_srl;
				}
			}
			$args->modules_info = $oModuleModel->getMidList($obj);

		} else {
			$obj->module_srls = $args->module_srls;
			$output = executeQueryArray('widgets.xehoverdir.getMids', $obj);
			if($output->data)
			{
				foreach($output->data as $key => $val)
				{
					$args->modules_info[$val->mid] = $val;
					$args->module_srls_info[$val->module_srl] = $val;
					$module_srls[] = $val->module_srl;
				}
			}
		}
		// Exit if no module is found
		if(!count($args->modules_info)) return Context::get('msg_not_founded');
		$xelist_info->modules_info = $args->modules_info;
		$args->module_srl = implode(',',$module_srls);
		$oDocumentModel = &getModel('document');
		$oDocumentModel->setToAllDocumentExtraVars();

		$obj->list_count = $args->list_count;
		$obj->module_srls = $obj->module_srl = $args->module_srl;
		$obj->direct_download = 'Y';
		$obj->isvalid = 'Y';
		$obj->sort_index = $args->order_target;
		$obj->category_srl = explode(',', $args->category_srl);

		//기간 날짜 구하기
		if($args->duration!=0){
			$today = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
			$subtract = $today - (86400 * $args->duration);
			$obj->regdate = date("YmdHis", $subtract);
		} else $obj->regdate=0;

		// Get a list of documents
		if($xHovdr_info->colect_type == "module")
		{
			$obj->order_type = $args->order_type=="desc"?"asc":"desc";
			$obj->statusList = array('PUBLIC');
			$output = executeQueryArray('widgets.xehoverdir.getNewestDocuments', $obj);
			if($output->toBool()=='' || $output->data=='') return;
			$image_items = $tmplist = array();
			if($output->data) {
				foreach($output->data as $key => $val) {
					$showimage = $image_list = $imglist = $srcimage = array();
					$oDocument = $images = $imglink = $viewimage = null;
					$oDocument = $oDocumentModel->getDocument($val->document_srl);
					$doclink = $oDocument->getPermanentUrl();
					$oDocument->setAttribute($val, true);
					$oDocument->domain = $args->module_srls_info[$val->module_srl]->domain;
					$oDocument->add('domain',$oDocument->domain);
					$module_info = $oModuleModel->getModuleInfoByDocumentSrl($val->document_srl);
					$oDocument->add('module_info',$module_info);
					$oDocument->add('mid',$module_info->mid);
					$oDocument->add('browser_title',$module_info->browser_title);
					$category_info = $oDocumentModel->getCategory($val->category_srl);
					$oDocument->add('category',$category_info);
					$oDocument->add('category_title',$category_info->title);
					$oDocument->add('doclink',$doclink);
					$content = $args->content_cut_size !='N' ? $oDocument->getSummary($args->content_cut_size) : '';
					$oDocument->add('content',$content);
					$orgcontent = $oDocument->getContent(false);
					$orgcontent = preg_replace('/<([^>]*?)>/i', ' ', $orgcontent);
					$orgcontent = preg_replace('/<[^ei].*?>/i', ' ', $orgcontent);
					$orgcontent = preg_replace('/\s[\s]+/', '__XGaLry01__', $orgcontent);
					$getLine = preg_split('/__XGaLry01__/',$orgcontent);
					if(count($getLine)>0)
					{
						foreach($getLine as $ky1 => $nline)
						{
							if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",strtolower($nline)))
							{
								$images .= '['.$nline.','.$oDocument->getTitleText($args->subject_cut_size).']';
							}
						}
					}
					$oDocument->add('summary',$images);

					$extra_image = $oDocument->printExtraImages($args->duration_new * 60 * 60);
					$oDocument->add('extra_image',$extra_image);
					$oDocument->add('mobile_os',$args->mobile_os);
					$oDocument->add('mobile',$args->mobile);
					$oDocument->add('browser',$args->browser);

					$extvar1 = $oDocument->getExtraEidValue($args->ext1_var); // 이미지
					$extvar2 = $oDocument->getExtraEidValue($args->ext2_var); // 링크
					$extvar3 = $oDocument->getExtraEidValue($args->ext3_var); // 글쓴이
					$extvar4 = $oDocument->getExtraEidValue($args->ext4_var); // 제목
					$extvar5 = $oDocument->getExtraEidValue($args->ext5_var); // 부제목
					$extvar6 = $oDocument->getExtraEidValue($args->ext6_var); // 내용
					$extvar7 = $oDocument->getExtraEidValue($args->ext7_var); // 날짜

					// 확장변수 적용대상 - 이미지인 경우
					if($extvar1!='' && $args->target_ext1_var == 'Y')
					{
						if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",strtolower($extvar1)))
						{
							$image_list = array($extvar1);
							$oDocument->add('image_list',$image_list);
							$showimage[0]['viewer'] = $this->setRimg($extvar1,$image_width,$image_height,$args->image_type,$val->document_srl);
							$viewimage = $showimage[0]['viewer'];
							$showimage[0]['src'] = $this->getImgView($extvar1,'R');
						}
					}
					else
					{
						$image_list = $this->getFlist($oDocument->getUploadedFiles());
						if(count($image_list)>0) 
						{
						$oDocument->add('image_list',$image_list);
						$showimage = $this->setCreateImgFile($image_list,$image_width,$image_height,$args->image_type,$val->document_srl);
						}
						$viewimage = $oDocument->getThumbnail($image_width,$image_height,$args->image_type);
					}
					if(file_exists($showimage[0]['src'])) $srcimage = $showimage[0]['src'];

					$oDocument->add('showimage',$showimage);
					$oDocument->add('viewimage',$viewimage);
					$oDocument->add('srcimage',$srcimage);


					// 확장변수 적용대상 - 링크인 경우
					if($extvar2!='' && $args->target_ext2_var == 'Y')
					{
						$oDocument->add('link',$extvar2);
					}
					else $oDocument->add('link',$doclink);

					// 확장변수 적용대상 - 글쓴이인 경우
					if($extvar3!='' && $args->target_ext3_var == 'Y')
					{
						$oDocument->add('nick_name',$extvar3);
					} else $oDocument->add('nick_name',$val->nick_name);

					// 확장변수 적용대상 - 제목인 경우
					if($extvar4!='' && $args->target_ext4_var == 'Y')
					{
						$oDocument->add('subject',$extvar4);
					}
					else
					{
						$subject = $args->subject_cut_size !='N' ? $oDocument->getTitleText($args->subject_cut_size) : '';
						$oDocument->add('subject',$subject);
					}

					// 확장변수 적용대상 - 소제목인 경우
					if($extvar5!='' && $args->target_ext5_var == 'Y')
					{
						$oDocument->add('subtitle',$extvar5);
					}

					// 확장변수 적용대상 - 내용인 경우
					if($extvar6!='' && $args->target_ext6_var == 'Y')
					{
						$oDocument->add('article',$extvar6);
					}
					else
					{
						$article = $args->content_cut_size !='N' ? $oDocument->getContentText($args->content_cut_size) : '';
						$oDocument->add('article',$article);
					}

					// 확장변수 적용대상 - 날짜인 경우
					if($extvar7!='' && $args->target_ext7_var == 'Y')
					{
						$oDocument->add('reg_date',$extvar7);
					} else $oDocument->add('reg_date',$oDocument->getRegdate('Y.m.d'));

					$cnt=count($showimage);
					for($i=0;$i<$cnt;$i++)
					{
						if($args->image_event=='D') $imglink = $doclink;
						elseif($args->image_event=='V') $imglink = $oDocument->domain.$showimage[$i]['viewer'];
						elseif($args->image_event=='X') $imglink = $extvar1;
						$tmplist[] = "['".$oDocument->domain.$showimage[$i]['viewer']."','".$imglink."','".htmlspecialchars($subject)."']";
					}
					$oDocument->add('imglist',$tmplist);
					$xDocument = new xehoverdirItem( $module_info->browser_title );
					$xDocument->adds($oDocument->getObjectVars());
					$xDocument->setImage($showimage);

					$GLOBALS['XE_DOCUMENT_LIST'][$val->document_srl] = $oDocument;
					if($oDocument->thumbnailExists()) $thumbModule = 'Y';
					$image_items[$key] = $xDocument;
				}
			}
			$xHovdr_info->xehoverdir_items = $image_items;
			$xHovdr_info->imglist = implode(",", $tmplist);
			if($thumbModule == 'Y') $xHovdr_info->thumbModule = 'Y';
		}

		if($xHovdr_info->colect_type == "document")
		{
			$obj->order_type = $args->order_type=="desc"?"asc":"desc";
			$obj->document_srl = explode(',', $args->document_srl);
			$obj->statusList = array('PUBLIC');
			$output = executeQueryArray('widgets.xehoverdir.getDocuments', $obj);
			if($output->toBool()=='' || $output->data=='') return;
			$image_items = $tmplist = array();
			if($output->data) {
				foreach($output->data as $key => $val) {
					$showimage = $image_list = $imglist = $srcimage = array();
					$oDocument = $images = $imglink = $viewimage = null;
					$oDocument = $oDocumentModel->getDocument($val->document_srl);
					$doclink = $oDocument->getPermanentUrl();
					$oDocument->setAttribute($val, true);
					$oDocument->domain = $args->module_srls_info[$val->module_srl]->domain;
					$oDocument->add('domain',$oDocument->domain);
					$module_info = $oModuleModel->getModuleInfoByDocumentSrl($val->document_srl);
					$oDocument->add('module_info',$module_info);
					$oDocument->add('mid',$module_info->mid);
					$oDocument->add('browser_title',$module_info->browser_title);
					$category_info = $oDocumentModel->getCategory($val->category_srl);
					$oDocument->add('category',$category_info);
					$oDocument->add('category_title',$category_info->title);
					$oDocument->add('doclink',$doclink);
					$content = $args->content_cut_size !='N' ? $oDocument->getSummary($args->content_cut_size) : '';
					$oDocument->add('content',$content);
					$orgcontent = $oDocument->getContent(false);
					$orgcontent = preg_replace('/<([^>]*?)>/i', ' ', $orgcontent);
					$orgcontent = preg_replace('/<[^ei].*?>/i', ' ', $orgcontent);
					$orgcontent = preg_replace('/\s[\s]+/', '__XGaLry01__', $orgcontent);
					$getLine = preg_split('/__XGaLry01__/',$orgcontent);
					if(count($getLine)>0)
					{
						foreach($getLine as $ky1 => $nline)
						{
							if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",strtolower($nline)))
							{
								$images .= '['.$nline.','.$oDocument->getTitleText($args->subject_cut_size).']';
							}
						}
					}
					$oDocument->add('summary',$images);

					$extra_image = $oDocument->printExtraImages($args->duration_new * 60 * 60);
					$oDocument->add('extra_image',$extra_image);
					$oDocument->add('mobile_os',$args->mobile_os);
					$oDocument->add('mobile',$args->mobile);
					$oDocument->add('browser',$args->browser);

					$extvar1 = $oDocument->getExtraEidValue($args->ext1_var); // 이미지
					$extvar2 = $oDocument->getExtraEidValue($args->ext2_var); // 링크
					$extvar3 = $oDocument->getExtraEidValue($args->ext3_var); // 글쓴이
					$extvar4 = $oDocument->getExtraEidValue($args->ext4_var); // 제목
					$extvar5 = $oDocument->getExtraEidValue($args->ext5_var); // 부제목
					$extvar6 = $oDocument->getExtraEidValue($args->ext6_var); // 내용
					$extvar7 = $oDocument->getExtraEidValue($args->ext7_var); // 날짜

					// 확장변수 적용대상 - 이미지인 경우
					if($extvar1!='' && $args->target_ext1_var == 'Y')
					{
						if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",strtolower($extvar1)))
						{
							$image_list = array($extvar1);
							$oDocument->add('image_list',$image_list);
							$showimage[0]['viewer'] = $this->setRimg($extvar1,$image_width,$image_height,$args->image_type,$val->document_srl);
							$viewimage = $showimage[0]['viewer'];
							$showimage[0]['src'] = $this->getImgView($extvar1,'R');
						}
					}
					else
					{
						$image_list = $this->getFlist($oDocument->getUploadedFiles());
						if(count($image_list)>0) 
						{
						$oDocument->add('image_list',$image_list);
						$showimage = $this->setCreateImgFile($image_list,$image_width,$image_height,$args->image_type,$val->document_srl);
						}
						$viewimage = $oDocument->getThumbnail($image_width,$image_height,$args->image_type);
					}
					if(file_exists($showimage[0]['src'])) $srcimage = $showimage[0]['src'];

					$oDocument->add('showimage',$showimage);
					$oDocument->add('viewimage',$viewimage);
					$oDocument->add('srcimage',$srcimage);

					// 확장변수 적용대상 - 링크인 경우
					if($extvar2!='' && $args->target_ext2_var == 'Y')
					{
						$oDocument->add('link',$extvar2);
					}
					else $oDocument->add('link',$doclink);

					// 확장변수 적용대상 - 글쓴이인 경우
					if($extvar3!='' && $args->target_ext3_var == 'Y')
					{
						$oDocument->add('nick_name',$extvar3);
					} else $oDocument->add('nick_name',$val->nick_name);

					// 확장변수 적용대상 - 제목인 경우
					if($extvar4!='' && $args->target_ext4_var == 'Y')
					{
						$oDocument->add('subject',$extvar4);
					}
					else
					{
						$subject = $args->subject_cut_size !='N' ? $oDocument->getTitleText($args->subject_cut_size) : '';
						$oDocument->add('subject',$subject);
					}

					// 확장변수 적용대상 - 소제목인 경우
					if($extvar5!='' && $args->target_ext5_var == 'Y')
					{
						$oDocument->add('subtitle',$extvar5);
					}

					// 확장변수 적용대상 - 내용인 경우
					if($extvar6!='' && $args->target_ext6_var == 'Y')
					{
						$oDocument->add('article',$extvar6);
					}
					else
					{
						$article = $args->content_cut_size !='N' ? $oDocument->getContentText($args->content_cut_size) : '';
						$oDocument->add('article',$article);
					}

					// 확장변수 적용대상 - 날짜인 경우
					if($extvar7!='' && $args->target_ext7_var == 'Y')
					{
						$oDocument->add('reg_date',$extvar7);
					} else $oDocument->add('reg_date',$oDocument->getRegdate('Y.m.d'));

					$cnt=count($showimage);
					for($i=0;$i<$cnt;$i++)
					{
						if($args->image_event=='D') $imglink = $doclink;
						elseif($args->image_event=='V') $imglink = $oDocument->domain.$showimage[$i]['viewer'];
						elseif($args->image_event=='X') $imglink = $extvar1;
						$tmplist[] = "['".$oDocument->domain.$showimage[$i]['viewer']."','".$imglink."','".htmlspecialchars($subject)."']";
					}
					$oDocument->add('imglist',$tmplist);
					$xDocument = new xehoverdirItem( $module_info->browser_title );
					$xDocument->adds($oDocument->getObjectVars());
					$xDocument->setImage($showimage);

					$GLOBALS['XE_DOCUMENT_LIST'][$val->document_srl] = $oDocument;
					if($oDocument->thumbnailExists()) $thumbModule = 'Y';
					$image_items[$key] = $xDocument;
				}
			}
			$xHovdr_info->xehoverdir_items = $image_items;
			$xHovdr_info->imglist = implode(",", $tmplist);
			if($thumbModule == 'Y') $xHovdr_info->thumbModule = 'Y';
		}

		$oSecurity = new Security($xHovdr_info);
		$oSecurity->encodeHTML('..variables.title', '..variables.content', '..variables.user_name', '..variables.nick_name');

		$xHovdr_info->xs_skin = $args->skin;
		Context::set('xHovdr_info', $xHovdr_info);
		Context::set('module_srls_info', $args->module_srls_info);
// 페이지 수정일 때는 실제 모습은 보이지 않도록
		if (in_array(Context::get('act'), array("procWidgetGenerateCodeInPage", "dispPageAdminContentModify", "dispPageAdminMobileContentModify"))){
			$oTemplate = &TemplateHandler::getInstance();
			return $oTemplate->compile($this->widget_path, 'edit');
		}
		Context::set('colorset', $args->colorset);
		Context::set('skin', $args->skin);

		// 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
		$tpl_path = sprintf('%s', $this->widget_path);

		// 템플릿 파일을 지정
		$tpl_file = 'content';

		// 템플릿 컴파일
		$oTemplate = &TemplateHandler::getInstance();
		return $oTemplate->compile($tpl_path, $tpl_file);
	}

	function getFlist($attached)
	{
		// 초기화
		$getlist = array();
		$cnt = count($attached);
		for($i=0;$i<$cnt;$i++) {
			$srcname = strtolower($attached[$i]->source_filename);
			if(preg_match('/\.(jpg|png|jpeg|gif|bmp)$/i',$srcname) ) $getlist[] = $attached[$i]->uploaded_filename;
		}
		return $getlist;
	}

	function setCreateImgFile($imgsrc,$img_w,$img_h,$image_type,$doc_srl)
	{
		$image_list = array();
		$imgcnt = count($imgsrc);
		if(is_array($imgsrc) && $imgcnt>0)
		{
			for($i=0;$i<$imgcnt;$i++)
			{
			$image_list[$i]['viewer'] = $this->setFimg($imgsrc[$i],$img_w,$img_h,$image_type,$doc_srl);
			$image_list[$i]['src'] = $this->getImgView($imgsrc[$i],'F',$doc_srl);
			}
		}
		else
		{
			$image_list[0]['viewer'] = $this->setFimg($imgsrc,$img_w,$img_h,$image_type,$doc_srl);
			$image_list[0]['src'] = $this->getImgView($imgsrc,'F',$doc_srl);
		}
		if(count($image_list)>0) return array_values($image_list);
		else return;
	}

	function getImgView($urlsrc,$gview='F',$document_srl=0)
	{
		if($gview=='R')
		{
			$pathinfo = pathinfo($urlsrc);
			$filename = $pathinfo['filename'];
			$tmpname = preg_replace('/[!#$%@:^&*()?+=\/]/','', $pathinfo['dirname']); // 모든 특수문자 제거
			$thumbnail_path = sprintf('./files/cache/tmp/%s', $tmpname);
			$source_file = sprintf('%s%s%s.png', $thumbnail_path, $filename, $document_srl);
			if(file_exists($source_file)) $viewimg = $source_file;
			else $viewimg = null;
		}
		else
		{
			$thumbnail_path = sprintf('./files/cache/thumbnails/%s',getNumberingPath($document_srl, 3));
			$imgidx = substr($urlsrc, -11, 7); // 랜덤이미지일경우를 위해 이미지이름에 난수값입력
			$source_file = sprintf('%s%s%s.png', $thumbnail_path, $imgidx, $document_srl);
			if(file_exists($source_file)) $viewimg = $source_file;
			else $viewimg = null;
		}
		return $viewimg;
	}

// 첨부된 이미지 썸네일 생성
	function setFimg($imgsrc, $width = 180, $height = 120, $thumbnail_type, $document_srl)
	{
		// 높이 지정이 별도로 없으면 정사각형으로 생성
		if($height=='') $height = $width;
		$thumbnail_url = array();

		// 메모리 설정
		@ini_set('memory_limit', '128M');

		// 섬네일 정보 정의
		$thumbnail_path = sprintf('./files/cache/thumbnails/%s',getNumberingPath($document_srl, 3));

		$imgidx = substr($imgsrc, -11, 7); // 랜덤이미지일경우를 위해 이미지이름에 난수값입력
		$thumbnail_file = sprintf('%s%s_%dx%d.%s%s%s.png', $thumbnail_path, $imgidx, $width, $height, $thumbnail_type, $halign, $valign);
		$viewimg = sprintf('%s%s%s.png', $thumbnail_path, $imgidx, $document_srl);

		if(!file_exists($thumbnail_file))
		{
			$output = $this->setNewThumb($imgsrc, $thumbnail_file, $viewimg, $width, $height, 'png', $thumbnail_type);
		}
		else
		{
			$output = $thumbnail_file;
		}
		if($output!='') return $thumbnail_file;
		else return;
	}

// 외부이미지를 썸네일 생성
	function setRimg($ExtFile, $width = 180, $height = 120, $thumbnail_type, $document_srl)
	{
		if(!preg_match('/\.(jpg|png|jpeg|gif)$/i',strtolower($ExtFile))) return;
		// 메모리 설정
		@ini_set('memory_limit', '128M');

		$pathinfo = pathinfo($ExtFile); // [dirname], [filename]
		$tmpname = preg_replace('/[!#$%@:^&*()?+=\/]/','', $pathinfo['dirname']); // 모든 특수문자 제거

		// 높이 지정이 별도로 없으면 정사각형으로 생성
		if($height=='') $height = $width;
		$thumbnail_path = null;
		$source_file = null;
		$thumbnail_file = null;
		$tmp_thumfile = null;

		$filename = $pathinfo['filename'];

		if(!file_exists('./files/cache/tmp')) FileHandler::makeDir('./files/cache/tmp');
		$thumbnail_path = sprintf('./files/cache/tmp/%s', $tmpname);
		$source_file = sprintf('%s%s%s.png', $thumbnail_path, $filename, $document_srl);
		$thumbnail_file = sprintf('%s_%dx%d.%s_%s.png', $thumbnail_path, $width, $height, $thumbnail_type, $filename);

		if(!file_exists($source_file))
		{
			$output = FileHandler::getRemoteFile($ExtFile,$source_file);
			if(!$output) FileHandler::writeFile($source_file,'');
		}

		if(!file_exists($thumbnail_file))
		{
			$tmp_thumfile = $this->setNewThumb($source_file, $thumbnail_file, '', $width, $height, 'png', $thumbnail_type);
			if($tmp_thumfile) return $thumbnail_file;
			else return;
		}
		else
		{
			return $thumbnail_file;
		}
	}

// 새로운 썸네일 생성구문
	function setNewThumb($source_file, $target_file, $imgview, $resize_width = 0, $resize_height = 0, $target_type = 'png', $thumbnail_type = 'crop')
	{
		$source_file = FileHandler::getRealPath($source_file);
		$target_file = FileHandler::getRealPath($target_file);

		if(!file_exists($source_file)) return;
		if(!$resize_width) $resize_width = 100;
		if(!$resize_height) $resize_height = $resize_width;

		// retrieve source image's information
		$imageInfo = getimagesize($source_file);
		if(!FileHandler::checkMemoryLoadImage($imageInfo)) return false;
		list($width, $height, $type, $attrs) = $imageInfo;

		if($width<1 || $height<1) return;

		switch($type)
		{
			case '1' :
				$type = 'gif';
				break;
			case '2' :
				$type = 'jpg';
				break;
			case '3' :
				$type = 'png';
				break;
			case '6' :
				$type = 'bmp';
				break;
			default :
				return;
				break;
		}

		if($resize_width > 0 && $width >= $resize_width) $width_per = $resize_width / $width;
		else $width_per = 1;
		if($resize_height>0 && $height >= $resize_height) $height_per = $resize_height / $height;
		else $height_per = 1;

		if($thumbnail_type == 'ratio') {
			if($width_per>$height_per) $per = $height_per;
			else $per = $width_per;
			$resize_width = $width * $per;
			$resize_height = $height * $per;
		} else {
			if($width_per < $height_per) $per = $height_per;
			else $per = $width_per;
		}
		if(!$per) $per = 1;

		// get type of target file
		if(!$target_type) $target_type = $type;
		$target_type = strtolower($target_type);

		// create temporary image with target size
		if(function_exists('imagecreatetruecolor')) $thumb = imagecreatetruecolor($resize_width, $resize_height);
		else if(function_exists('imagecreate')) $thumb = imagecreate($resize_width, $resize_height);
		else return false;
		if(!$thumb) return false;

		$white = imagecolorallocate($thumb, 255,255,255);
		imagefilledrectangle($thumb,0,0,$resize_width-1,$resize_height-1,$white);

		// create temporary image having original type
		switch($type)
		{
			case 'gif' :
				if(!function_exists('imagecreatefromgif')) return false;
				$source = @imagecreatefromgif($source_file);
				break;
			// jpg
			case 'jpeg' :
			case 'jpg' :
				if(!function_exists('imagecreatefromjpeg')) return false;
				$source = @imagecreatefromjpeg($source_file);
				break;
			// png
			case 'png' :
				if(!function_exists('imagecreatefrompng')) return false;
				$source = @imagecreatefrompng($source_file);
				@imagealphablending($thumb, false);
				@imagesavealpha($thumb, true); // save alphablending setting (important)
				break;
			// bmp
			case 'wbmp' :
			case 'bmp' :
				if(!function_exists('imagecreatefromwbmp')) return false;
				$source = @imagecreatefromwbmp($source_file);
				break;
			default :
				return;
		}

		// resize original image and put it into temporary image
		$new_width = (int)($width * $per);
		$new_height = (int)($height * $per);

		if($thumbnail_type == 'crop') {
			$x = (int)($resize_width/2 - $new_width/2);
			$y = (int)($resize_height/2 - $new_height/2);
		} else {
			$x = 0;
			$y = 0;
		}

		if($source) {
			if(function_exists('imagecopyresampled')) imagecopyresampled($thumb, $source, $x, $y, 0, 0, $new_width, $new_height, $width, $height);
			else imagecopyresized($thumb, $source, $x, $y, 0, 0, $new_width, $new_height, $width, $height);
		} else return false;

		// create directory 
		$path = dirname($target_file);
		if(!is_dir($path)) FileHandler::makeDir($path);

		// write into the file
		switch($target_type)
		{
			case 'gif' :
					if(!function_exists('imagegif')) return false;
					$output = imagegif($thumb, $target_file);
				break;
			case 'jpeg' :
			case 'jpg' :
					if(!function_exists('imagejpeg')) return false;
					$output = imagejpeg($thumb, $target_file, 100);
				break;
			case 'png' :
					if(!function_exists('imagepng')) return false;
					$output = imagepng($thumb, $target_file, 9);
				break;
			case 'wbmp' :
			case 'bmp' :
					if(!function_exists('imagewbmp')) return false;
					$output = imagewbmp($thumb, $target_file, 100);
				break;
		}

		imagedestroy($thumb);
		imagedestroy($source);

		if(!$output) return false;
		if($imgview)
		{
			$imgview = FileHandler::getRealPath($imgview);
			FileHandler::copyFile($source_file, $imgview, 'Y');
			//@copy($source_file, $imgview);
		}
		@chmod($target_file, 0644);
		@chmod($imgview, 0644);

		return true;
	}

}

class xehoverdirItem extends Object {
	function xehoverdirItem($browser_title=''){
		$this->add('browser_title',$browser_title);
	}
	function getBrowserTitle(){
		return $this->get('browser_title');
	}
	function setDomain($domain) {
		static $default_domain = null;
		if(substr($domain, -1)!="/") $domain = $domain."/";
		if($domain=='') {
			if(is_null($default_domain)) 
			{
				$default_domain = Context::getDefaultUrl();
				if(substr($default_domain, -1)!="/") $default_domain = Context::getDefaultUrl()."/";

			}
			$domain = $default_domain;
		}
		$this->add('domain',$domain);
	}
	function getDomain() {
		return $this->get('domain');
	}
	function setMobile($mobile_os)
	{
		$this->add('mobile_os',$mobile_os);
	}
	function setMobileAgent($mobile_agent)
	{
		$this->add('mobile',$mobile_agent);
	}
	function setBrowser($browser)
	{
		$this->add('browser',$browser);
	}
	function setMid($mid)
	{
		$this->add('mid',$mid);
	}
	function getMid()
	{
		return $this->get('mid');
	}

	function setImage($showimage)
	{
		$this->add('image_list',$showimage);
	}
	function getImage()
	{
		return $this->get('image_list');
	}
	function getViewer($idx=0)
	{
		$getimage = $this->get('image_list');
		return $getimage[$idx];
	}
	function getView($idx=0)
	{
		$getimage = $this->get('image_list');
		return $getimage[$idx]['viewer'];
	}
	function getSrc($idx=0)
	{
		$getimage = $this->get('image_list');
		return $getimage[$idx]['src'];
	}
	function setLinkDoc($linkdoc){
		$this->add('doclink',$linkdoc);
	}
	function getLinkDoc(){
		return $this->get('doclink');
	}
	function setLink($url){
		$this->add('link',$url);
	}
	function getLink(){
		return $this->get('link');
	}
	function setNickName($nick_name){
		$this->add('nicknametest',$nick_name);
	}
	function getNickName(){
		return $this->get('nickname');
	}
	function setTitle($title){
		$this->add('subject',$title);
	}
	function getTitle($cut_size = 0, $tail='...'){
		$title = strip_tags($this->get('subject'));
		if($cut_size) $title = cut_str($title, $cut_size, $tail);
		$attrs = array();
		if($this->get('title_bold') == 'Y') $attrs[] = 'font-weight:bold';
		if($this->get('title_color') && $this->get('title_color') != 'N') $attrs[] = 'color:#'.$this->get('title_color');
		if(count($attrs)) $title = sprintf("<span style=\"%s\">%s</span>", implode(';', $attrs), htmlspecialchars($title));
		return $title;
	}
	function setSubTitle($subtitle){
		$this->add('subtitle',$subtitle);
	}
	function getSubTitle(){
		return $this->get('subtitle');
	}
	function setContent($content){
		$this->add('article',$content);
	}
	function getContent(){
		return $this->get('article');
	}
	function setCSRegdate($extvalue){
		$this->add('reg_date',$extvalue);
	}
	function getCSRegdate(){
		return $this->get('reg_date');
	}
	function setCategory($category){
		$this->add('category',$category);
	}
	function getCategory(){
		return $this->get('category');
	}
	function setExtraImages($ext_icon){
		$this->add('ext_icon',$ext_icon);
	}
	function getExtraImages() {
		return $this->get('ext_icon');
	}

	function getMinfo($xs_path,$info_is)
	{
		$nURL = urldecode(trim($xs_path));
		$nPlayer = null;
		$nMime = null;
		$nType = null;

		if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",strtolower($nURL)))
		{
			$nPlayer = 'image';
			$nMime = 'image';
			$nType = 'image';
		}
		elseif (preg_match("/youtube.com\/(v\/|watch\?|embed\/)/i",strtolower($nURL)))
		{
			$nPlayer = 'youtube';
			$nMime = 'application/x-shockwave-flash';
			$nType = 'video';
		}
		else if(preg_match("/youtu.be/i",strtolower($nURL)))
		{
			$nPlayer = 'youtube';
			$nMime = 'application/x-shockwave-flash';
			$nType = 'video';
		}
		else if(preg_match("/vimeo.com/i",strtolower($nURL)))
		{
			$nPlayer = 'vimeo';
			$nMime = 'application/x-shockwave-flash';
			$nType = 'video';
		}
		else if(preg_match("/\.(swf)$/i",strtolower($nURL)))
		{
			$nPlayer = 'quicktime';
			$nMime = 'application/x-shockwave-flash';
			$nType = 'video';
		}
		else if(preg_match("/\.(mov)$/i",strtolower($nURL)))
		{
			$nPlayer = 'jwplayer';
			$nMime = 'video/quicktime';
			$nType = 'video';
		}

		if($info_is=='mPlayer') return $nPlayer;
		else if($info_is=='mMime') return $nMime;
		else if($info_is=='mType') return $nType;
	}
}
?>
