<?php
    /**
     * @class  oknameView
     * @author Xiso (jeokcho@naver.com)
     * @brief  okname module Controller class
     **/

    class oknameView extends okname {

        /**
         * @brief initialization
         **/
        function init() {
			 // Get the member configuration
            $oMemberModel = &getModel('member');
            $this->member_config = $oMemberModel->getMemberConfig();
            Context::set('member_config', $this->member_config);

			//load config
			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('okname');
			$skin = $config->skin;
			
            // Set the template path
			if(!$skin)
			{
				$skin = 'default';
				$template_path = sprintf('%sskins/%s', $this->module_path, $skin);
			}
			else
			{
				//check theme
				$config_parse = explode('|@|', $skin);
				if (count($config_parse) > 1)
				{
					$template_path = sprintf('./themes/%s/modules/member/', $config_parse[0]);
				}
				else
				{
					$template_path = sprintf('%sskins/%s', $this->module_path, $skin);
				}
			}
			// Template path
			$this->setTemplatePath($template_path);

			$oLayoutModel = &getModel('layout');
			$layout_info = $oLayoutModel->getLayout($this->member_config->layout_srl);
			if($layout_info)
			{
				$this->module_info->layout_srl = $this->member_config->layout_srl;
				$this->setLayoutPath($layout_info->path);
			}
        }
		
		//로그인폼 대체, 레이아웃은 member의 레이아웃설정을따름.
		//아이핀을 미리 로드함.
		function dispOknameLoginForm(){
			 if(Context::get('is_logged')) {
                header("location:".getNotEncodedUrl('act',''));
                return;
            }

			// get member module configuration.
			$oMemberModel = &getModel('member');
			$config = $this->member_config;
			Context::set('identifier', $config->identifier);
			
			//load config
			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('okname');
			
			//Load Ipin
			$idpUrl    = "https://ipin.ok-name.co.kr/tis/ti/POTI90B_SendCertInfo.jsp";
			$returnUrl = "http://{$config->domain}/?act=dispOknameIpinResult";
			$idpCode   = "V";	
			$cpCode    = $config->shop_id;		// 회원사 코드 (회원사 아이디)


			$exe = _XE_PATH_."../okname/okname";
			$keypath = _XE_PATH_."../okname/okname.key";
			$logpath = _XE_PATH_."../okname/logs";
			$memid = $cpCode;	 $reserved1 = "0"; $reserved2 = "0";
			$EndPointURL = "http://www.ok-name.co.kr/KcbWebService/OkNameService";
			$option = "CLU";

			//set Cmd & Run module
			$cmd = "$exe $keypath $memid \"{$reserved1}\" \"{$reserved2}\" $EndPointURL $logpath $option";
			exec($cmd, $out, $ret);
			Context::set('pubkey',$out[0]);
			Context::set('sig',$out[1]);
			Context::set('curtime',$out[2]);
			Context::set('idpCode',$idpCode);
			Context::set('idpUrl',$idpUrl);
			Context::set('cpCode',$cpCode);
			Context::set('returnUrl',$returnUrl);
	
            // Set a template file
            Context::set('referer_url', htmlspecialchars($_SERVER['HTTP_REFERER']));			
			
			$this->setTemplateFile('login_form');
		}

		//안심본인인증 결과처리
		function dispOknameResult(){
			//load config
			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('okname');
			
			$idcfMbrComCd			=	$_POST["idcf_mbr_com_cd"];
			$hsCertSvcTxSeqno	=	$_POST["hs_cert_svc_tx_seqno"];
			$hsCertMsrCd				=	$_POST["hs_cert_msr_cd"];
			$hsCertRqstCausCd		=	$_POST["hs_cert_rqst_caus_cd"];

			$resultCd					=	$_POST["result_cd"];			// 결과코드
			$resultMsg					=	$_POST["result_msg"];			// 결과메세지
			$certDtTm					=	$_POST["cert_dt_tm"];			// 인증일시
			$encInfo					= $_POST["encInfo"];
			$WEBPUBKEY				= trim($_POST["WEBPUBKEY"]);				//KCB서버 공개키
			$WEBSIGNATURE 		= trim($_POST["WEBSIGNATURE"]);	//KCB서버 서명값
			
			//make key file for ipin server
			$exe = _XE_PATH_."../okname/okname";
			$logPath = _XE_PATH_."../okname/logs";
			$keypath = _XE_PATH_."../okname/safecert_{$idcfMbrComCd}.key";
			
			$endPointUrl = "http://www.ok-name.co.kr/KcbWebService/OkNameService";
			$cpubkey = $WEBPUBKEY;
			$csig = $WEBSIGNATURE;
			$option = "SLU";
			
			//run module
			$cmd = "$exe $keypath $idcfMbrComCd $endPointUrl $WEBPUBKEY $WEBSIGNATURE $encInfo $logPath $option";
			exec($cmd, $out, $ret);
			
			//make result Array
			foreach($out as $a => $b) { if($a < 17) { $field[$a] = $b; } }
			
			//세션에 저장
			$_SESSION['auth_info']["resultCd"] = $field[0]; //처리결과코드
			$_SESSION['auth_info']["resultMsg"] = $field[1]; //처리결과메시지
			$_SESSION['auth_info']["hsCertSvcTxSeqno"] = $field[2]; //거래일련번호 (sequence처리)
			$_SESSION['auth_info']["auth_date"] = $field[3]; //인증일시
			$_SESSION['auth_info']["DI"] = $field[4]; //DI
			$_SESSION['auth_info']["CI"] = $field[5]; //CI
			$_SESSION['auth_info']["user_name"] = $field[7]; //성명
			$_SESSION['auth_info']["birthday"] = $field[8]; //생년월일
			$_SESSION['auth_info']["age"] = substr(date('Ymd')-$field[8],0,2); //만 나이
			$_SESSION['auth_info']["sex"] = $field[9]; //성별
			$_SESSION['auth_info']["forigen"] = $field[10]; //내외국인구분
			$_SESSION['auth_info']["agency"] = $field[11]; //통신사코드
			$_SESSION['auth_info']["mobile"] = $field[12]; //휴대폰번호
			$auth_info = $_SESSION['auth_info'];
			
			//만약 중복가입을 방지하고 있다면, DI조회후 결과값있는경우 다른페이지 set
			if($config->free_di != "Y"){
				$check_args->di = $_SESSION['auth_info']["DI"];
				$check_output = executeQueryArray('okname.checkDi',$check_args);
				if(count($check_output->data)) return $this->setTemplateFile('none_free_di');
			}
			
			//레이아웃과의 혹시나있을 에러를 방지하기위해 제거
			Context::set('layout','none');
			Context::set('auth_info',$auth_info);
			Context::set('idcfMbrComCd',$idcfMbrComCd);
			Context::set('hsCertMsrCd',$hsCertMsrCd);
			
			$this->setTemplatePath($this->module_path."tpl/");
			$this->setTemplateFile('auth_result');
		}
		
		//아이핀 결과처리
		function dispOknameIpinResult(){
			//load config
			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('okname');
			
			@$encPsnlInfo = $_POST["encPsnlInfo"];
			@$WEBPUBKEY = trim($_POST["WEBPUBKEY"]);
			@$WEBSIGNATURE = trim($_POST["WEBSIGNATURE"]);
		  
			//make Keyfile for KCB server
			$logpath = _XE_PATH_."../okname/logs";
			$exe = _XE_PATH_."../okname/okname";
			$keypath = _XE_PATH_."../okname/okname.key";
			$cpCode    = $config->shop_id;
			$EndPointURL = "http://www.ok-name.co.kr/KcbWebService/OkNameService";
			$cpubkey = $WEBPUBKEY;       //server publickey
			$csig = $WEBSIGNATURE;    //server signature
			$encdata = $encPsnlInfo;     //PERSONALINFO
			$option = "SLU";
				
			//set CMD & run module
			$cmd = "$exe $keypath $cpCode $EndPointURL $cpubkey $csig $encdata $logpath $option";
			exec($cmd, $out, $ret);
			
			// 결과라인에서 값을 추출
			foreach($out as $a => $b) { if($a < 13) { $field[$a] = $b; } }
			
			//세션에 저장
			$_SESSION['auth_info']["auth_date"] =  date('Ymdhis');
			$_SESSION['auth_info']["DI"] = $field[0]; //DI
			$_SESSION['auth_info']["CI"] = $field[1]; //CI
			$_SESSION['auth_info']["user_name"] = $field[6]; //성명
			$_SESSION['auth_info']["birthday"] = $field[11]; //생년월일
			$_SESSION['auth_info']["age"] = substr(date('Ymd')-$field[11],0,2); //만 나이
			$_SESSION['auth_info']["sex"] = $field[9]; //성별
			$_SESSION['auth_info']["forigen"] = $field[10]; //내외국인구분
			$auth_info = $_SESSION['auth_info'];
			
			//만약 중복가입을 방지하고 있다면, DI조회후 결과값있는경우 다른페이지 set
			if($config->free_di != "Y"){
				$check_args->di = $auth_info['DI'];
				$check_output = executeQueryArray('okname.checkDi',$check_args);
				if(count($check_output->data)) return $this->setTemplateFile('none_free_di');
			}
			
			//레이아웃과의 혹시나있을 에러를 방지하기위해 제거
			Context::set('layout','none');
			Context::set('auth_info',$auth_info);
			Context::set('encPsnlInfo',$encPsnlInfo);
			
			$this->setTemplatePath($this->module_path."tpl/");
			$this->setTemplateFile('ipin_result');
		
		}
	}
	
?>