<?php
    /**
     * @class  oknameController
     * @author Xiso (jeokcho@naver.com)
     * @brief  okname module Controller class
     **/

    class oknameController extends okname {

        /**
         * @brief initialization
         **/
        function init() {
        }
		
		/**
         * @brief 회원 DB 추가전 트리거 (세션값들을 extra_vars에 들어가게 밀어줌)
         **/
        function triggerInsertMemberBefore(&$obj) {
            $member_srl = $obj->member_srl;
            $oMemberController = &getController('member');
			
			//load config
			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('okname');
			
			//기본값들 먼저수정 (아이디,생년월일) 조작을해서 수정을 하든말든 그냥 세션값으로 대체.
			unset($config->extra_vars['user_name'],$config->extra_vars['birthday']);
			$obj->user_name = $_SESSION['auth_info']["user_name"];
			$obj->birthday = $_SESSION['auth_info']["birthday"];
			
			//생성된 extra_vars 값들을 가로채어, 세션값으로 바꿔치기한다.
			$extra_vars = unserialize($obj->extra_vars);
			foreach($config->extra_vars as $key => $val){
				if(!$config->extra_vars[$key]['id']) continue;
				$extra_vars->{$config->extra_vars[$key]['id']} = $_SESSION['auth_info'][$config->extra_vars[$key]];
			}
			$obj->extra_vars = serialize($extra_vars);
            return new Object();
        }
		
		/**
         * @brief 회원 DB 추가후 트리거 (세션값들을 저장)
         **/
        function triggerInsertMemberAfter(&$obj) {
            $member_srl = $obj->member_srl;
            $oMemberController = &getController('member');
			
			//세션에있는 값들을 불러와 DI기준으로 세이브. 나머지정보는 serialize.	
            $args->member_srl = $member_srl;
			$args->di = $_SESSION['auth_info']["DI"];
			$args->ci = $_SESSION['auth_info']["CI"];
			$args->auth_info = serialize($_SESSION['auth_info']);
			$output = executeQuery('okname.insertDi',$args);
			
			// 기본 member controller에 trigget_ouput 실패시 롤백처리되므로 그냥 결과값을 return.
            if (!$output->toBool()) return $output;
			
			unset ($_SESSION['auth_info']);
            return new Object();
        }
		
		/**
         * @brief 회원 DB 삭제 전 트리거 (di정보 제거)
         **/
        function triggerDeleteMember(&$obj) {
            $member_srl = $obj->member_srl;
            $oMemberController = &getController('member');
			
			//세션에있는 값들을 불러와 DI기준으로 세이브. 나머지정보는 serialize.	
            $args->member_srl = $member_srl;
			$output = executeQuery('okname.deleteDi',$args);
			
			// 기본 member controller에 trigget_ouput 실패시 롤백처리되므로 그냥 결과값을 return.
            if (!$output->toBool()) return $output;
            
            return new Object();
        }
		
		//okname safeHS step 2
		function procOknameSafeHsPOP(){
			//load config
			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('okname');
			
			//set Default value
			$inTpBit = "0"; $name = "x"; $birthday = "x"; $gender = "x"; $ntvFrnrTpCd="x"; $mblTelCmmCd="x"; $mbphnNo="x";
			$svcTxSeqno = getNextSequence();
			
			//codeInfo / xiso : 순서대로 회원코드, 클라이언트ip, 도메인
			$memId = $config->shop_id;
			$clientIp = $_SERVER["SERVER_ADDR"]; $clientDomain = $config->domain;
			
			//예약항목
			$rsv1 = "0";$rsv2 = "0";$rsv3 = "0";
			
			//인증수단/요청사유 - 00:회원가입, 01:성인인증, 02:회원정보수정, 03:비밀번호찾기, 04:상품구매, 99:기타
			//현재 회원가입만 지원
			$hsCertMsrCd = "10"; $hsCertRqstCausCd = "00";
			$returnMsg = "x";
			
			$returnUrl = "http://{$config->domain}/index.php?act=dispOknameResult";
			$exe = _XE_PATH_."../okname/okname";
			$logpath = _XE_PATH_."../okname/logs/";
			$serverDomain = "safe.ok-name.co.kr";
			$endPointURL = "http://".$serverDomain."/KcbWebService/OkNameService";
			$option = "QLU";
			$cmd = "$exe $svcTxSeqno \"$name\" $birthday $gender $ntvFrnrTpCd $mblTelCmmCd $mbphnNo $rsv1 $rsv2 $rsv3 \"$returnMsg\" $returnUrl $inTpBit $hsCertMsrCd $hsCertRqstCausCd $memId $clientIp $clientDomain $endPointURL $logpath $option";
			
			//run Module
			exec($cmd, $out, $ret);
			
			//module return
			if ($ret == 0 || 1) { 
				return $this->setMessage($out[2]);
			}
			else {
				return new Object(-1,"ERROR : code ".$ret);
			}
		}
	}
	
?>