<?php
    /**
     * @class  oknameAdminController
     **/

    class oknameAdminController extends okname {
		 /**
         * @brief 초기화
         **/
        function init() {
		}
		
		/**
		* @기본 & 회원모듈 연동 설정저장
		**/
		function procOknameAdminInsertConfig(){
			$args = Context::getRequestVars();
			
			$oModuleController = &getController('module');
			$oModuleModel = &getModel('module');
			unset($args->act,$args->error_return_url);
			
			//기존 설정을 불러옴
			$config = $oModuleModel->getModuleConfig('okname');
			
			//일단 확장변수부터
			foreach($args as $k => $v){
				if(substr($k,0,3) == "id_" || substr($k,0,3) == "ty_"){
					$config->extra_vars[substr($k,3,strlen($k))][substr($k,0,2)] = $v;
					unset($args->{$k});
				}
			}
			
			//만약 id없이 ty만 값이있는경우라면 제거
			foreach($config->extra_vars as $k => $v) if(!$v['id']) unset($config->extra_vars[$k]);
			
			//두페이지로 나누어진 설정을 따로저장하기 위해서, 수정된것만 적용
			foreach($args as $k => $v) $config->{$k} = $v;
			
			$output = $oModuleController->insertModuleConfig('okname',$config);
			$this->setMessage('설정이 저장되었습니다.');
			
			if (Context::get('success_return_url')){
				$this->setRedirectUrl(Context::get('success_return_url'));
			}else{
				$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', $args->return_act));
			}
		}
	}
?>