<?php

require_once(_XE_PATH_.'modules/mobileex/mobileex.view.php');

class mobileexMobile extends mobileexView {
	
	         var $target_mid = array();
            var $mskin = 'default';
      		function init()
      		{
      
                  $template_path = sprintf("%sm.skins/%s/",$this->module_path, $this->module_info->mskin);
                  if(!is_dir($template_path)||!$this->module_info->mskin) {
                      $this->module_info->mskin = 'default';
                      $template_path = sprintf("%sm.skins/%s/",$this->module_path, $this->module_info->mskin);
                  }
                  $this->setTemplatePath($template_path);
      
      		}
		
        /**
         * @brief mobileex integrantion search
         **/
         
        function MEIS() {
            $oFile = &getClass('file');
            $oModuleModel = &getModel('module');

            // 권한 체크
            if(!$this->grant->access) return new Object(-1,'msg_not_permitted');

            $config = $oModuleModel->getModuleConfig('mobileex');
            if(!$this->grant->access) return new Object(-1,'msg_not_permitted');
            
            if(!$config->use_mobile || $config->use_mobile != 'Y') return new Object(-1,'msg_invalid_request');
            
            $target = $config->target;
            if(!$target) $target = 'include';
            $module_srl_list = explode(',',$config->target_module_srl);

            // 검색어 변수 설정
            $is_keyword = Context::get('is_keyword');

            // 페이지 변수 설정
            $page = (int)Context::get('page');
            if(!$page) $page = 1;

            // 검색탭에 따른 검색
            $where = Context::get('where');

            // integration search model객체 생성
            if($is_keyword) {
                $oIS = &getModel('mobileex');
                switch($where) {
                    case 'document' :
                            $search_target = Context::get('search_target');
                            if(!in_array($search_target, array('title','content','title_content','tag'))) $search_target = 'title';
                            Context::set('search_target', $search_target);

                            $output = $oIS->getDocuments($target, $module_srl_list, $search_target, $is_keyword, $page, 10);
                            Context::set('output', $output);
                            $this->setTemplateFile("document", $page);
                        break;
                    case 'comment' :
                            $output = $oIS->getComments($target, $module_srl_list, $is_keyword, $page, 10);
                            Context::set('output', $output);
                            $this->setTemplateFile("comment", $page);
                        break;
                    case 'trackback' :
                            $search_target = Context::get('search_target');
                            if(!in_array($search_target, array('title','url','blog_name','excerpt'))) $search_target = 'title';
                            Context::set('search_target', $search_target);

                            $output = $oIS->getTrackbacks($target, $module_srl_list, $search_target, $is_keyword, $page, 10);
                            Context::set('output', $output);
                            $this->setTemplateFile("trackback", $page);
                        break;
                    case 'multimedia' :
                            $output = $oIS->getImages($target, $module_srl_list, $is_keyword, $page,20);
                            Context::set('output', $output);
                            $this->setTemplateFile("multimedia", $page);
                        break;
                    case 'file' :
                            $output = $oIS->getFiles($target, $module_srl_list, $is_keyword, $page, 20);
                            Context::set('output', $output);
                            $this->setTemplateFile("file", $page);
                        break;
                    default :
                            $output['document'] = $oIS->getDocuments($target, $module_srl_list, 'title', $is_keyword, $page, 4);
                            $output['comment'] = $oIS->getComments($target, $module_srl_list, $is_keyword, $page, 4);
                            $output['trackback'] = $oIS->getTrackbacks($target, $module_srl_list, 'title', $is_keyword, $page, 4);
                            $output['multimedia'] = $oIS->getImages($target, $module_srl_list, $is_keyword, $page, 4);
                            $output['file'] = $oIS->getFiles($target, $module_srl_list, $is_keyword, $page, 4);
                            Context::set('search_result', $output);
                            $this->setTemplateFile("index", $page);
                        break;
                }
            } else {
                $this->setTemplateFile("no_keywords");
            }
        }

        /**
         * @brief 코멘트 리스트 컴파일
         **/
         
    		function getMobileexCommentList() {
    			$document_srl = Context::get('document_srl');
    			$targetModule = Context::get('target_module'); 
    			$targetSkin = Context::get('skin_name'); 
    			$last_comment_srl = Context::get('last_comment_srl'); // 추가해야함
    			$view_count = Context::get('view_count'); // 추가해야함
	
    			if(!$last_comment_srl) $last_comment_srl = 0; //기본값
    			if(!$view_count) $view_count = 5; //기본값
    			
    			if(!$document_srl) return new Object(-1, "msg_invalid_request");
    			if(!$targetModule) return new Object(-1, "msg_invalid_request");
    			if(!$targetSkin) return new Object(-1, "msg_invalid_request");
    			
    			$oDocumentModel =& getModel('document');
			   $oDocument = $oDocumentModel->getDocument($document_srl);
			   if(!$oDocument->isExists()) return new Object(-1, "msg_invalid_request");
			   Context::set('oDocument', $oDocument);
    			
    			$oMobileexModel = &getModel('mobileex');
    			$comment_list = $oMobileexModel->getMobileexCommentList($document_srl, $last_comment_srl, $view_count);
    			if(!$comment_list) return new Object(-1, "msg_invalid_request");
			   Context::set('comment_list', $comment_list->get('list'));
			   Context::set('total', $comment_list->get('total'));
    			
    			$templatePath = sprintf('./modules/%s/m.skins/%s/compile', $targetModule, $targetSkin);
    			
    			$oTemplate = new TemplateHandler;
    			$html = $oTemplate->compile($templatePath, "comment_list.html");
    			$this->add("html", $html);
    		}

        /**
         * @brief 서브 코멘트 리스트 컴파일
         **/
         
    		function getMobileexSubCommentList() {
    			$document_srl = Context::get('document_srl');
    			$targetModule = Context::get('target_module'); 
    			$targetSkin = Context::get('skin_name'); 
    			$paginate = Context::get('paginate'); // 추가해야함
    			$view_count = Context::get('view_count'); // 추가해야함
    			$up_category = Context::get('up_category'); // 추가해야함

    			if(!$paginate) $paginate = 1; //기본값
    			if(!$view_count) $view_count = 20; //기본값
    			
    			if(!$up_category) return new Object(-1, "msg_invalid_request");
    			if(!$document_srl) return new Object(-1, "msg_invalid_request");
    			if(!$targetModule) return new Object(-1, "msg_invalid_request");
    			if(!$targetSkin) return new Object(-1, "msg_invalid_request");
    			
    			$oDocumentModel =& getModel('document');
			   $oDocument = $oDocumentModel->getDocument($document_srl);
			   if(!$oDocument->isExists()) return new Object(-1, "msg_invalid_request");
			   Context::set('oDocument', $oDocument);
           
    			$oMobileexModel = &getModel('mobileex');
    			$comment_list = $oMobileexModel->getMobileexSubCommentList($up_category, $paginate, $view_count);
    			if(!$comment_list) return new Object(-1, "msg_invalid_request");
			   Context::set('comment_list', $comment_list->get('list'));
			   Context::set('total', $comment_list->get('total'));
    			
    			$templatePath = sprintf('./modules/%s/m.skins/%s/compile', $targetModule, $targetSkin);
    			
    			$oTemplate = new TemplateHandler;
    			$html = $oTemplate->compile($templatePath, "comment_sub_list.html");
    			$this->add("html", $html);
    		}

}


?>
