<?php
    /**
     * The admin view class of the mobileex module
     * @author COMSIN (comsinnet@naver.com)
     **/

    class mobileexAdminView extends mobileex {

	/**
	 * Cofiguration of mobileex module
	 *
	 * @var object module config
	 */
        var $config = null;

        /**
         * Initialization
		 * @return void
         **/
         
        function init() {
            // Get configurations (using module model object)
            $oModuleModel = &getModel('module');
            $this->config = $oModuleModel->getModuleConfig('mobileex');
            Context::set('config',$this->config);
            $this->setTemplatePath($this->module_path."/tpl/");
            
            // xe core version check
            $xe_version =  preg_match('/^1.5/', __ZBXE_VERSION__) ? '5' : '4';
            Context::set('xe_version',$xe_version);
        }

        /**
         * Module selection
		   * @return Object
         **/
         
        function dispMobileexAdminConfig() {
            $oModuleModel = &getModel('module');
            
		    	$mskin_list = $oModuleModel->getSkins($this->module_path, "m.skins");
			   Context::set('mskin_list', $mskin_list);
			   
            // Get a list of module categories
            $module_categories = $oModuleModel->getModuleCategories();
            // Generated mid Wanted list
            $obj->site_srl = 0;
            $mid_list = $oModuleModel->getMidList($obj);
             Context::set('mid_list',$module_categories); //maybe not used
             
			   $security = new Security();
			   $security->encodeHTML('mskin_list..title');
			   
            // sample code
            Context::set('sample_code', htmlspecialchars('<form action="{getUrl()}" method="get"><input type="hidden" name="vid" value="{$vid}" /><input type="hidden" name="mid" value="{$mid}" /><input type="hidden" name="act" value="MEIS" /><input type="text" name="is_keyword" class="inputTypeText" value="{$is_keyword}" /><span class="button"><input type="submit" value="{$lang->cmd_search}" /></span></form>') );

            $this->setTemplateFile("index");
        }

    }
?>
