<?php

    /**
     * @class  mobileexModel
     * @brief  mobileex model class
     **/

    class mobileexModel extends mobileex {
        /**
         * Initialization
		 *
		 * @return void
         **/
        function init() {
        }
        
        /**
         * file ext check
         **/
        function getAllowedFileType($file_info,$module_srl) {
        	     $oModuleModel = &getModel('module');
        	     $oFileModel = &getModel('file');
        	     $mobileex_config = $oModuleModel->getModuleConfig('mobileex');
        	     
        	     
        	     if($mobileex_config->file_config_use == 'Y') $file_config = $mobileex_config;
        	     else $file_config = $oFileModel->getFileConfig($module_srl);
             
             $logged_info = Context::get('logged_info');
             $allow_filetype->allowed = true;

             // get file_ext
               $file_name = $file_info['name'];
               $file_name_ext = strrchr($file_name,".");
               $allow_filetype->file_ext = $file_name_ext;
               
             // allow file ext check

             $allowed_filetypes = $file_config->allowed_filetypes;
             
             if(!$allowed_filetypes || $allowed_filetypes == '*.*') $allow_filetype->allowed = true;
             else {
             	$allowed_filetypes = str_replace('*', '', $allowed_filetypes); 
             	$allowed_filetypes = str_replace(';', '', $allowed_filetypes); 
             	if(!eregi($file_name_ext,$allowed_filetypes) && $logged_info->is_admin != 'Y') $allow_filetype->allowed = false; 
             	else $allow_filetype->allowed = true;
             }

        	    return $allow_filetype;
        }
        /**
         * file size check
         **/
        function getAllowedFileSize($file_size,$module_srl,$upload_target_srl,$type=null) {
        	    $oModuleModel = &getModel('module');
             $mobileex_config = $oModuleModel->getModuleConfig('mobileex');
        	    $oFileModel = &getModel('file');
        	    $file_config = $oFileModel->getUploadConfig();

             
             $logged_info = Context::get('logged_info');
             

             // allowe file size check
             if($logged_info->is_admin == 'Y') {
             	 
                $allow_filesize->allowed_filesize = true;
                $allow_filesize->allowed_attach_size = true;
             
             } else {
             	
                	  if($mobileex_config->file_config_use == 'Y') {
                     $allowed_filesize = (int)$mobileex_config->allowed_filesize * 1024 * 1024; 
                     $allowed_attach_size = (int)$mobileex_config->allowed_attach_size * 1024 * 1024;  
                	  }
                	  else {
                     $allowed_filesize = (int)$file_config->allowed_filesize * 1024 * 1024; 
                     $allowed_attach_size = (int)$file_config->allowed_attach_size * 1024 * 1024;  
                	  }
   
                   // filesize
                   if($allowed_filesize < (int)$file_size) $allow_filesize->allowed_filesize = false;
                   else $allow_filesize->allowed_filesize = true;
                   
                   // atached file
                   $size_args->upload_target_srl = $upload_target_srl;
                   $output = executeQuery('file.getAttachedFileSize', $size_args);
                   $attached_size = (int)$output->data->attached_size + (int)$file_size;
                   if($attached_size > $allowed_attach_size) $allow_filesize->allowed_attach_size = false;
                   else $allow_filesize->allowed_attach_size = true;
                 
             }

             
             return $allow_filesize;
        }
        
        /**
         * upload grant check
         **/
        function getUploadGrant($module_srl,$type) {
        	
        	   $oEditorModel = &getModel('editor');

        	   // get editor config
            $editor_config = $oEditorModel->getEditorConfig($module_srl);
            if($type == 'document')  $config->upload_file_grant = $editor_config->upload_file_grant;
            else $config->upload_file_grant = $editor_config->comment_upload_file_grant;
            
            // get member config
            if(Context::get('is_logged')) {
                $logged_info = Context::get('logged_info');
                $group_list = $logged_info->group_list;
            } else {
                $group_list = array();
            }
            
            $allow_fileupload = false;
            
            // upload grant check
            if(count($config->upload_file_grant)) {
                foreach($group_list as $group_srl => $group_info) {
                    if(in_array($group_srl, $config->upload_file_grant)) {
                        $allow_fileupload = true;
                        break;
                    }
                }
            } else $allow_fileupload = true;
            
            // is admin check
            if($logged_info->is_admin) $allow_fileupload = true;
             
          return $allow_fileupload;
        }

        /**
         * Get Mobile document
         **/
        function getMobileDocument($document_srl) {
            $args->document_srl = $document_srl;
            return executeQueryArray('mobileex.getMobileDocument', $args);
        }

        /**
         * Get Mobile documents
         **/
        function getMobileDocuments($module_srl) {
            $args->module_srl = $module_srl;
            return executeQueryArray('mobileex.getMobileDocuments', $args);
        }
        
        /**
         * Get add file
         **/
        function getMobileAddfile($file_srl) {
            $args->file_srl = $file_srl;
            return executeQueryArray('mobileex.getMobileAddfile', $args);
        }

        /**
         * Get add files
         **/
        function getMobileAddfiles($document_srl) {
            $args->upload_target_srl = $document_srl;
            $args->sort_index = 'regdate';
            return executeQueryArray('mobileex.getMobileAddfiles', $args);
        }
        
        /**
         * Get module add file
         **/
        function getMobileModuleAddfiles($module_srl) {
             $args->module_srl = $module_srl;
            return executeQueryArray('mobileex.getMobileModuleAddfiles', $args);
        }
        
        /**
         * Get module add file list
         **/
        function getMobileAddFileList($document_srl) {
             $args->upload_target_srl = $document_srl;
             $output = executeQueryArray('mobileex.getMobileAddfileList', $args);
             
             return $output;
        }
        
        /**
         * get file thumbnail
         **/

        function getFileThumbnail($file_srl,$width = 80, $height = 0, $thumbnail_type = '') {
            // file_srl check
            if(!$file_srl) return;

            // height check
            if(!$height) $height = $width;

            // thumbnail_type check
            if(!in_array($thumbnail_type, array('crop','ratio'))) $thumbnail_type = 'ratio'; 

            // thumbnail info
            $_thumbnail_path = "m".getNumberingPath($file_srl, 3);
            $thumbnail_path = sprintf('files/cache/thumbnails/%s',$_thumbnail_path);
            $thumbnail_file = sprintf('%s%dx%d.%s.jpg', $thumbnail_path, $width, $height, $thumbnail_type);
            $thumbnail_url  = Context::getRequestUri().$thumbnail_file;

            // thumbnail exist check
            if(file_exists($thumbnail_file)) {
                if(filesize($thumbnail_file)<1) return false;
                else return $thumbnail_url;
            }

           // get img file

           $oFileModel = &getModel('file');
           $file = $oFileModel->getFile($file_srl);

           if($file->direct_download!='Y') return false;
           if(!preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$file->source_filename)) return false;

           $source_file = $file->uploaded_filename;
           
           if(!file_exists($source_file)) return false;
           else $output = FileHandler::createImageFile($source_file, $thumbnail_file, $width, $height, 'jpg', $thumbnail_type);

          if($output) return $thumbnail_url;
          else FileHandler::writeFile($thumbnail_file, '','w');

          return;
        }
        
        function getImgResizeValue($file,$maxwidth,$maxheight = 0) {
        	  $whgab = $maxwidth - $maxheight;
          $imgsize = getimagesize($file); 

                if($maxwidth > 0 && $maxheight > 0) {
                  if($imgsize[0] > $maxwidth && $imgsize[1] > $maxheight) {
                  	   $gabwidth = $imgsize[0] - $maxwidth;
                  	   $gabheight = $imgsize[1] - $maxheight;
                  	   $gabwh = $gabwidth - $gabheight;

                  	   if($gabwh > 0) $resize_target = 'W';
                  	   elseif($gabwh < 0) $resize_target = 'H';
                  	   else {
                  	   	if($whgab > 0 ) $resize_target = 'H';
                  	   	else $resize_target = 'W';
                  	   }
                  }
                  elseif($imgsize[0] > $maxwidth) $resize_target = 'W';
                  elseif($imgsize[1] > $maxheight) $resize_target = 'H';
                  else $resize_target = '';
                }
                
                elseif($maxwidth > 0) {
                	    if($imgsize[0] > $maxwidth) $resize_target = 'W';
                	    else $resize_target = '';
                }
                elseif($maxheight > 0) {
                	    if($imgsize[1] > $maxheight) $resize_target = 'H';
                	    else $resize_target = '';
                }
                else $resize_target = '';
                
                if($resize_target == 'W') {
                 	   	$img_width = $maxwidth;
                 	   	$img_height = ceil(($imgsize[1] / $imgsize[0]) * $maxwidth);
                }
                elseif($resize_target == 'H') {
                 	   	$img_height = $maxheight;
                 	   	$img_width = ceil(($imgsize[0] / $imgsize[1]) * $maxheight);
                }
                else {
                 	   $img_width = null;
                 	   $img_height = null;
                }
                
                 $resizeimg->width= $img_width;
                 $resizeimg->height = $img_height;
       
                 return $resizeimg;
        }
        
        /**
         * @mobileex integrantion search 0.3
         * @brief Խñ ˻
         **/
        function getDocuments($target, $module_srls_list, $search_target, $search_keyword, $page=1, $list_count = 20) {
            if(is_array($module_srls_list)) $module_srls_list = implode(',',$module_srls_list);

            if($target == 'exclude') {
				$module_srls_list .= ',0'; // exclude 'trash'
				if ($module_srls_list{0} == ',') $module_srls_list = substr($module_srls_list, 1);
            	$args->exclude_module_srl = $module_srls_list;
            } else {
            	$args->module_srl = $module_srls_list;
            	$args->exclude_module_srl = '0'; // exclude 'trash'
            }

            $args->page = $page;
            $args->list_count = $list_count;
            $args->page_count = 10;
            $args->search_target = $search_target;
            $args->search_keyword = $search_keyword;
            $args->sort_index = 'list_order'; 
            $args->order_type = 'asc';
            if(!$args->module_srl) unset($args->module_srl);

            //   
            $oDocumentModel = &getModel('document');

            return $oDocumentModel->getDocumentList($args);
        }

        /**
         * @brief  ˻
         **/
        function getComments($target, $module_srls_list, $search_keyword, $page=1, $list_count = 20) {
            if(is_array($module_srls_list)) $module_srls = implode(',',$module_srls_list);
            else $module_srls = $module_srls_list;
            if($target == 'exclude') $args->exclude_module_srl = $module_srls;
            else $args->module_srl = $module_srls;
            $args->page = $page;
            $args->list_count = $list_count;
            $args->page_count = 10;
            $args->search_target = 'content';
            $args->search_keyword = $search_keyword;
            $args->sort_index = 'list_order'; 
            $args->order_type = 'asc';

            //   
            $oCommentModel = &getModel('comment');
            $output = $oCommentModel->getTotalCommentList($args);
            if(!$output->toBool()|| !$output->data) return $output;
            return $output;
        }

        /**
         * @brief α ˻
         **/
        function getTrackbacks($target, $module_srls_list, $search_target = "title", $search_keyword, $page=1, $list_count = 20) {
            if(is_array($module_srls_list)) $module_srls = implode(',',$module_srls_list);
            else $module_srls = $module_srls_list;
            if($target == 'exclude') $args->exclude_module_srl = $module_srls;
            else $args->module_srl = $module_srls;
            $args->page = $page;
            $args->list_count = $list_count;
            $args->page_count = 10;
            $args->search_target = $search_target;
            $args->search_keyword = $search_keyword;
            $args->sort_index = 'list_order'; 
            $args->order_type = 'asc';

            //   
            $oTrackbackModel = &getAdminModel('trackback');
            $output = $oTrackbackModel->getTotalTrackbackList($args);
            if(!$output->toBool()|| !$output->data) return $output;
            return $output;
        }

        /**
         * @brief  ˻
         **/
        function _getFiles($target, $module_srls_list, $search_keyword, $page, $list_count, $direct_download = 'Y') {
            if(is_array($module_srls_list)) $module_srls = implode(',',$module_srls_list);
            else $module_srls = $module_srls_list;
            if($target == 'exclude') $args->exclude_module_srl = $module_srls;
            else $args->module_srl = $module_srls;
            $args->page = $page;
            $args->list_count = $list_count;
            $args->page_count = 10;
            $args->search_target = 'filename';
            $args->search_keyword = $search_keyword;
            $args->sort_index = 'files.file_srl'; 
            $args->order_type = 'desc';
            $args->isvalid = 'Y';
            $args->direct_download = $direct_download=='Y'?'Y':'N';

            //   
            $oFileAdminModel = &getAdminModel('file');
            $output = $oFileAdminModel->getFileList($args);
            if(!$output->toBool() || !$output->data) return $output;

            $list = array();
            foreach($output->data as $key => $val) {
                $obj = null;
                $obj->filename = $val->source_filename;
                $obj->download_count = $val->download_count;
                if(substr($val->download_url,0,2)=='./') $val->download_url = substr($val->download_url,2);
                $obj->download_url = Context::getRequestUri().$val->download_url;
                $obj->target_srl = $val->upload_target_srl;
                $obj->file_size = $val->file_size;

                // ̹ 
                if(preg_match('/\.(jpg|jpeg|gif|png)$/i', $val->source_filename)) {
                    $obj->type = 'image';

                    $thumbnail_path = sprintf('files/cache/thumbnails/%s',getNumberingPath($val->file_srl, 3));
                    if(!is_dir($thumbnail_path)) FileHandler::makeDir($thumbnail_path);
                    $thumbnail_file = sprintf('%s%dx%d.%s.jpg', $thumbnail_path, 70, 70, 'crop');
                    $thumbnail_url  = Context::getRequestUri().$thumbnail_file;
                    if(!file_exists($thumbnail_file)) FileHandler::createImageFile($val->uploaded_filename, $thumbnail_file, 70, 70, 'jpg', 'crop');
                    $obj->src = sprintf('<img src="%s" alt="%s" width="%d" height="%d" />', $thumbnail_url, htmlspecialchars($obj->filename), 70, 70);

                // 
                } elseif(preg_match('/\.(swf|flv|wmv|avi|mpg|mpeg|asx|asf|mp3)$/i', $val->source_filename)) {
                    $obj->type = 'multimedia';
                    $obj->src = sprintf('<script type="text/javascript">displayMultimedia("%s",80,80);</script>', $obj->download_url);

                // Ÿ
                } else {
                    $obj->type = 'binary';
                    $obj->src = '';
                }

                $list[] = $obj;
                $target_list[] = $val->upload_target_srl;
            }
            $output->data = $list;

            $oDocumentModel = &getModel('document');
            $document_list = $oDocumentModel->getDocuments($target_list);
            if($document_list) foreach($document_list as $key => $val) {
                foreach($output->data as $k => $v) {
                    if($v->target_srl== $val->document_srl) {
                        $output->data[$k]->url = $val->getPermanentUrl();
                        $output->data[$k]->regdate = $val->getRegdate("Y-m-d H:i");
                        $output->data[$k]->nick_name = $val->getNickName();
                    }
                }
            }

            $oCommentModel = &getModel('comment');
            $comment_list = $oCommentModel->getComments($target_list);
            if($comment_list) foreach($comment_list as $key => $val) {
                foreach($output->data as $k => $v) {
                    if($v->target_srl== $val->comment_srl) {
                        $output->data[$k]->url = $val->getPermanentUrl();
                        $output->data[$k]->regdate = $val->getRegdate("Y-m-d H:i");
                        $output->data[$k]->nick_name = $val->getNickName();
                    }
                }
            }

            return $output;
        }

        /**
         * @brief Ƽ̵ ˻
         **/
        function getImages($target, $module_srls_list, $search_keyword, $page=1, $list_count = 20) {
            return $this->_getFiles($target, $module_srls_list, $search_keyword, $page, $list_count);
        }

        /**
         * @brief ÷ ˻
         **/
        function getFiles($target, $module_srls_list, $search_keyword, $page=1, $list_count = 20) {
            return $this->_getFiles($target, $module_srls_list, $search_keyword, $page, $list_count, 'N');
        }
        
    }
?>
