<?php
    /**
     * @class  smartux
     * @author 그냥재미로
     * @brief  smartux 모듈의 high class
     **/

    class smartux extends ModuleObject {

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {

        	$oModuleController = &getController('module');
        	$oModuleModel = &getModel('module');
        	
        	// Document Insert Trigger
        	$oModuleController->insertTrigger('document.insertDocument', 'smartux', 'controller', 'triggerInsertDocument', 'after');
        	
        	// Comment Insert Trigger
        	$oModuleController->insertTrigger('comment.insertComment', 'smartux', 'controller', 'triggerInsertComment', 'after');

        	// Member Insert Trigger
        	$oModuleController->insertTrigger('member.insertComment', 'smartux', 'controller', 'triggerInsertMember', 'after');
        	
        	// communication sendMessage Trigger (쪽지 알림 기능을 사용하려면 주석을 제거하세요)
        	// XE Core 에는 쪽지 트리거가 없으니 쪽지 알림기능을 사용하려면 트리거를 추가해주세요
        	// ( 파일 :/modules/communication.controller.php )
//         	function sendMessage($sender_srl, $receiver_srl, $title, $content, $sender_log = true) {
// 				...
// 				...
//         		$oDB->commit();        	
//         		// Call a trigger (after) [smartux add]
//         		ModuleHandler::triggerCall('communication.sendMessage', 'after', $receiver_args);        	
//         		return new Object(0,'success_sended');
//         	}

        	$oModuleController->insertTrigger('communication.sendMessage', 'smartux', 'controller', 'triggerCommunicationSendMessage', 'after');
        	
            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {

        	$oDB = &DB::getInstance();
        	$oModuleModel = &getModel('module');
        	$oModuleController = &getController('module');
        
        	// Document Insert Trigger
        	if (!$oModuleModel->getTrigger('document.insertDocument', 'smartux', 'controller', 'triggerInsertDocument', 'after'))
        	{
        		return true;
        	}
        	// Comment Insert Trigger
        	if (!$oModuleModel->getTrigger('comment.insertComment', 'smartux', 'controller', 'triggerInsertComment', 'after'))
        	{
        		return true;
        	}
        	
        	// Member Insert Trigger
        	if (!$oModuleModel->getTrigger('member.insertMember', 'smartux', 'controller', 'triggerInsertMember', 'after'))
        	{
        		return true;
        	}

        	// communication sendMessage Trigger 
        	if (!$oModuleModel->getTrigger('communication.sendMessage', 'smartux', 'controller', 'triggerCommunicationSendMessage', 'after'))
        	{
        		return true;
        	}        	
        	return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {

        	$oDB = &DB::getInstance();
        	$oModuleModel = &getModel('module');
        	$oModuleController = &getController('module');
        	
        	// Document Insert Trigger
        	if (!$oModuleModel->getTrigger('document.insertDocument', 'smartux', 'controller', 'triggerInsertDocument', 'after'))
        	{
        		$oModuleController->insertTrigger('document.insertDocument', 'smartux', 'controller', 'triggerInsertDocument', 'after');
        	}
        	
        	// Comment Insert Trigger
        	if (!$oModuleModel->getTrigger('comment.insertComment', 'smartux', 'controller', 'triggerInsertComment', 'after'))
        	{
        		$oModuleController->insertTrigger('comment.insertComment', 'smartux', 'controller', 'triggerInsertComment', 'after');
        	}
        	
        	// Member Insert Trigger
        	if (!$oModuleModel->getTrigger('member.insertMember', 'smartux', 'controller', 'triggerInsertMember', 'after'))
        	{
        		$oModuleController->insertTrigger('member.insertMember', 'smartux', 'controller', 'triggerInsertMember', 'after');
        	}        	
        	
        	// communication sendMessage Trigger
        	if (!$oModuleModel->getTrigger('communication.sendMessage', 'smartux', 'controller', 'triggerCommunicationSendMessage', 'after'))
        	{
        		$oModuleController->insertTrigger('communication.sendMessage', 'smartux', 'controller', 'triggerCommunicationSendMessage', 'after');
        	}
        	 
        	 
            return new Object(0, 'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }

        

        
    }
?>
