<?php
    /**
     * @class  smartuxView
     * @author 그냥재미로
     * @brief smartux 모듈의 view class
     **/
	define("_XE_PATH_", str_replace("modules/smartux/smartux.api.php", "", str_replace("\\", "/", __FILE__)));
	require_once(_XE_PATH_."config/config.inc.php");
    class smartuxAPI extends smartux {


         /**
         * @brief
         * 디바이스 알림수신 등록, 해제 API. 
         **/    
		function dispSmartUXRegisterDeviceAPI(&$oModule)
		{
			$args = Context::getRequestVars();			
			$logged_info = Context::get("logged_info");
			if( !$logged_info ) return new Object(-1, 'msg_not_permitted');
				
			$args->member_srl = $logged_info->member_srl;
			$args->user_id = $logged_info->user_id;
			$args->user_name = $logged_info->user_name;
			$args->nick_name = $logged_info->nick_name;						
debugprint($args);			
			$oSmartuxModel = &getModel("smartux");
			$model = $oSmartuxModel->_dispSmartUXRegisterDeviceAPI($args);						 
			$oSmartuxController = &getController("smartux");
			$controller = $oSmartuxController->_dispSmartUXRegisterDeviceAPI($args);
			 
// 			$oModule->add("model",$model->model);
// 			$oModule->add("controller",$controller->controller);
			
		}
		
		/**
		 * @brief
		 * 디바이스 알림수신 모두해제 API.
		 **/
		function dispSmartUXUnRegisterAllDeviceAPI(&$oModule)
		{
debugprint("dispSmartUXUnRegisterAllDeviceAPI -> api");

//TODO member_srl 로 등록된 알림수신을 모두 해제한다.
			
// 			$args = Context::getRequestVars();
			$logged_info = Context::get("logged_info");
			if(!$logged_info)
			{
				debugprint("로그인이 필요합니다");
				$actionMessage = "need_login";
			}
			else
			{
				debugprint("로그인 되어있음");
				debugprint($logged_info);
				$oSmartuxModel = &getModel('smartux');				
				$output = $oSmartuxModel->_dispSmartUXUnRegisterAllDeviceAPI($logged_info);				
				$actionMessage = "action_success";
			}

			$oModule->add("action_message", $actionMessage);
				
		}
		
		/**
		 * @brief
		 * 수신가능한 알림 목록 API
		 **/
		function dispSmartUXMemberNotficationListAPI(&$oModule)
		{
			debugprint("dispSmartUXMemberNotficationListAPI - api");
			
			//$oContext = &Context::getInstance();
			
			$args = Context::getRequestVars();
				
			
			//API 테스트 파일 직접호출
			if($args->member_srl){
				debugprint("API 테스트 ");
				debugprint($args->member_srl);
				
				// 수신가능한 알림 목록 반환
				$oSmartuxModel = &getModel('smartux');								
				$result = $oSmartuxModel->getSmartuxMemberNotificationList($args);					
				debugprint("알림목록반환");
				debugprint($result);
				$resultMessage = "server_file_direct_call";
				
			}else{
				// 단말기에서 API 호출
				// 로인정보 확인 (API 호출시 쿠키를 함께 받아야 정보확인 가능.)
				$logged_info = Context::get("logged_info");
				debugprint("회원정보 - 단말기 로그인");
				debugprint($logged_info);								

				if(!$logged_info)
				{
					debugprint("로그인이 필요합니다");
					$actionMessage = "need_login";
				}
				else
				{
					$oModule->setMessage("logged_");
					debugprint("로그인 되어있음");
					debugprint($logged_info);
						
					//$oModuleModel = &getModel('module');
					
					// 수신가능한 알림 목록 반환
					$oSmartuxModel = &getModel('smartux');						
					$result = $oSmartuxModel->getSmartuxMemberNotificationList($logged_info);
									
					debugprint("알림목록반환");
					debugprint($result);
					$actionMessage = "action_success";
				}
				
			}

			
			$oModule->add("action_message", $actionMessage);
			$oModule->add("module_info",$result);
			
			

			

			
// 			// 로그인 정보확인 #1
// 			// $oMemberModel = &getModel('member');
// 			// $logged_info = $oMemberModel->getLoggedInfo();
// 			//
// 			// 로그인 정보확인 #2
// 			// $oContext = &Context::getInstance();
// 			// $oContext->init();
// 			// $logged_info = Context::get("logged_info");
			

// 			//TODO 알림목록 조회 반환.			
			        	
// //         	$oMemberModel = &getModel('member');
// //         	$logged_info = $oMemberModel->getLoggedInfo();
        	
						
// // 			$oSmartuxController = &getController("smartux");
// // 			$controller = $oSmartuxController->_dispSmartUXMemberNotficationListAPI();

// 			$oSmartuxModel = &getModel('smartux');				
// 			// 수신가능한 알림 목록 반환
// 			$result = $oSmartuxModel->getSmartuxMemberNotificationList($args);
			
// 			debugprint("알림목록반환");
// 			debugprint($result);
			
// 			//class/display/XMLDisplayHandler.php 에서 xml 로 변환 함.
// 			//api 수행결과 리턴
// // 			$oModule->add("model",$model->model);
			
								
		}
		
    }
?>