<?php
    /**
     * @class  smartuxAdminView
     * @author 그냥재미로
     * @brief  smartux 모듈의 admin view class
     **/

    class smartuxAdminView extends smartux {

    	var $group_list;
    	
        /**
         * @brief 초기화
         **/
        function init() {
        	/**/
			$oMemberModel = &getModel('member');
	
			// group 목록 가져오기
			$this->group_list = $oMemberModel->getGroups();
			Context::set('group_list', $this->group_list);
			
			// 관리자 템플릿 파일의 경로 설정 (tpl)
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
            
            $this->setTemplatePath($this->module_path.'tpl');           
                        
		}

		/**
		 * @brief admin config
		 **/		
		function dispSmartuxAdminConfig()
		{
			$oModuleModel = &getModel('module');
			$oSmartuxAdminModel = &getAdminModel('smartux');
			
			
			$config = $oSmartuxAdminModel->getConfig();
			Context::set('config', $config);
		
			$skin_list = $oModuleModel->getSkins($this->module_path);
			Context::set('skin_list', $skin_list);
		
			if(!$skin_list[$config->skin]) $config->skin = 'default';
			Context::set('colorset_list', $skin_list[$config->skin]->colorset);
		
			if(version_compare(__ZBXE_VERSION__, '1.5', '<'))
			{
				$this->setTemplateFile('config_1_4');

			}
			else
			{
				$security = new Security();
				$security->encodeHTML('config..');
				$security->encodeHTML('skin_list..title');
				$security->encodeHTML('colorset_list..name','colorset_list..title');
				$this->setTemplateFile('config');

			}
			
		}
		
        /**
         * @brief admin index list
         **/
		function dispSmartuxAdminIndex(){						
			$oSmartuxAdminModel = &getAdminModel('smartux');
			$oMemberModel = &getModel('member');			

			$output = $oSmartuxAdminModel->getSmartuxNotificationList();			
			
			$notification_list = array();								
			if ($output->toBool() && $output->data)
			{
				$notification_list = $output->data;
			}
			
			Context::set('list', $notification_list);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('page_navigation', $output->page_navigation);
						
			if(version_compare(__ZBXE_VERSION__, '1.5', '<'))
			{
				$this->setTemplateFile('index_1_4');				
			}
			else
			{			
				$this->setTemplateFile('index');
			}
			
		}

		/**
		 * @brief admin 알림대상 모듈 추가, 수정
		 **/
		function dispSmartuxAdminInsert(){
			
			$smartux_srl = Context::get('smartux_srl');

			if($smartux_srl){
				$args->smartux_srl = $smartux_srl;
				$output = executeQuery("smartux.getNotificationBySrl", $args);
				$notification = $output->data;
debugprint($output);				
				Context::set('notification', $notification);
			}
						
			Context::set('config', $config);

			//가능 대상 모듈 목록 가져오기
			$oSmartuxModel = &getAdminModel('smartux');			
			$args->sort_index = 'mid';			
			$args->module = 'board';
			$target_modules = $oSmartuxModel->getSmartuxMidList($args);

			// 기본모듈 ( 쪽지 1, 댓글 2, 새글모두3 , 댓글모두4, 회원가입 5)
			$smartuxModule = new stdClass;

			$smartuxModule->message->module_srl = "1";
			$smartuxModule->message->module = "message";
			$smartuxModule->message->browser_title = "쪽지 알림";
			
			$smartuxModule->comment->module_srl = "2";
			$smartuxModule->comment->module = "comment";
			$smartuxModule->comment->browser_title = "댓글 알림";				
			
			$smartuxModule->documentall->module_srl = "3";
			$smartuxModule->documentall->module = "board";
			$smartuxModule->documentall->browser_title = "새글 알림 (전체 게시판의 새글)";

			$smartuxModule->commentall->module_srl = "4";
			$smartuxModule->commentall->module = "board";
			$smartuxModule->commentall->browser_title = "댓글 알림 (전체 게시판의 댓글)";

			$smartuxModule->member_signup->module_srl = "5";
			$smartuxModule->member_signup->module = "member";
			$smartuxModule->member_signup->browser_title = "회원가입 알림";
			
			$target_modules = (object) array_merge((array)$smartuxModule, (array)$target_modules);
						
			Context::set('target_modules', $target_modules);

			if(version_compare(__ZBXE_VERSION__, '1.5', '<'))
			{
				$this->setTemplateFile('insert_1_4');
			}
			else
			{
				$this->setTemplateFile('insert');
				
			}
			
		}
		
		
		
		/**
		 * @brief admin 알림대상 모듈 삭제 (XE 1.4.x only).
		 **/
		function dispSmartuxAdminDelete(){
			
			$smartux_srl = Context::get('smartux_srl');
			
			if(!$smartux_srl) return new Object(-1, 'msg_not_information');				

			if($smartux_srl){
				$args->smartux_srl = $smartux_srl;
				$output = executeQuery("smartux.getNotificationBySrl", $args);
				$notification = $output->data;
				Context::set('notification', $notification);
			}
			
			$this->setTemplateFile('delete_1_4');			
		}
		
		/**
		 * @brief Select a member
		 **/
		function dispSmartuxAdminMemberSelectList()
		{
			if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');
			
			$oSmartuxAdminModel = &getAdminModel('smartux');
			$oMemberModel = &getModel('member');
			$output = $oSmartuxAdminModel->getSmartuxMemberList();
		
			
			$filter = Context::get('filter_type');
			global $lang;
			switch($filter){
				case 'super_admin' : Context::set('filter_type_title', $lang->cmd_show_super_admin_member);break;
				case 'site_admin' : Context::set('filter_type_title', $lang->cmd_show_site_admin_member);break;
				case 'enable' :  Context::set('filter_type_title', $lang->approval);break;
				case 'disable' : Context::set('filter_type_title', $lang->denied);break;
				default : Context::set('filter_type_title', $lang->cmd_show_all_member);break;
			}
			// retrieve list of groups for each member
			if($output->data) {
				foreach($output->data as $key => $member)
				{
					$output->data[$key]->group_list = $oMemberModel->getMemberGroups($member->member_srl,0);
				}
			}
			
			$config = $oMemberModel->getMemberConfig();
			$memberIdentifiers = array('user_id'=>'user_id', 'user_name'=>'user_name', 'nick_name'=>'nick_name');
			$usedIdentifiers = array();
			
			if (is_array($config->signupForm)){
				foreach($config->signupForm as $signupItem){
					if (!count($memberIdentifiers)) break;
					if(in_array($signupItem->name, $memberIdentifiers) && ($signupItem->required || $signupItem->isUse)){
						unset($memberIdentifiers[$signupItem->name]);
						$usedIdentifiers[$signupItem->name] = $lang->{$signupItem->name};
					}
				}
			}
			
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('member_list', $output->data);
			Context::set('usedIdentifiers', $usedIdentifiers);
			Context::set('page_navigation', $output->page_navigation);
				
			if(version_compare(__ZBXE_VERSION__, '1.5', '>='))
			{
				$security = new Security();
				$security->encodeHTML('member_list..user_name', 'member_list..nick_name', 'member_list..group_list..');
				$security->encodeHTML('id', 'type');
			}

					
			// Set the layout to be pop-up
			$this->setLayoutFile('popup_layout');

			// Set a template file			
			if(version_compare(__ZBXE_VERSION__, '1.5', '<'))
			{
				$this->setTemplateFile('member_selector_1_4');
			}
			else
			{
				$this->setTemplateFile('member_selector');
				
			}

		}
		

	}
?>
