<?php
    /**
     * @class  smartuxAdminModel
     * @author 그냥재미로
     * @brief  smartux 모듈의 admin model class
     **/

    class smartuxAdminModel extends smartux {
    	
    	var $config;
    	
        /**
         * @brief Initialization
         **/
        function init()
        {

        }
        
		/**
         * @brief 삭제대상 정보
         * target Table : smartux_notification
         **/
        function getSmartuxAdminDelete()
        {
        	// get configs.
        	$args->smartux_srl = Context::get('smartux_srl');
        	
        	$output = executeQuery("smartux.getMobileNotificationConfig", $args);
        	$id_list = $output->data->id_list;
        	$group_srl_list = $output->data->group_srl_list;
        	$config = $output->data;
        
        	$args->config_srls = Context::get('config_srls');
        	$output = executeQueryArray("smartux.getMobileNotificationModuleInfoByConfigSrl", $args);
        	$mid_list = array();
        	if ($output->data)
        	{
        		foreach ($output->data as $no => $val)
        		{
        			$mid_list[] = $val->mid;
        		}
        	}
        	$config->mid_list = join(',', $mid_list);
        
        	Context::set('smartux_srl', $args->smartux_srl);
        
        	$oTemplate = &TemplateHandler::getInstance();
        	$tpl = $oTemplate->compile($this->module_path.'tpl', 'delete');
        	$this->add('tpl', str_replace("\n"," ",$tpl));
        }
        

        /**
         * @brief 게시판 목록 
         **/
        function getSmartuxMidList($args = null, $columnList = array()) {
        	$output = executeQuery('smartux.getSmartuxMidList', $args, $columnList);
        	if(!$output->toBool()) return $output;
        
        	$list = $output->data;
        	if(!$list) return;
        
        	if(!is_array($list)) $list = array($list);
        
        	foreach($list as $val) {
        		$mid_list[$val->mid] = $val;
        	}
        	return $mid_list;
        }
        
        
        /**
         * @brief 전체 회원 목록
         * target Table : member
         **/
        function getSmartuxMemberList() {
        	// Search option
        	$args->is_admin = Context::get('is_admin')=='Y'?'Y':'';
        	$args->is_denied = Context::get('is_denied')=='Y'?'Y':'';
        	$args->selected_group_srl = Context::get('selected_group_srl');
        
        	$filter = Context::get('filter_type');
        	switch($filter){
        		case 'super_admin' : $args->is_admin = 'Y';break;
        		case 'site_admin' : $args->member_srls = $this->getSiteAdminMemberSrls();break;
        		case 'enable' : $args->is_denied = 'N';break;
        		case 'disable' : $args->is_denied = 'Y';break;
        	}
        
        	$search_target = trim(Context::get('search_target'));
        	$search_keyword = trim(Context::get('search_keyword'));
        
        	if($search_target && $search_keyword) {
        		switch($search_target) {
        			case 'member_srl' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_member_srl = $search_keyword;
        				break;
        			case 'user_id' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_user_id = $search_keyword;
        				break;
        			case 'user_name' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_user_name = $search_keyword;
        				break;
        			case 'nick_name' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_nick_name = $search_keyword;
        				$args->html_nick_name = htmlspecialchars($search_keyword);
        				break;
        			case 'email_address' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_email_address = $search_keyword;
        				break;

        		}
        	}
        
        	// Change the query id if selected_group_srl exists (for table join)
        	$sort_order = Context::get('sort_order');
        	$sort_index = Context::get('sort_index');
        	
        	
        	if(!$sort_index) {        		
        		if(version_compare(__ZBXE_VERSION__, '1.5', '<'))
        		{        		
        			$sort_index = "member_srl";
        		}else{
        			$sort_index = "member_srl";
        		}
        	}
        
        	if(!$sort_order) {
        		$sort_order = 'asc';
        	}
        
        	if($sort_order != 'asc')
        	{
        		$sort_order = 'desc';
        	}
        
        	if($args->selected_group_srl) {
        		$query_id = 'smartux.getMemberListWithinGroup';
        		$args->sort_index = "member.".$sort_index;
        	} else {
        		$query_id = 'smartux.getMemberList';
        		$args->sort_index = $sort_index;
        	}
        
        	$args->sort_order = $sort_order;
        	Context::set('sort_order', $sort_order);
        	// Other variables
        	$args->page = Context::get('page');
        	$args->list_count = 40;
        	$args->page_count = 10;
        	$output = executeQuery($query_id, $args);
        	        	
        	return $output;
        }
        
        /**
         * @brief 알림서비스 등록 회원 목록
         * target Table : smartux_notification
         **/
        function getSmartuxNotificationList()
        {
        
        	$search_target = trim(Context::get('search_target'));
        	$search_keyword = trim(Context::get('search_keyword'));               	
        	if($search_target && $search_keyword) {
        		switch($search_target) {
        			case 'member_srl' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_member_srl = $search_keyword;
        				break;
        			case 'user_id' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_user_id = $search_keyword;
        				break;
        			case 'user_name' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_user_name = $search_keyword;
        				break;
        			case 'nick_name' :
        				if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
        				$args->s_nick_name = $search_keyword;
        				$args->html_nick_name = htmlspecialchars($search_keyword);
        				break;       
        		}
        	}
        
        	// Change the query id if selected_group_srl exists (for table join)
        	$sort_order = Context::get('sort_order');
        	$sort_index = Context::get('sort_index');
        	if(!$sort_index) {
        		$sort_index = "list_order";
        	}
        
        	if(!$sort_order) {
        		$sort_order = 'asc';
        	}
        
        	if($sort_order != 'asc')
        	{
        		$sort_order = 'desc';
        	}
        
        	$args->sort_order = $sort_order;
        	Context::set('sort_order', $sort_order);

        	$args->page = Context::get('page');
        	$args->list_count = 40;
        	$args->page_count = 10;
        	$output = executeQuery('smartux.getNotificationList', $args);
        	 
        	return $output;
        }
        
        

        /**
         * @brief 모듈 환경 설정
         * target Table : module_config
         **/
		function getConfig()
		{
			if(!$this->config)
			{
				$oModuleModel = &getModel('module');
				$config = $oModuleModel->getModuleConfig('smartux');				
				if(!$config->use) $config->use = 'Y';
				if(!is_array($config->mention_format)) $config->mention_format = explode('|@|', $config->mention_format);
				if(!$config->document_notify) $config->document_notify = 'all-comment';
				if(!$config->skin) $config->skin = 'default';
				if(!$config->colorset) $config->colorset = 'black';
	
				$this->config = $config;
			}
	
			return $this->config;
		}
    }
?>